/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = DiagnosticUtils.getClosestPsiElement((ASTNode)((Object)descriptor2));
        }
        if (element != null) {
            return DiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    public static String atLocation(KtExpression expression2) {
        return DiagnosticUtils.atLocation(expression2.getNode());
    }

    public static String atLocation(@NotNull PsiElement element) {
        if (element == null) {
            DiagnosticUtils.$$$reportNull$$$0(0);
        }
        return DiagnosticUtils.atLocation(element.getNode());
    }

    public static String atLocation(@NotNull ASTNode node) {
        if (node == null) {
            DiagnosticUtils.$$$reportNull$$$0(1);
        }
        int startOffset = node.getStartOffset();
        PsiElement element = DiagnosticUtils.getClosestPsiElement(node);
        if (element != null && element.isValid()) {
            return DiagnosticUtils.atLocation(element.getContainingFile(), element.getTextRange());
        }
        return "' at offset " + startOffset + " (line and file unknown: no PSI element)";
    }

    @Nullable
    public static PsiElement getClosestPsiElement(@NotNull ASTNode node) {
        if (node == null) {
            DiagnosticUtils.$$$reportNull$$$0(2);
        }
        while (node.getPsi() == null) {
            node = node.getTreeParent();
        }
        return node.getPsi();
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        if (node == null) {
            DiagnosticUtils.$$$reportNull$$$0(3);
        }
        PsiElement closestPsiElement = DiagnosticUtils.getClosestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        PsiFile psiFile = closestPsiElement.getContainingFile();
        if (psiFile == null) {
            DiagnosticUtils.$$$reportNull$$$0(4);
        }
        return psiFile;
    }

    @NotNull
    public static String atLocation(@NotNull PsiFile file, @NotNull TextRange textRange) {
        if (file == null) {
            DiagnosticUtils.$$$reportNull$$$0(5);
        }
        if (textRange == null) {
            DiagnosticUtils.$$$reportNull$$$0(6);
        }
        Document document = file.getViewProvider().getDocument();
        String string = DiagnosticUtils.atLocation(file, textRange, document);
        if (string == null) {
            DiagnosticUtils.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String atLocation(PsiFile file, TextRange textRange, Document document) {
        int offset2 = textRange.getStartOffset();
        VirtualFile virtualFile2 = file.getVirtualFile();
        String pathSuffix = " in " + (virtualFile2 == null ? file.getName() : virtualFile2.getPath());
        String string = DiagnosticUtils.offsetToLineAndColumn(document, offset2).toString() + pathSuffix;
        if (string == null) {
            DiagnosticUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            DiagnosticUtils.$$$reportNull$$$0(9);
        }
        PsiFile file = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            LineAndColumn lineAndColumn = LineAndColumn.NONE;
            if (lineAndColumn == null) {
                DiagnosticUtils.$$$reportNull$$$0(10);
            }
            return lineAndColumn;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumnInPsiFile(file, firstRange);
        if (lineAndColumn == null) {
            DiagnosticUtils.$$$reportNull$$$0(11);
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn getLineAndColumnInPsiFile(PsiFile file, TextRange range) {
        Document document = file.getViewProvider().getDocument();
        LineAndColumn lineAndColumn = DiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
        if (lineAndColumn == null) {
            DiagnosticUtils.$$$reportNull$$$0(12);
        }
        return lineAndColumn;
    }

    @NotNull
    public static LineAndColumn offsetToLineAndColumn(@Nullable Document document, int offset2) {
        if (document == null) {
            LineAndColumn lineAndColumn = new LineAndColumn(-1, offset2, null);
            if (lineAndColumn == null) {
                DiagnosticUtils.$$$reportNull$$$0(13);
            }
            return lineAndColumn;
        }
        int lineNumber = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int column = offset2 - lineStartOffset;
        int lineEndOffset = document.getLineEndOffset(lineNumber);
        CharSequence lineContent = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        LineAndColumn lineAndColumn = new LineAndColumn(lineNumber + 1, column + 1, lineContent.toString());
        if (lineAndColumn == null) {
            DiagnosticUtils.$$$reportNull$$$0(14);
        }
        return lineAndColumn;
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges2) {
        if (ranges2 == null) {
            DiagnosticUtils.$$$reportNull$$$0(15);
        }
        TextRange textRange = Collections.min(ranges2, TEXT_RANGE_COMPARATOR);
        if (textRange == null) {
            DiagnosticUtils.$$$reportNull$$$0(16);
        }
        return textRange;
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics) {
        if (diagnostics == null) {
            DiagnosticUtils.$$$reportNull$$$0(17);
        }
        ArrayList<Diagnostic> result2 = Lists.newArrayList(diagnostics);
        result2.sort((d1, d2) -> {
            TextRange range2;
            String path2;
            String path1 = d1.getPsiFile().getViewProvider().getVirtualFile().getPath();
            if (!path1.equals(path2 = d2.getPsiFile().getViewProvider().getVirtualFile().getPath())) {
                return path1.compareTo(path2);
            }
            TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
            if (!range1.equals(range2 = DiagnosticUtils.firstRange(d2.getTextRanges()))) {
                return TEXT_RANGE_COMPARATOR.compare(range1, range2);
            }
            return d1.getFactory().getName().compareTo(d2.getFactory().getName());
        });
        ArrayList<Diagnostic> arrayList = result2;
        if (arrayList == null) {
            DiagnosticUtils.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static boolean hasError(Diagnostics diagnostics) {
        for (Diagnostic diagnostic : diagnostics.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "atLocation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumnInPsiFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLineAndColumn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "firstRange";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "atLocation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClosestPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLineAndColumn";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "firstRange";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sortedDiagnostics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class LineAndColumn {
        public static final LineAndColumn NONE = new LineAndColumn(-1, -1, null);
        private final int line;
        private final int column;
        private final String lineContent;

        public LineAndColumn(int line, int column, @Nullable String lineContent) {
            this.line = line;
            this.column = column;
            this.lineContent = lineContent;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        @Nullable
        public String getLineContent() {
            return this.lineContent;
        }

        public String toString() {
            if (this.line < 0) {
                return "(offset: " + this.column + " line unknown)";
            }
            return "(" + this.line + "," + this.column + ")";
        }
    }
}

