/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.execution.process.UnixProcessManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.AtomicNotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.concurrency.FixedFuture;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.io.BaseDataReader;
import org.jetbrains.kotlin.com.intellij.util.io.BaseOutputReader;
import org.jetbrains.kotlin.com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EnvironmentUtil");
    private static final Future<Map<String, String>> ourEnvGetter = SystemInfo.isMac && "unlocked".equals(System.getProperty("__idea.mac.env.lock")) && Registry.is("idea.fix.mac.env") ? AppExecutorUtil.getAppExecutorService().submit(new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            return Collections.unmodifiableMap(EnvironmentUtil.setCharsetVar(EnvironmentUtil.getShellEnv()));
        }
    }) : new FixedFuture<Map<String, String>>(EnvironmentUtil.getSystemEnv());
    private static final NotNullLazyValue<Map<String, String>> ourEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> compute() {
            Map map2;
            try {
                map2 = (Map)ourEnvGetter.get();
            }
            catch (Throwable t) {
                LOG.warn("can't get shell environment", t);
                Map map3 = EnvironmentUtil.getSystemEnv();
                if (map3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$2", "compute"));
                }
                return map3;
            }
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$2", "compute"));
            }
            return map2;
        }
    };

    private static Map<String, String> getSystemEnv() {
        if (SystemInfo.isWindows) {
            return Collections.unmodifiableMap(new THashMap<String, String>(System.getenv(), CaseInsensitiveStringHashingStrategy.INSTANCE));
        }
        return System.getenv();
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map2 = ourEnvironment.getValue();
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "getEnvironmentMap"));
        }
        return map2;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "getValue"));
        }
        return EnvironmentUtil.getEnvironmentMap().get(name);
    }

    private static Map<String, String> getShellEnv() throws Exception {
        return new ShellEnvReader().readShellEnv();
    }

    @NotNull
    private static Map<String, String> parseEnv(String text2, String lineSeparator) throws Exception {
        String[] lines;
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL", "DISABLE_AUTO_UPDATE"));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines = text2.split(lineSeparator)) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new Exception("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        HashMap<String, String> hashMap = newEnv;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "parseEnv"));
        }
        return hashMap;
    }

    private static int waitAndTerminateAfter(@NotNull Process process2, int timeoutMillis) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "waitAndTerminateAfter"));
        }
        Integer exitCode = EnvironmentUtil.waitFor(process2, timeoutMillis);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("shell env loader is timed out");
        UnixProcessManager.sendSigIntToProcessTree(process2);
        exitCode = EnvironmentUtil.waitFor(process2, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to terminate shell env loader process gracefully, terminating forcibly");
        UnixProcessManager.sendSigKillToProcessTree(process2);
        exitCode = EnvironmentUtil.waitFor(process2, 1000);
        if (exitCode != null) {
            return exitCode;
        }
        LOG.warn("failed to kill shell env loader");
        return -1;
    }

    @Nullable
    private static Integer waitFor(@NotNull Process process2, int timeoutMillis) {
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "waitFor"));
        }
        long stop = System.currentTimeMillis() + (long)timeoutMillis;
        while (System.currentTimeMillis() < stop) {
            TimeoutUtil.sleep(100L);
            try {
                return process2.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
            }
        }
        return null;
    }

    private static Map<String, String> setCharsetVar(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "setCharsetVar"));
        }
        if (!EnvironmentUtil.isCharsetVarDefined(env)) {
            String value = EnvironmentUtil.setLocaleEnv(env, CharsetToolkit.getDefaultSystemCharset());
            LOG.info("LC_CTYPE=" + value);
        }
        return env;
    }

    @NotNull
    public static String setLocaleEnv(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "setLocaleEnv"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "setLocaleEnv"));
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String value = (language.isEmpty() || country.isEmpty() ? "en_US" : language + '_' + country) + '.' + charset.name();
        env.put("LC_CTYPE", value);
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "setLocaleEnv"));
        }
        return string;
    }

    private static boolean isCharsetVarDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil", "isCharsetVarDefined"));
        }
        return !env.isEmpty() && (env.containsKey("LANG") || env.containsKey("LC_ALL") || env.containsKey("LC_CTYPE"));
    }

    private static class StreamGobbler
    extends BaseOutputReader {
        private static final BaseOutputReader.Options OPTIONS = new BaseOutputReader.Options(){

            @Override
            public BaseDataReader.SleepingPolicy policy() {
                return BaseDataReader.SleepingPolicy.BLOCKING;
            }

            @Override
            public boolean splitToLines() {
                return false;
            }
        };
        private final StringBuffer myBuffer;

        public StreamGobbler(@NotNull InputStream stream2) {
            if (stream2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$StreamGobbler", "<init>"));
            }
            super(stream2, CharsetToolkit.getDefaultSystemCharset(), OPTIONS);
            this.myBuffer = new StringBuffer();
            this.start("stdout/stderr streams of shell env loading process");
        }

        @Override
        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$StreamGobbler", "executeOnPooledThread"));
            }
            Future<?> future = AppExecutorUtil.getAppExecutorService().submit(runnable);
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$StreamGobbler", "executeOnPooledThread"));
            }
            return future;
        }

        @Override
        protected void onTextAvailable(@NotNull String text2) {
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$StreamGobbler", "onTextAvailable"));
            }
            this.myBuffer.append(text2);
        }

        @NotNull
        public String getText() {
            String string = this.myBuffer.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$StreamGobbler", "getText"));
            }
            return string;
        }
    }

    public static class ShellEnvReader {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<String, String> readShellEnv() throws Exception {
            String os = SystemInfo.isLinux ? "linux" : "mac";
            File reader = FileUtil.findFirstThatExist(PathManager.getBinPath() + "/printenv.py", PathManager.getHomePath() + "/ultimate/community/bin/" + os + "/printenv.py", PathManager.getHomePath() + "/community/bin/" + os + "/printenv.py", PathManager.getHomePath() + "/bin/" + os + "/printenv.py");
            if (reader == null) {
                throw new Exception("bin:" + PathManager.getBinPath());
            }
            File envFile = FileUtil.createTempFile("intellij-shell-env.", ".tmp", false);
            try {
                List<String> command = this.getShellProcessCommand();
                int idx = command.indexOf("-c");
                if (idx >= 0) {
                    command.set(idx + 1, command.get(idx + 1) + ";'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                } else {
                    command.add("-c");
                    command.add("'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'");
                }
                LOG.info("loading shell env: " + StringUtil.join(command, " "));
                Map<String, String> map2 = this.dumpProcessEnvToFile(command, envFile, "\u0000");
                return map2;
            }
            finally {
                FileUtil.delete(envFile);
            }
        }

        @NotNull
        protected Map<String, String> dumpProcessEnvToFile(@NotNull List<String> command, @NotNull File envFile, String lineSeparator) throws Exception {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "dumpProcessEnvToFile"));
            }
            if (envFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "dumpProcessEnvToFile"));
            }
            Map<String, String> map2 = ShellEnvReader.runProcessAndReadEnvs(command, envFile, lineSeparator);
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "dumpProcessEnvToFile"));
            }
            return map2;
        }

        @NotNull
        protected static Map<String, String> runProcessAndReadEnvs(@NotNull List<String> command, @NotNull File envFile, String lineSeparator) throws Exception {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            if (envFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            Map<String, String> map2 = ShellEnvReader.runProcessAndReadEnvs(command, null, envFile, lineSeparator);
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            return map2;
        }

        @NotNull
        protected static Map<String, String> runProcessAndReadEnvs(@NotNull List<String> command, @Nullable File workingDir, @NotNull File envFile, String lineSeparator) throws Exception {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            if (envFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            Map<String, String> map2 = ShellEnvReader.runProcessAndReadEnvs(command, workingDir, null, envFile, lineSeparator);
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            return map2;
        }

        @NotNull
        protected static Map<String, String> runProcessAndReadEnvs(@NotNull List<String> command, @Nullable File workingDir, @Nullable Map<String, String> envs, @NotNull File envFile, String lineSeparator) throws Exception {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            if (envFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envFile", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            ProcessBuilder builder = new ProcessBuilder(command).redirectErrorStream(true);
            if (envs != null) {
                builder.environment().putAll(envs);
            }
            if (workingDir != null) {
                builder.directory(workingDir);
            }
            builder.environment().put("DISABLE_AUTO_UPDATE", "true");
            Process process2 = builder.start();
            StreamGobbler gobbler = new StreamGobbler(process2.getInputStream());
            int rv = EnvironmentUtil.waitAndTerminateAfter(process2, 20000);
            gobbler.stop();
            String lines = FileUtil.loadFile(envFile);
            if (rv != 0 || lines.isEmpty()) {
                throw new Exception("rv:" + rv + " text:" + lines.length() + " out:" + StringUtil.trimEnd(gobbler.getText(), '\n'));
            }
            Map map2 = EnvironmentUtil.parseEnv(lines, lineSeparator);
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "runProcessAndReadEnvs"));
            }
            return map2;
        }

        @NotNull
        protected List<String> getShellProcessCommand() throws Exception {
            String shell = this.getShell();
            if (shell == null || !new File(shell).canExecute()) {
                throw new Exception("shell:" + shell);
            }
            ArrayList<String> commands = ContainerUtil.newArrayList(new String[]{shell});
            if (!shell.endsWith("/tcsh") && !shell.endsWith("/csh")) {
                commands.add("-l");
            }
            commands.add("-i");
            ArrayList<String> arrayList = commands;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil$ShellEnvReader", "getShellProcessCommand"));
            }
            return arrayList;
        }

        @Nullable
        protected String getShell() throws Exception {
            return System.getenv("SHELL");
        }
    }
}

