/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;

public abstract class NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NotNullLazyValue");
    private T myValue;

    @NotNull
    protected abstract T compute();

    @NotNull
    public T getValue() {
        T result2 = this.myValue;
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result2;
            }
        }
        T t = result2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue", "getValue"));
        }
        return t;
    }

    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createConstantValue(final @NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object object = value;
                if (object == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue$1", "compute"));
                }
                return object;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue", "createConstantValue"));
        }
        return notNullLazyValue;
    }

    @NotNull
    public static <T> NotNullLazyValue<T> createValue(final @NotNull NotNullFactory<T> value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue", "createValue"));
        }
        NotNullLazyValue notNullLazyValue = new NotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value.create();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue$2", "compute"));
                }
                return t;
            }
        };
        if (notNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/NotNullLazyValue", "createValue"));
        }
        return notNullLazyValue;
    }
}

