/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import groovy.util.Node;
import java.util.HashMap;
import java.util.Map;
import org.gradle.plugins.ide.eclipse.model.WbModuleEntry;
import org.gradle.plugins.ide.eclipse.model.internal.PathUtil;

public class WbResource
implements WbModuleEntry {
    private String deployPath;
    private String sourcePath;

    public WbResource(Node node) {
        this((String)node.attribute((Object)"deploy-path"), (String)node.attribute((Object)"source-path"));
    }

    public WbResource(String deployPath, String sourcePath) {
        Preconditions.checkNotNull((Object)deployPath);
        Preconditions.checkNotNull((Object)sourcePath);
        this.deployPath = PathUtil.normalizePath(deployPath);
        this.sourcePath = PathUtil.normalizePath(sourcePath);
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    @Override
    public void appendNode(Node node) {
        HashMap attributes = Maps.newHashMap();
        attributes.put("deploy-path", this.deployPath);
        attributes.put("source-path", this.sourcePath);
        node.appendNode((Object)"wb-resource", (Map)attributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WbResource that = (WbResource)o;
        return Objects.equal((Object)this.deployPath, (Object)that.deployPath) && Objects.equal((Object)this.sourcePath, (Object)that.sourcePath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.deployPath, this.sourcePath});
    }

    public String toString() {
        return "WbResource{deployPath='" + this.deployPath + "', sourcePath='" + this.sourcePath + "'}";
    }
}

