/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DefaultDependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependencyToAll;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;

public class ClassDependentsAccumulator {
    private final Set<String> dependenciesToAll = Sets.newHashSet();
    private final Map<String, String> filePathToClassName = new HashMap<String, String>();
    private final Map<String, Set<String>> dependents = new HashMap<String, Set<String>>();
    private final Multimap<String, Integer> classesToConstants = HashMultimap.create();
    private final Multimap<Integer, String> literalsToClasses = HashMultimap.create();
    private final Set<String> seenClasses = Sets.newHashSet();
    private final Multimap<String, String> parentToChildren = HashMultimap.create();

    public void addClass(File classFile, ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis);
        this.filePathToClassName.put(classFile.getAbsolutePath(), classAnalysis.getClassName());
    }

    public void addClass(ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis.getClassName(), classAnalysis.isDependencyToAll(), classAnalysis.getClassDependencies(), classAnalysis.getConstants(), classAnalysis.getLiterals(), classAnalysis.getSuperTypes());
    }

    public void addClass(String className, boolean dependencyToAll, Iterable<String> classDependencies, Set<Integer> constants, Set<Integer> literals, Set<String> superTypes) {
        if (this.seenClasses.contains(className)) {
            return;
        }
        this.seenClasses.add(className);
        for (Integer constant : constants) {
            this.classesToConstants.put((Object)className, (Object)constant);
        }
        for (Integer literal : literals) {
            this.literalsToClasses.put((Object)literal, (Object)className);
        }
        if (dependencyToAll) {
            this.dependenciesToAll.add(className);
            this.dependents.remove(className);
        }
        for (String dependency : classDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.contains(dependency)) continue;
            Set<String> d = this.rememberClass(dependency);
            d.add(className);
        }
        for (String superType : superTypes) {
            this.parentToChildren.put((Object)superType, (Object)className);
        }
    }

    private Set<String> rememberClass(String className) {
        HashSet d = this.dependents.get(className);
        if (d == null) {
            d = Sets.newHashSet();
            this.dependents.put(className, d);
        }
        return d;
    }

    public Map<String, DependentsSet> getDependentsMap() {
        if (this.dependenciesToAll.isEmpty() && this.dependents.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : this.dependenciesToAll) {
            builder.put((Object)string, (Object)DependencyToAll.INSTANCE);
        }
        for (Map.Entry entry : this.dependents.entrySet()) {
            builder.put(entry.getKey(), (Object)new DefaultDependentsSet((Set<String>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue()))));
        }
        return builder.build();
    }

    public Multimap<String, Integer> getClassesToConstants() {
        return this.classesToConstants;
    }

    public Multimap<Integer, String> getLiteralsToClasses() {
        return this.literalsToClasses;
    }

    public ClassSetAnalysisData getAnalysis() {
        return new ClassSetAnalysisData(this.filePathToClassName, this.getDependentsMap(), this.getClassesToConstants(), this.getLiteralsToClasses(), this.parentToChildren);
    }
}

