/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.AbstractNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;

public class DefaultNormalizedFileSnapshot
extends AbstractNormalizedFileSnapshot {
    private final String normalizedPath;

    public DefaultNormalizedFileSnapshot(String normalizedPath, FileType type, HashCode contentHash) {
        super(type, DefaultNormalizedFileSnapshot.hashForType(type, contentHash));
        this.normalizedPath = normalizedPath;
    }

    public DefaultNormalizedFileSnapshot(String normalizedPath, PhysicalSnapshot snapshot) {
        this(normalizedPath, snapshot.getType(), snapshot.getHash());
    }

    private static HashCode hashForType(FileType fileType, HashCode hash) {
        switch (fileType) {
            case Directory: {
                return DIR_SIGNATURE;
            }
            case Missing: {
                return MISSING_FILE_SIGNATURE;
            }
            case RegularFile: {
                return hash;
            }
        }
        throw new IllegalStateException("Unknown file type: " + fileType);
    }

    @Override
    public String getNormalizedPath() {
        return this.normalizedPath;
    }
}

