
#include "oipfconfiguration.h"

#define kOCFG_ID_PROPERTY_CONFIGURATION				       	0
#define kOCFG_NUM_PROPERTY_IDENTIFIERS                   	1

#define kOCFG_NUM_METHOD_IDENTIFIERS                	    0

bool            v_bOCFGIdentifiersInitialized = false;

NPIdentifier    v_OCFGPropertyIdentifiers[kOCFG_NUM_PROPERTY_IDENTIFIERS];
const NPUTF8 *  v_OCFGPropertyNames[kOCFG_NUM_PROPERTY_IDENTIFIERS] = {
	"configuration"
    };

NPIdentifier    v_OCFGMethodIdentifiers[kOCFG_NUM_METHOD_IDENTIFIERS];
const NPUTF8 *  v_OCFGMethodNames[kOCFG_NUM_METHOD_IDENTIFIERS] = {};

static  void    OCFGinitializeIdentifiers(void)
{
    sBrowserFuncs->getstringidentifiers( v_OCFGPropertyNames, kOCFG_NUM_PROPERTY_IDENTIFIERS, v_OCFGPropertyIdentifiers );
    sBrowserFuncs->getstringidentifiers( v_OCFGMethodNames,   kOCFG_NUM_METHOD_IDENTIFIERS,   v_OCFGMethodIdentifiers );
}


NPClass  stOCFGclass;
NPClass* pOCFGclass = NULL;

NPClass* fillOCFGpclass(void)
{
    TRACEINFO;
    if (pOCFGclass == NULL)
    {
        stOCFGclass.allocate          = OCFG_Allocate;
        stOCFGclass.deallocate        = OCFG_Deallocate;
        stOCFGclass.invalidate        = OCFG_Invalidate;
        stOCFGclass.hasMethod         = OCFG_HasMethod;
        stOCFGclass.invoke            = OCFG_Invoke;
        stOCFGclass.invokeDefault     = OCFG_InvokeDefault;
        stOCFGclass.hasProperty       = OCFG_HasProperty;
        stOCFGclass.getProperty       = OCFG_GetProperty;
        stOCFGclass.setProperty       = OCFG_SetProperty;
        stOCFGclass.removeProperty    = OCFG_RemoveProperty;
        stOCFGclass.enumerate         = OCFG_Enumerate;
        pOCFGclass = &stOCFGclass;
    }

    return pOCFGclass;
}


NPObject *          OCFG_Allocate(NPP npp, NPClass *theClass)
{
    TRACEINFO;

    NPObject* result;

    NPObject* newapplication = NULL;
    if (!v_bOCFGIdentifiersInitialized)
    {
        v_bOCFGIdentifiersInitialized = true;
        OCFGinitializeIdentifiers();
    }

    newapplication = malloc(sizeof(NPObject));

    result = newapplication;
    return result;
}


void        OCFG_Deallocate(NPObject* obj)
{
    TRACEINFO;
    free(obj);
    return;
}

void        OCFG_Invalidate(NPObject* obj)
{
    TRACEINFO;
    return;
}

bool        OCFG_HasMethod(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
	bool result = false;
    int i = 0;
    NPUTF8* utf8methodname = (char*)sBrowserFuncs->utf8fromidentifier(name);
    while ((i < kOCFG_NUM_METHOD_IDENTIFIERS) && (result == false))
    {
        if ( name == v_OCFGMethodIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }
    printf("\tOCFG has method \"%s\" : %s \n", utf8methodname, booltostr(result));
    return result;
}

bool        OCFG_Invoke(NPObject* obj, NPIdentifier name, const NPVariant* args, uint32_t argCount, NPVariant* result)
{
    TRACEINFO;

    bool fctresult;
    printf("OAM_ObjectMain_Invoke(): method not found\n");
    fctresult = false;

    return fctresult;

}

bool        OCFG_InvokeDefault(NPObject *npobj, const NPVariant *args, uint32_t argCount, NPVariant *result)
{
    TRACEINFO;
    return true;
}

bool        OCFG_HasProperty(NPObject* obj, NPIdentifier name)
{
    TRACEINFO;
    bool result = false;
    NPUTF8* utf8propertyname = (char*)sBrowserFuncs->utf8fromidentifier(name);

    int i = 0;
    while ((i < kOCFG_NUM_PROPERTY_IDENTIFIERS) && (result == false))
    {
        if ( name == v_OCFGPropertyIdentifiers[i] )
        {
            result= true;
        }
        i++;
    }

    printf("\tOCFG has property \"%s\" : %s \n", utf8propertyname, booltostr(result));
    return result;
}

bool        OCFG_GetProperty(NPObject* obj, NPIdentifier name, NPVariant* result)
{
    TRACEINFO;
    return true;
}

bool        OCFG_SetProperty(NPObject *obj, NPIdentifier name, const NPVariant *value)
{
    TRACEINFO;
    return true;
}

bool        OCFG_RemoveProperty(NPObject *npobj, NPIdentifier name)
{
    TRACEINFO;
    return true;
}


bool        OCFG_Enumerate(NPObject *npobj, NPIdentifier **value, uint32_t *count)
{
    TRACEINFO;
    return true;
}

