/*
** HbbTV Plugin PC
*/
#include <X11/Xlib.h>
#include "hbbtvbrowserplugin.h"
#include "oipfapplicationmanager.h"
#include "oipfconfiguration.h"
#include "videobroadcast.h"

#define MIMETYPEDESCRIPTION "application/hbbtvbrowserplugin::Hbbtv Browser Plugin;" \
							"video/broadcast::Video Broadcast;"\
                            "application/oipfapplicationmanager::Oipf Application Manager;"\
                            "application/oipfconfiguration::Oipf Configuration;"


#define PLUGIN_NAME			"hbbtvbrowserplugin"
#define PLUGIN_DESCRIPTION	"HbbTV browser plugin "
#define PLUGIN_VERSION		"0.20110704"



static void
fillPluginFunctionTable(NPPluginFuncs* pFuncs)
{
  TRACEINFO;
  pFuncs->version = 11;
  pFuncs->size = sizeof(*pFuncs);
  pFuncs->newp = OIPF_NPP_New;
  pFuncs->destroy = OIPF_NPP_Destroy;
  pFuncs->setwindow = OIPF_NPP_SetWindow;
  pFuncs->newstream = OIPF_NPP_NewStream;
//  pFuncs->destroystream = NPP_DestroyStream;
//  pFuncs->asfile = NPP_StreamAsFile;
//  pFuncs->writeready = NPP_WriteReady;
//  pFuncs->write = NPP_Write;
//  pFuncs->print = NPP_Print;
  pFuncs->event = OIPF_NPP_HandleEvent;
//  pFuncs->urlnotify = NPP_URLNotify;
  pFuncs->getvalue = OIPF_NPP_GetValue;
  pFuncs->setvalue = OIPF_NPP_SetValue;
}

char* booltostr(bool data)
{
    char *result;
    if (data)
        result = "true";
    else
        result = "false";
    return result;
}

NPError NP_Initialize(NPNetscapeFuncs* bFuncs, NPPluginFuncs* pFuncs)
{
	TRACEINFO;

    sBrowserFuncs = bFuncs;
    printf("browserfuncs version : %d\n", sBrowserFuncs->version);
	fillPluginFunctionTable(pFuncs);

	return NPERR_NO_ERROR;
}

char* NP_GetPluginVersion()
{
    TRACEINFO;
	return PLUGIN_VERSION;
}

NPError NP_Shutdown()
{
    TRACEINFO;
	return NPERR_NO_ERROR;
}

char* NP_GetMIMEDescription()
{
    TRACEINFO;
	return MIMETYPEDESCRIPTION;
}


NPError NP_GetValue(void *instance, NPPVariable variable, void *value)
{
    TRACEINFO;
	switch (variable)
	{
		case NPPVpluginNameString :
			*(char**)value = PLUGIN_NAME;
			break;
		case NPPVpluginDescriptionString :
			*(char**)value = PLUGIN_DESCRIPTION;
			break;
		default :
			break;
	}
	return NPERR_NO_ERROR;
}

NPError OIPF_NPP_New(NPMIMEType pluginType, NPP instance, uint16_t mode, int16_t argc, char *argn[], char *argv[], NPSavedData *saved)
{
	TRACEINFO;
	NPBool browserSupportsWindowless = false;
	sBrowserFuncs->getvalue(instance, NPNVSupportsWindowless, &browserSupportsWindowless);
	if (!browserSupportsWindowless)
	{
		printf("Windowless mode not supported by the browser");
		return NPERR_GENERIC_ERROR;
	}
	sBrowserFuncs->setvalue(instance, NPPVpluginWindowBool, (void*)false);

    NPObject* obj;

    if (strcmp(argv[0], "application/oipfApplicationManager") == 0)
    {
        obj = sBrowserFuncs->createobject(instance, fillOAMpclass());
    }
    if (strcmp(argv[0], "application/oipfConfiguration") == 0)
    {
        obj = sBrowserFuncs->createobject(instance, fillOCFGpclass());
    }
	if (strcmp(argv[0], "video/broadcast") == 0)
    {
        obj = sBrowserFuncs->createobject(instance, fillVIDBRCpclass());
    }

    instance->pdata = obj;

	return NPERR_NO_ERROR;
}

NPError OIPF_NPP_Destroy(NPP instance, NPSavedData **save)
{
    TRACEINFO;
    if (instance->pdata)
    {
        sBrowserFuncs->releaseobject(instance->pdata);
    }
    return NPERR_NO_ERROR;
}


NPError OIPF_NPP_SetWindow(NPP instance, NPWindow *window)
{
	TRACEINFO;
	//OnSetWindow(window->x,window->y,window->width,window->height);

	return NPERR_NO_ERROR;
}

NPError OIPF_NPP_HandleEvent(NPP instance, void* Event)
{
    TRACEINFO;
	return NPERR_NO_ERROR;
}

NPError OIPF_NPP_GetValue(NPP instance, NPPVariable variable, void *value)
{
    TRACEINFO;

    if ( variable == NPPVpluginScriptableNPObject )
    {
            printf("\tvariable == NPPVpluginScriptableNPObject\n");

            void ** v = (void **)value;
            NPObject* obj = (NPObject*) instance->pdata;
            sBrowserFuncs->retainobject(obj);
            *v = obj;
    }
	return NPERR_NO_ERROR;
}


NPError OIPF_NPP_SetValue(NPP instance, NPNVariable variable, void *value)
{
    TRACEINFO;
	return NPERR_GENERIC_ERROR;
}


NPError OIPF_NPP_NewStream(NPP instance, NPMIMEType type, NPStream* stream, NPBool seekable, uint16_t* stype)
{
    TRACEINFO;
	return NPERR_GENERIC_ERROR;
}

