(* (c) Microsoft Corporation. All rights reserved  *)

(*F# 
module Microsoft.Research.AbstractIL.Internal.Zset 
open Microsoft.Research.AbstractIL 
F#*)

type 'a order = 'a -> 'a -> int

type 'a set (*F# = Microsoft.FSharp.Collections.Tagged.Set<'a> F#*)
type 'a t = 'a set

val empty     : 'a order -> 'a t
val is_empty  : 'a t -> bool
val mem       : 'a -> 'a t -> bool
val mem_of    : 'a t -> 'a -> bool
val add       : 'a -> 'a t -> 'a t
val addL      : 'a list -> 'a t -> 'a t
val singleton : 'a order -> 'a -> 'a t
val remove    : 'a -> 'a t -> 'a t

val union     : 'a t -> 'a t -> 'a t
val inter     : 'a t -> 'a t -> 'a t
val diff      : 'a t -> 'a t -> 'a t
val equal     : 'a t -> 'a t -> bool
val subset    : 'a t -> 'a t -> bool
val for_all   : ('a -> bool) -> 'a t -> bool
val forall    : ('a -> bool) -> 'a t -> bool
val exists    : ('a -> bool) -> 'a t -> bool
val filter    : ('a -> bool) -> 'a t -> 'a  t   

val fold      : ('a -> 'b -> 'b) -> 'a t -> 'b -> 'b
val iter      : ('a -> unit) -> 'a t -> unit

val elements  : 'a t -> 'a list



