(*==========================================================================
 * This file contains the definitions of primitive operations which can
 * be used to implement a functional programming library for use with the
 * F# compiler.  They are not typically for direct use from user code.
 *
 * LexBuffers are for use with automatically generated lexical analyzers,
 * in particular those produced by 'fslex'.
 *
 * (c) Microsoft Corporation 2005-2007.
 *=========================================================================*)

#light

namespace Microsoft.FSharp.Tools.FsLex 
open Microsoft.FSharp.Core
open Microsoft.FSharp.Control
    
type LexBuffer<'pos,'char> with
    /// The start position for the lexeme
    member StartPos: 'pos with get,set
    /// The end position for the lexeme
    member EndPos: 'pos with get,set
    /// The matched string 
    member Lexeme: 'char array
    /// The length of the matched string 
    member LexemeLength: int
    /// Fetch a particular character in the matched string 
    member LexemeChar: int -> 'char
    
    /// True if the refill of the buffer ever failed , or if explicitly set to true.
    member IsPastEndOfStream: bool with get,set
    /// This event is fired each time a lexeme is matched by a client lexer
    member MatchEvent: IEvent<unit>
    /// Remove all input, though don't discard the current lexeme 
    member DiscardInput: unit -> unit
    /// Adjust the start position associated with the lexbuf

    // Create implementations of lexbufs
    static member FromBytes: 'pos * byte[] -> LexBuffer<'pos,byte>
    static member FromChars: 'pos * char[] -> LexBuffer<'pos,char>
    static member FromByteFunction: 'pos * (byte[] -> int -> int) -> LexBuffer<'pos,byte>
    static member FromCharFunction: 'pos * (char[] -> int -> int) -> LexBuffer<'pos,char>

/// The type of tables for an ascii lexer generated by fslex. 
type AsciiTables with 
    static member Create : byte[] array * byte[] -> AsciiTables
    /// Interpret tables for an ascii lexer generated by fslex. 
    member Interpret:  int * LexBuffer<'pos,byte> -> int


// NOTE: NOT YET FULLY IMPLEMENTED.  fslex WILL NOT YET CREATE UNICODE
// LEXERS
(*
type UnicodeTables = { trans: byte[] array; accept: byte[] }
    with 
        /// Interpret tables for an ascii lexer generated by fslex. 
        member Interpret:  int -> LexBuffer<'pos,char> -> int
    end

*)


