//
// Copyright (c) 2006, Brian Frank and Andy Frank
// Licensed under the Academic Free License version 3.0
//
// History:
//   09 Sep 10  Auto-generated by /adm/genfcode.rb
//

**
** FOp provides all the fcode constants
**
enum class FOp
{
  Nop                (),                  //   0  no operation
  LoadNull           (),                  //   1  load null literal onto stack
  LoadFalse          (),                  //   2  load false literal onto stack
  LoadTrue           (),                  //   3  load true literal onto stack
  LoadInt            (FOpArg.Int),        //   4  load Int const by index onto stack
  LoadFloat          (FOpArg.Float),      //   5  load Float const by index onto stack
  LoadDecimal        (FOpArg.Decimal),    //   6  load Decimal const by index onto stack
  LoadStr            (FOpArg.Str),        //   7  load Str const by index onto stack
  LoadDuration       (FOpArg.Duration),   //   8  load Duration const by index onto stack
  LoadType           (FOpArg.TypeRef),    //   9  load Type instance by index onto stack
  LoadUri            (FOpArg.Uri),        //  10  load Uri const by index onto stack
  LoadVar            (FOpArg.Register),   //  11  local var register index (0 is this)
  StoreVar           (FOpArg.Register),   //  12  local var register index (0 is this)
  LoadInstance       (FOpArg.FieldRef),   //  13  load field from storage
  StoreInstance      (FOpArg.FieldRef),   //  14  store field to storage
  LoadStatic         (FOpArg.FieldRef),   //  15  load static field from storage
  StoreStatic        (FOpArg.FieldRef),   //  16  store static field to storage
  LoadMixinStatic    (FOpArg.FieldRef),   //  17  load static on mixin field from storage
  StoreMixinStatic   (FOpArg.FieldRef),   //  18  store static on mixin field to storage
  CallNew            (FOpArg.MethodRef),  //  19  alloc new object and call constructor
  CallCtor           (FOpArg.MethodRef),  //  20  call constructor (used for constructor chaining)
  CallStatic         (FOpArg.MethodRef),  //  21  call static method
  CallVirtual        (FOpArg.MethodRef),  //  22  call virtual instance method
  CallNonVirtual     (FOpArg.MethodRef),  //  23  call instance method non-virtually (private or super only b/c of Java invokespecial)
  CallMixinStatic    (FOpArg.MethodRef),  //  24  call static mixin method
  CallMixinVirtual   (FOpArg.MethodRef),  //  25  call virtual mixin method
  CallMixinNonVirtual (FOpArg.MethodRef),  //  26  call instance mixin method non-virtually (named super)
  Jump               (FOpArg.Jump),       //  27  unconditional jump
  JumpTrue           (FOpArg.Jump),       //  28  jump if bool true
  JumpFalse          (FOpArg.Jump),       //  29  jump if bool false
  CmpEQ              (FOpArg.TypePair),   //  30  a.equals(b)
  CmpNE              (FOpArg.TypePair),   //  31  !a.equals(b)
  Cmp                (FOpArg.TypePair),   //  32  a.compare(b)
  CmpLE              (FOpArg.TypePair),   //  33  a.compare(b) <= 0
  CmpLT              (FOpArg.TypePair),   //  34  a.compare(b) < 0
  CmpGT              (FOpArg.TypePair),   //  35  a.compare(b) > 0
  CmpGE              (FOpArg.TypePair),   //  36  a.compare(b) >= 0
  CmpSame            (),                  //  37  a === b
  CmpNotSame         (),                  //  38  a !== b
  CmpNull            (FOpArg.TypeRef),    //  39  a == null
  CmpNotNull         (FOpArg.TypeRef),    //  40  a != null
  Return             (),                  //  41  return from method
  Pop                (FOpArg.TypeRef),    //  42  pop top object off stack
  Dup                (FOpArg.TypeRef),    //  43  duplicate object ref on top of stack
  Is                 (FOpArg.TypeRef),    //  44  is operator
  As                 (FOpArg.TypeRef),    //  45  as operator
  Coerce             (FOpArg.TypePair),   //  46  from->to coercion value/reference/nullable
  Switch             (),                  //  47  switch jump table 2 count + 2*count
  Throw              (),                  //  48  throw Err on top of stack
  Leave              (FOpArg.Jump),       //  49  jump out of a try or catch block
  JumpFinally        (FOpArg.Jump),       //  50  jump to a finally block
  CatchAllStart      (),                  //  51  start catch all block - do not leave Err on stack
  CatchErrStart      (FOpArg.TypeRef),    //  52  start catch block - leave typed Err on stack
  CatchEnd           (),                  //  53  start catch block - leave typed Err on stack
  FinallyStart       (),                  //  54  starting instruction of a finally block
  FinallyEnd         ()                   //  55  ending instruction of a finally block

  private new make(FOpArg arg := FOpArg.None) { this.arg = arg }

  const FOpArg arg
}

**************************************************************************
** FOpArg
**************************************************************************

enum class FOpArg
{
  None,
  Int,
  Float,
  Decimal,
  Str,
  Duration,
  Uri,
  Register,
  TypeRef,
  FieldRef,
  MethodRef,
  Jump,
  TypePair
}