/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fan.sys.Duration;
import fan.sys.FanDecimal;
import fan.sys.FanStr;
import fan.sys.InStream;
import fan.sys.Uri;
import fanx.serial.Token;
import fanx.serial.Tokenizer;
import fanx.test.Test;
import fanx.util.StrUtil;
import java.util.ArrayList;

public class TokenizerTest
extends Test {
    public void run() throws Exception {
        this.verify("", new Tok[0]);
        this.verify(" ", new Tok[0]);
        this.verify("\n", new Tok[0]);
        this.verify(" \n \n", new Tok[0]);
        this.verify("a", this.id("a"));
        this.verify(" a", this.id("a"));
        this.verify("a ", this.id("a"));
        this.verify(" a ", this.id("a"));
        this.verify("ab", this.id("ab"));
        this.verify("a\n", this.id("a"));
        this.verify("a77", this.id("a77"));
        this.verify("x9y", this.id("x9y"));
        this.verify("_", this.id("_"));
        this.verify("_foo_", this.id("_foo_"));
        this.verify("For", this.id("For"));
        this.verify("java", this.id("java"));
        this.verify("net", this.id("net"));
        this.verify("jalias", this.id("jalias"));
        this.verify("nalias", this.id("nalias"));
        this.verify("jcode", this.id("jcode"));
        this.verify("ncode", this.id("ncode"));
        this.verify("3", this.i(3L));
        this.verify("+9", this.i(9L));
        this.verify("3f", this.f(3.0));
        this.verify("3F", this.f(3.0));
        this.verify("3.0f", this.f(3.0));
        this.verify("3.0f", this.f(3.0));
        this.verify("-3.0f", this.f(-3.0));
        this.verify("73", this.i(73L));
        this.verify("-73", this.i(-73L));
        this.verify("73f", this.f(73.0));
        this.verify("73F", this.f(73.0));
        this.verify("73.0f", this.f(73.0));
        this.verify("73.0f", this.f(73.0));
        this.verify("123456", this.i(123456L));
        this.verify("123456f", this.f(123456.0));
        this.verify("123456F", this.f(123456.0));
        this.verify("123456.0f", this.f(123456.0));
        this.verify("123456.0f", this.f(123456.0));
        this.verify("07", this.i(7L));
        this.verify("7f", this.f(7.0));
        this.verify("07.0f", this.f(7.0));
        this.verify(".2f", this.f(0.2));
        this.verify("0.2f", this.f(0.2));
        this.verify("0.007f", this.f(0.007));
        this.verify(".12345f", this.f(0.12345));
        this.verify("0.12345f", this.f(0.12345));
        this.verify("12345.6789f", this.f(12345.6789));
        this.verify("3e6f", this.f(3000000.0));
        this.verify("3E6f", this.f(3000000.0));
        this.verify("3.0e6F", this.f(3000000.0));
        this.verify("3.0E6F", this.f(3000000.0));
        this.verify("3e-6f", this.f(3.0E-6));
        this.verify("3E-6f", this.f(3.0E-6));
        this.verify(".2e+6f", this.f(200000.0));
        this.verify(".2E+6F", this.f(200000.0));
        this.verify(".2e-03f", this.f(2.0E-4));
        this.verify(".2E-03f", this.f(2.0E-4));
        this.verify("1_234", this.i(1234L));
        this.verify("1_234_567", this.i(1234567L));
        this.verify("1.234_567F", this.f(1.234567));
        this.verify("1.2e3_00f", this.f(1.2E300));
        this.verify("1_2.3_7e5_6F", this.f(1.237E57));
        this.verify("0x3", this.i(3L));
        this.verify("0x03", this.i(3L));
        this.verify("0x123", this.i(291L));
        this.verify("0xabcdef", this.i(11259375L));
        this.verify("0xABCDEF", this.i(11259375L));
        this.verify("0x3aF7cE", this.i(3864526L));
        this.verify("0x12345678", this.i(305419896L));
        this.verify("0xffffffff", this.i(0xFFFFFFFFL));
        this.verify("0xfedcba98", this.i(4275878552L));
        this.verify("0xfedcba9812345678", this.i(-81985530896296328L));
        this.verify("0xFFFFFFFFFFFFFFFF", this.i(-1L));
        this.verify("0xffff_ffff", this.i(0xFFFFFFFFL));
        this.verify("0xFFFF_FFFF_FFFF_FFFF", this.i(-1L));
        this.verify("2147483647", this.i(Integer.MAX_VALUE));
        this.verify("9223372036854775807", this.i(Long.MAX_VALUE));
        this.verify("9_223_372_036_854_775_807", this.i(Long.MAX_VALUE));
        this.verify("1.5E-45f", this.f(1.5E-45));
        this.verify("3.402E77f", this.f(3.402E77));
        this.verify("1.4E-100f", this.f(1.4E-100));
        this.verify("1.7976931348623157E38f", this.f(1.7976931348623156E38));
        this.verify("3.0d", this.dec("3.0"));
        this.verify("3.00", this.dec("3.00"));
        this.verifyInvalid("3e");
        this.verifyInvalid("-3e");
        this.verifyInvalid("-.3e");
        this.verifyInvalid("+0.3e");
        this.verifyInvalid("0x");
        this.verifyInvalid("0xG");
        this.verifyInvalid("0x1FFFFFFFFFFFFFFFF");
        this.verifyInvalid("92233720368547758070");
        this.verifyInvalid("92233720368547758070");
        this.verify("'a'", this.i(97L));
        this.verify("'X'", this.i(88L));
        this.verify("' '", this.i(32L));
        this.verify("'\"'", this.i(34L));
        this.verify("'\\n'", this.i(10L));
        this.verify("'\\r'", this.i(13L));
        this.verify("'\\''", this.i(39L));
        this.verify("'\\uabcd'", this.i(43981L));
        this.verifyInvalid("'a");
        this.verifyInvalid("'ab'");
        this.verifyInvalid("'\\q'");
        this.verifyInvalid("'\\ug000'");
        this.verify("0ns", this.dur(0L));
        this.verify("5ns", this.dur(5L));
        this.verify("1ms", this.dur(1000000L));
        this.verify("1sec", this.dur(1000000000L));
        this.verify("-5sec", this.dur(-5000000000L));
        this.verify("1min", this.dur(60000000000L));
        this.verify("1hr", this.dur(3600000000000L));
        this.verify("0.5ms", this.dur(500000L));
        this.verify("-3.2ms", this.dur(-3200000L));
        this.verify("0.001sec", this.dur(1000000L));
        this.verify("0.25min", this.dur(15000000000L));
        this.verify("24hr", this.dur(86400000000000L));
        this.verify("876000hr", this.dur(3153600000000000000L));
        this.verify("1day", this.dur(86400000000000L));
        this.verify("0.5day", this.dur(43200000000000L));
        this.verify("30day", this.dur(2592000000000000L));
        this.verify("36500day", this.dur(3153600000000000000L));
        this.verify("\"\"", this.s(""));
        this.verify("\"a\"", this.s("a"));
        this.verify("\"ab\"", this.s("ab"));
        this.verify("\"abc\"", this.s("abc"));
        this.verify("\"a b\"", this.s("a b"));
        this.verify("\"a\\nb\"", this.s("a\nb"));
        this.verify("\"ab\\ncd\"", this.s("ab\ncd"));
        this.verify("\"\\b\"", this.s("\b"));
        this.verify("\"\\t\"", this.s("\t"));
        this.verify("\"\\n\"", this.s("\n"));
        this.verify("\"\\f\"", this.s("\f"));
        this.verify("\"\\r\"", this.s("\r"));
        this.verify("\"\\\"\"", this.s("\""));
        this.verify("\"''\"", this.s("''"));
        this.verify("\"\\r\\n\"", this.s("\r\n"));
        this.verify("\"\\u0001\"", this.s("\u0001"));
        this.verify("\"\\u0010\"", this.s("\u0010"));
        this.verify("\"\\u0100\"", this.s("\u0100"));
        this.verify("\"\\u1000\"", this.s("\u1000"));
        this.verify("\"\\uF000\"", this.s("\uf000"));
        this.verify("\"\\uFFFF\"", this.s("\uffff"));
        this.verify("\"\\uabcd\"", this.s("\uabcd"));
        this.verify("\"\\uABCD\"", this.s("\uabcd"));
        this.verify("\"a\nb\"", this.s("a\nb"));
        this.verify("\"a\nb\r c\"", this.s("a\nb\n c"));
        this.verify("\"a\nb\r\nc\r\"", this.s("a\nb\nc\n"));
        this.verifyInvalid("\"");
        this.verifyInvalid("\"a");
        this.verifyInvalid("\"a\n");
        this.verifyInvalid("\"\\u000g\"");
        this.verifyInvalid("\"\\u00g0\"");
        this.verifyInvalid("\"\\u0g00\"");
        this.verifyInvalid("\"\\ug000\"");
        this.verify("``", this.uri(""));
        this.verify("`.`", this.uri("."));
        this.verify("`'\"`", this.uri("'\""));
        this.verify("`http://f/`", this.uri("http://f/"));
        this.verify("`/foo bar.txt?q`", this.uri("/foo bar.txt?q"));
        this.verify("`\\$`", this.uri("$"));
        this.verify("`\u1234 \\u0abc \\` \\n\\t`", this.uri("\u1234 \u0abc ` \n\t"));
        this.verifyImpl("// foo bar", new Tok[0]);
        this.verifyImpl("/* foo bar */", new Tok[0]);
        this.verifyImpl("a// /* */", new Tok[]{this.id("a")});
        this.verifyImpl("a// /* */more...", new Tok[]{this.id("a")});
        this.verifyImpl("a// /* */more\n", new Tok[]{this.id("a")});
        this.verifyImpl("a// /* */more\nx", new Tok[]{this.id("a"), this.id("x")});
        this.verifyImpl("a/* foo bar */", new Tok[]{this.id("a")});
        this.verifyImpl("a// blah blah\nb", new Tok[]{this.id("a"), this.id("b")});
        this.verifyImpl("a/* blah blah*/b", new Tok[]{this.id("a"), this.id("b")});
        this.verifyImpl("a/* 33 // 33 */b", new Tok[]{this.id("a"), this.id("b")});
        this.verifyImpl("a/* /*33*/ // 33 */b", new Tok[]{this.id("a"), this.id("b")});
        this.verify(";", new Tok(10));
        this.verify(",", new Tok(11));
        this.verify("=", new Tok(21));
        this.verify("{", new Tok(14));
        this.verify("}", new Tok(15));
        this.verify("(", new Tok(16));
        this.verify(")", new Tok(17));
        this.verify("[", new Tok(18));
        this.verify("]", new Tok(19));
        this.verify(":", new Tok(12));
        this.verify("[]", new Tok(20));
        this.verifyInvalid("*");
        this.verify("a b", this.id("a"), this.id("b"));
        this.verify("a\nb", this.id("a"), this.id("b"));
        this.verify("a3\n_f", this.id("a3"), this.id("_f"));
        this.verify("a;b", this.id("a"), new Tok(10), this.id("b"));
        this.verify("1 2", this.i(1L), this.i(2L));
        Tok[] tokArray = this.tokenize("\nfoo");
        this.verifyPos(tokArray[0], 2, 1);
        this.verify(tokArray[0].equals(this.id("foo")));
        tokArray = this.tokenize("\n\n bar");
        this.verifyPos(tokArray[0], 3, 2);
        this.verify(tokArray[0].equals(this.id("bar")));
        tokArray = this.tokenize("a\nb\nc");
        this.verifyPos(tokArray[0], 1, 1);
        this.verify(tokArray[0].equals(this.id("a")));
        this.verifyPos(tokArray[1], 2, 1);
        this.verify(tokArray[1].equals(this.id("b")));
        this.verifyPos(tokArray[2], 3, 1);
        this.verify(tokArray[2].equals(this.id("c")));
        tokArray = this.tokenize("foo bar\nhere:\"there\"//junk\n 308 1.0f 55 8f\r/* a b /*c*/ d \n*/ = ;\n  a\n /*/* /*f*/ */!** */  b\r\n [\n\r\n     bear\n\n}");
        this.verifyPos(tokArray[0], 1, 1);
        this.verifyPos(tokArray[1], 1, 5);
        this.verifyPos(tokArray[2], 2, 1);
        this.verifyPos(tokArray[3], 2, 5);
        this.verifyPos(tokArray[4], 2, 6);
        this.verifyPos(tokArray[5], 3, 2);
        this.verifyPos(tokArray[6], 3, 6);
        this.verifyPos(tokArray[7], 3, 11);
        this.verifyPos(tokArray[8], 3, 14);
        this.verifyPos(tokArray[9], 5, 4);
        this.verifyPos(tokArray[10], 5, 6);
        this.verifyPos(tokArray[11], 6, 3);
        this.verifyPos(tokArray[12], 7, 23);
        this.verifyPos(tokArray[13], 8, 2);
        this.verifyPos(tokArray[14], 10, 6);
        this.verifyPos(tokArray[15], 12, 1);
    }

    public Tok[] tokenize(String string) {
        int n;
        InStream inStream = FanStr.in(string);
        Tokenizer tokenizer = new Tokenizer(inStream);
        ArrayList<Tok> arrayList = new ArrayList<Tok>();
        while ((n = tokenizer.next()) >= 0) {
            this.verify(n, tokenizer.type);
            arrayList.add(new Tok(n, tokenizer.val, tokenizer.line));
        }
        return arrayList.toArray(new Tok[arrayList.size()]);
    }

    public void verify(String string, Tok tok) {
        this.verify(string, new Tok[]{tok});
    }

    public void verify(String string, Tok tok, Tok tok2) {
        this.verify(string, new Tok[]{tok, tok2});
    }

    public void verify(String string, Tok tok, Tok tok2, Tok tok3) {
        this.verify(string, new Tok[]{tok, tok2, tok3});
    }

    public void verify(String string, Tok[] tokArray) {
        this.verifyImpl(string, tokArray);
        Tok[] tokArray2 = new Tok[tokArray.length + 1];
        System.arraycopy(tokArray, 0, tokArray2, 0, tokArray.length);
        tokArray2[tokArray.length] = new Tok(10);
        this.verifyImpl(string + ";", tokArray2);
    }

    public void verifyImpl(String string, Tok[] tokArray) {
        Tok[] tokArray2 = this.tokenize(string);
        this.verify(tokArray2.length == tokArray.length);
        for (int i = 0; i < tokArray2.length; ++i) {
            if (verbose) {
                System.out.println("  [" + i + "] " + tokArray2[i] + " ?= " + tokArray[i]);
            }
            this.verify(tokArray2[i], (Object)tokArray[i]);
        }
    }

    public void verifyInvalid(String string) {
        RuntimeException runtimeException = null;
        try {
            this.tokenize(string);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        this.verify(runtimeException != null);
    }

    public void verifyPos(Tok tok, int n, int n2) {
        this.verify(tok.line == n);
    }

    public Tok id(String string) {
        return new Tok(0, string);
    }

    public Tok i(long l) {
        return new Tok(3, l);
    }

    public Tok f(double d) {
        return new Tok(4, d);
    }

    public Tok s(String string) {
        return new Tok(2, string);
    }

    public Tok dec(String string) {
        return new Tok(5, FanDecimal.fromStr(string));
    }

    public Tok dur(long l) {
        return new Tok(6, Duration.make(l));
    }

    public Tok uri(String string) {
        return new Tok(7, Uri.fromStr(string));
    }

    static class Tok {
        int type;
        Object val;
        int line;

        Tok(int n) {
            this(n, null, -1);
        }

        Tok(int n, Object object) {
            this(n, object, -1);
        }

        Tok(int n, Object object, int n2) {
            this.type = n;
            this.val = object;
            this.line = n2;
        }

        public String toString() {
            if (this.val instanceof String) {
                return "\"" + StrUtil.asCode(this.val.toString()) + "\"";
            }
            return Token.toString(this.type) + " " + this.val;
        }

        public boolean equals(Object object) {
            Tok tok = (Tok)object;
            return this.type == tok.type && Test.equals(this.val, tok.val);
        }
    }
}

