/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Enum;
import fan.sys.Env;
import fan.sys.FanInt;
import fan.sys.FanStr;
import fan.sys.List;
import fan.sys.Locale;
import fan.sys.Sys;
import fan.sys.Type;

public final class Weekday
extends Enum {
    public static final Weekday sun = new Weekday(0, "sun");
    public static final Weekday mon = new Weekday(1, "mon");
    public static final Weekday tue = new Weekday(2, "tue");
    public static final Weekday wed = new Weekday(3, "wed");
    public static final Weekday thu = new Weekday(4, "thu");
    public static final Weekday fri = new Weekday(5, "fri");
    public static final Weekday sat = new Weekday(6, "sat");
    static final Weekday[] array = new Weekday[]{sun, mon, tue, wed, thu, fri, sat};
    public static final List vals = (List)new List(Sys.WeekdayType, array).toImmutable();
    private static final List[] localeVals = new List[7];
    final int ord;
    final String localeAbbrKey;
    final String localeFullKey;

    private Weekday(int n, String string) {
        Enum.make$(this, FanInt.pos[n], string.intern());
        this.ord = n;
        this.localeAbbrKey = string + "Abbr";
        this.localeFullKey = string + "Full";
    }

    public static Weekday fromStr(String string) {
        return Weekday.fromStr(string, true);
    }

    public static Weekday fromStr(String string, boolean bl) {
        return (Weekday)Weekday.doFromStr(Sys.WeekdayType, string, bl);
    }

    public Type typeof() {
        return Sys.WeekdayType;
    }

    public Weekday increment() {
        return array[(this.ord + 1) % array.length];
    }

    public Weekday decrement() {
        return this.ord == 0 ? array[array.length - 1] : array[this.ord - 1];
    }

    public String toLocale() {
        return this.toLocale(null);
    }

    public String toLocale(String string) {
        if (string == null) {
            return this.localeAbbr();
        }
        if (FanStr.isEveryChar(string, 87)) {
            switch (string.length()) {
                case 3: {
                    return this.localeAbbr();
                }
                case 4: {
                    return this.localeFull();
                }
            }
        }
        throw ArgErr.make("Invalid pattern: " + string);
    }

    public String localeAbbr() {
        return this.abbr(Locale.cur());
    }

    public String abbr(Locale locale) {
        return Env.cur().locale(Sys.sysPod, this.localeAbbrKey, this.name(), locale);
    }

    public String localeFull() {
        return this.full(Locale.cur());
    }

    public String full(Locale locale) {
        return Env.cur().locale(Sys.sysPod, this.localeFullKey, this.name(), locale);
    }

    public static Weekday localeStartOfWeek() {
        return Weekday.fromStr(Env.cur().locale(Sys.sysPod, "weekdayStart", "sun"));
    }

    public static List localeVals() {
        Weekday weekday = Weekday.localeStartOfWeek();
        List list = localeVals[weekday.ord];
        if (list == null) {
            list = new List(Sys.WeekdayType, 7);
            for (int i = 0; i < 7; ++i) {
                list.add(array[(i + weekday.ord) % 7]);
            }
            Weekday.localeVals[weekday.ord] = (List)list.toImmutable();
        }
        return list;
    }
}

