/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.CastErr;
import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.FanObj;
import fan.sys.Field;
import fan.sys.Func;
import fan.sys.IndexErr;
import fan.sys.Map;
import fan.sys.Method;
import fan.sys.NotImmutableErr;
import fan.sys.NullErr;
import fan.sys.Param;
import fan.sys.Range;
import fan.sys.ReadonlyErr;
import fan.sys.Slot;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.Literal;
import fanx.serial.ObjEncoder;
import fanx.util.OpUtil;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;

public final class List
extends FanObj
implements Literal {
    static final Comparator defaultComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return (int)OpUtil.compare(object, object2);
        }
    };
    static final Comparator defaultReverseComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return (int)OpUtil.compare(object2, object);
        }
    };
    private static final Object[] empty = new Object[0];
    private Type of;
    private Object[] values;
    private int size;
    private boolean readonly;
    private boolean immutable;
    private List readonlyList;

    public static List make(Type type, long l) {
        return new List(type, (int)l);
    }

    public static List makeObj(long l) {
        return new List(Sys.ObjType.toNullable(), (int)l);
    }

    public static List make(Type type, Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        return new List(type, objectArray);
    }

    public List(Type type, Object[] objectArray) {
        if (type == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.of = type;
        this.values = objectArray;
        this.size = objectArray.length;
    }

    public List(Type type, Object[] objectArray, int n) {
        if (type == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.of = type;
        this.values = objectArray;
        this.size = n;
    }

    public List(Type type, int n) {
        if (type == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.of = type;
        this.values = n == 0 ? empty : this.newArray(n);
    }

    public List(Type type) {
        if (type == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.of = type;
        this.values = empty;
    }

    public List(Type type, Collection collection) {
        if (type == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.of = type;
        this.size = collection.size();
        this.values = collection.toArray(this.newArray(this.size));
    }

    public List(String[] stringArray) {
        this.of = Sys.StrType;
        this.size = stringArray.length;
        this.values = stringArray;
    }

    public final Type typeof() {
        return this.of.toListOf();
    }

    public final Type of() {
        return this.of;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final long size() {
        return this.size;
    }

    public final void size(long l) {
        this.modify();
        int n = (int)l;
        if (n > this.size) {
            if (!this.of.isNullable()) {
                throw ArgErr.make("Cannot grow non-nullable list of " + this.of);
            }
            if (n > this.values.length) {
                Object[] objectArray = this.newArray(n);
                System.arraycopy(this.values, 0, objectArray, 0, this.size);
                this.values = objectArray;
            } else {
                for (int i = this.size; i < n; ++i) {
                    this.values[i] = null;
                }
            }
            this.size = n;
        } else {
            for (int i = n; i < this.size; ++i) {
                this.values[i] = null;
            }
            this.size = n;
        }
    }

    public final long capacity() {
        return this.values.length;
    }

    public final void capacity(long l) {
        this.modify();
        int n = (int)l;
        if (n < this.size) {
            throw ArgErr.make("capacity < size");
        }
        Object[] objectArray = this.newArray(n);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        this.values = objectArray;
    }

    public final Object get(long l) {
        try {
            int n = (int)l;
            if (n < 0) {
                n = this.size + n;
            }
            if (n >= this.size) {
                throw IndexErr.make(l);
            }
            return this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make(l);
        }
    }

    public final Object getSafe(long l) {
        return this.getSafe(l, null);
    }

    public final Object getSafe(long l, Object object) {
        if (l < 0L) {
            l = (long)this.size + l;
        }
        if (l >= (long)this.size || l < 0L) {
            return object;
        }
        return this.values[(int)l];
    }

    public final List getRange(Range range) {
        try {
            int n = range.start(this.size);
            int n2 = range.end(this.size);
            int n3 = n2 - n + 1;
            if (n3 < 0) {
                throw IndexErr.make(range);
            }
            List list = new List(this.of, n3);
            list.size = n3;
            System.arraycopy(this.values, n, list.values, 0, n3);
            return list;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make(range);
        }
    }

    public final boolean contains(Object object) {
        return this.index(object) != null;
    }

    public final boolean containsAll(List list) {
        for (int i = 0; i < list.sz(); ++i) {
            if (this.index(list.get(i)) != null) continue;
            return false;
        }
        return true;
    }

    public final boolean containsAny(List list) {
        for (int i = 0; i < list.sz(); ++i) {
            if (this.index(list.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public final Long index(Object object) {
        return this.index(object, 0L);
    }

    public final Long index(Object object, long l) {
        if (this.size == 0) {
            return null;
        }
        int n = (int)l;
        if (n < 0) {
            n = this.size + n;
        }
        if (n >= this.size) {
            throw IndexErr.make(l);
        }
        try {
            if (object == null) {
                for (int i = n; i < this.size; ++i) {
                    if (this.values[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = n; i < this.size; ++i) {
                    Object object2 = this.values[i];
                    if (object2 == null || !object2.equals(object)) continue;
                    return i;
                }
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make(l);
        }
    }

    public final Long indexSame(Object object) {
        return this.indexSame(object, 0L);
    }

    public final Long indexSame(Object object, long l) {
        if (this.size == 0) {
            return null;
        }
        int n = (int)l;
        if (n < 0) {
            n = this.size + n;
        }
        if (n >= this.size) {
            throw IndexErr.make(l);
        }
        try {
            for (int i = n; i < this.size; ++i) {
                if (object != this.values[i]) continue;
                return i;
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make(l);
        }
    }

    public final Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.values[0];
    }

    public final Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.values[this.size - 1];
    }

    public final List dup() {
        Object[] objectArray = this.newArray(this.size);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        return new List(this.of, objectArray);
    }

    public final long hash() {
        long l = 33L;
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            l = 31L * l + (object == null ? 0L : List.hash(object));
        }
        return l;
    }

    public final boolean equals(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            if (!this.of.equals(list.of)) {
                return false;
            }
            if (this.size != list.size) {
                return false;
            }
            for (int i = 0; i < this.size; ++i) {
                if (OpUtil.compareEQ(this.values[i], list.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final List set(long l, Object object) {
        this.modify();
        try {
            int n = (int)l;
            if (n < 0) {
                n = this.size + n;
            }
            if (n >= this.size) {
                throw IndexErr.make(l);
            }
            this.values[n] = object;
            return this;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make(l);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw CastErr.make("Setting '" + FanObj.typeof(object) + "' into '" + this.of + "[]'");
        }
    }

    public final List add(Object object) {
        return this.insert(this.size, object);
    }

    public final List addAll(List list) {
        return this.insertAll(this.size, list);
    }

    public final List insert(long l, Object object) {
        int n = (int)l;
        if (n < 0) {
            n = this.size + n;
        }
        if (n > this.size) {
            throw IndexErr.make(l);
        }
        return this.insert(n, object);
    }

    private List insert(int n, Object object) {
        try {
            this.modify();
            if (this.values.length <= this.size) {
                this.grow(this.size + 1);
            }
            if (n < this.size) {
                System.arraycopy(this.values, n, this.values, n + 1, this.size - n);
            }
            this.values[n] = object;
            ++this.size;
            return this;
        }
        catch (ArrayStoreException arrayStoreException) {
            throw CastErr.make("Adding '" + FanObj.typeof(object) + "' into '" + this.of + "[]'");
        }
    }

    public final List insertAll(long l, List list) {
        int n = (int)l;
        if (n < 0) {
            n = this.size + n;
        }
        if (n > this.size || n < 0) {
            throw IndexErr.make(l);
        }
        return this.insertAll(n, list);
    }

    private List insertAll(int n, List list) {
        this.modify();
        if (list.size == 0) {
            return this;
        }
        if (this.values.length < this.size + list.size) {
            this.grow(this.size + list.size);
        }
        if (n < this.size) {
            System.arraycopy(this.values, n, this.values, n + list.size, this.size - n);
        }
        System.arraycopy(list.values, 0, this.values, n, list.size);
        this.size += list.size;
        return this;
    }

    public final Object remove(Object object) {
        Long l = this.index(object);
        if (l == null) {
            return null;
        }
        return this.removeAt(l);
    }

    public final Object removeSame(Object object) {
        Long l = this.indexSame(object);
        if (l == null) {
            return null;
        }
        return this.removeAt(l);
    }

    public final Object removeAt(long l) {
        this.modify();
        int n = (int)l;
        if (n < 0) {
            n = this.size + n;
        }
        if (n >= this.size) {
            throw IndexErr.make(l);
        }
        Object object = this.values[n];
        if (n < this.size - 1) {
            System.arraycopy(this.values, n + 1, this.values, n, this.size - n - 1);
        }
        --this.size;
        return object;
    }

    public final List removeRange(Range range) {
        this.modify();
        int n = range.start(this.size);
        int n2 = range.end(this.size);
        int n3 = n2 - n + 1;
        if (n3 < 0) {
            throw IndexErr.make(range);
        }
        int n4 = this.size - n - n3;
        if (n4 > 0) {
            System.arraycopy(this.values, n + n3, this.values, n, n4);
        }
        this.size -= n3;
        for (int i = this.size; i < this.size + n3; ++i) {
            this.values[i] = null;
        }
        return this;
    }

    private void grow(int n) {
        int n2 = n;
        if (n2 < 1) {
            throw Err.make("desired " + n2 + " < 1");
        }
        int n3 = Math.max(n2, this.size * 2);
        if (n3 < 10) {
            n3 = 10;
        }
        Object[] objectArray = this.newArray(n3);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        this.values = objectArray;
    }

    public final List trim() {
        this.modify();
        if (this.size == 0) {
            this.values = empty;
        } else if (this.values.length != this.size) {
            Object[] objectArray = this.newArray(this.size);
            System.arraycopy(this.values, 0, objectArray, 0, this.size);
            this.values = objectArray;
        }
        return this;
    }

    public final List clear() {
        this.modify();
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = null;
        }
        this.size = 0;
        return this;
    }

    public final List fill(Object object, long l) {
        this.modify();
        int n = (int)l;
        if (this.values.length < this.size + n) {
            this.grow(this.size + n);
        }
        for (int i = 0; i < n; ++i) {
            this.values[this.size + i] = object;
        }
        this.size += n;
        return this;
    }

    public final Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.values[this.size - 1];
    }

    public final Object pop() {
        if (this.size == 0) {
            return null;
        }
        return this.removeAt(-1L);
    }

    public final List push(Object object) {
        return this.add(object);
    }

    public final void each(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                func.call(this.values[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                func.call(this.values[i], i);
            }
        }
    }

    public final void eachr(Func func) {
        if (func.arity() == 1L) {
            for (int i = this.size - 1; i >= 0; --i) {
                func.call(this.values[i]);
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                func.call(this.values[i], i);
            }
        }
    }

    public final void eachRange(Range range, Func func) {
        int n = range.start(this.size);
        int n2 = range.end(this.size);
        int n3 = n2 - n + 1;
        if (n3 < 0) {
            throw IndexErr.make(range);
        }
        if (func.arity() == 1L) {
            for (int i = n; i <= n2; ++i) {
                func.call(this.values[i]);
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                func.call(this.values[i], i);
            }
        }
    }

    public final Object eachWhile(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                Object object = func.call(this.values[i]);
                if (object == null) continue;
                return object;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                Object object = func.call(this.values[i], i);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public final Object eachrWhile(Func func) {
        if (func.arity() == 1L) {
            for (int i = this.size - 1; i >= 0; --i) {
                Object object = func.call(this.values[i]);
                if (object == null) continue;
                return object;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                Object object = func.call(this.values[i], i);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }

    public final Object find(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i])) continue;
                return this.values[i];
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i], i)) continue;
                return this.values[i];
            }
        }
        return null;
    }

    public final Long findIndex(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                Long l = i;
                if (!func.callBool(this.values[i], l)) continue;
                return l;
            }
        }
        return null;
    }

    public final List findAll(Func func) {
        List list = new List(this.of, this.size);
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i])) continue;
                list.add(this.values[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i], i)) continue;
                list.add(this.values[i]);
            }
        }
        return list;
    }

    public final List findType(Type type) {
        List list = new List(type, this.size);
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            if (object == null || !List.typeof(object).is(type)) continue;
            list.add(object);
        }
        return list;
    }

    public final List exclude(Func func) {
        List list = new List(this.of, this.size);
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (func.callBool(this.values[i])) continue;
                list.add(this.values[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (func.callBool(this.values[i], i)) continue;
                list.add(this.values[i]);
            }
        }
        return list;
    }

    public final boolean any(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i])) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!func.callBool(this.values[i], i)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean all(Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                if (func.callBool(this.values[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (func.callBool(this.values[i], i)) continue;
                return false;
            }
        }
        return true;
    }

    public final Object reduce(Object object, Func func) {
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                object = func.call(object, this.values[i]);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                object = func.call(object, this.values[i], i);
            }
        }
        return object;
    }

    public final List map(Func func) {
        Type type = func.returns();
        if (type == Sys.VoidType) {
            type = Sys.ObjType.toNullable();
        }
        List list = new List(type, (int)this.size());
        if (func.arity() == 1L) {
            for (int i = 0; i < this.size; ++i) {
                list.add(func.call(this.values[i]));
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                list.add(func.call(this.values[i], i));
            }
        }
        return list;
    }

    public final Object max() {
        return this.max(null);
    }

    public final Object max(Func func) {
        if (this.size == 0) {
            return null;
        }
        Comparator comparator = List.toComparator(func);
        Object object = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (comparator.compare(this.values[i], object) <= 0) continue;
            object = this.values[i];
        }
        return object;
    }

    public final Object min() {
        return this.min(null);
    }

    public final Object min(Func func) {
        if (this.size == 0) {
            return null;
        }
        Comparator comparator = List.toComparator(func);
        Object object = this.values[0];
        for (int i = 1; i < this.size; ++i) {
            if (comparator.compare(this.values[i], object) >= 0) continue;
            object = this.values[i];
        }
        return object;
    }

    public final List unique() {
        if (this.size <= 1) {
            return this.dup();
        }
        HashMap<Object, List> hashMap = new HashMap<Object, List>(this.size * 3);
        List list = new List(this.of, this.size);
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            if (hashMap.get(object) != null) continue;
            hashMap.put(object, this);
            list.add(object);
        }
        return list;
    }

    public final List union(List list) {
        Object object;
        int n;
        int n2 = this.size + list.size;
        HashMap<Object, List> hashMap = new HashMap<Object, List>(n2 * 3);
        List list2 = new List(this.of, n2);
        for (n = 0; n < this.size; ++n) {
            object = this.values[n];
            if (hashMap.get(object) != null) continue;
            hashMap.put(object, this);
            list2.add(object);
        }
        for (n = 0; n < list.size; ++n) {
            object = list.values[n];
            if (hashMap.get(object) != null) continue;
            hashMap.put(object, this);
            list2.add(object);
        }
        return list2;
    }

    public final List intersection(List list) {
        HashMap<Object, List> hashMap = new HashMap<Object, List>(list.size * 3);
        for (int i = 0; i < list.size; ++i) {
            hashMap.put(list.values[i], this);
        }
        List list2 = new List(this.of, this.size);
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            if (hashMap.get(object) == null) continue;
            list2.add(object);
            hashMap.remove(object);
        }
        return list2;
    }

    public final List sort() {
        return this.sort(null);
    }

    public final List sort(Func func) {
        this.modify();
        Arrays.sort(this.values, 0, this.size, List.toComparator(func));
        return this;
    }

    public final List sortr() {
        return this.sortr(null);
    }

    public final List sortr(Func func) {
        this.modify();
        Arrays.sort(this.values, 0, this.size, List.toReverseComparator(func));
        return this;
    }

    public final long binarySearch(Object object) {
        return this.binarySearch(object, null);
    }

    public final long binarySearch(Object object, Func func) {
        Comparator comparator = List.toComparator(func);
        Object[] objectArray = this.values;
        int n = 0;
        int n2 = this.size - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            int n4 = comparator.compare(objectArray[n3], object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public final long binaryFind(Func func) {
        boolean bl;
        Object[] objectArray = this.values;
        int n = 0;
        int n2 = this.size - 1;
        boolean bl2 = bl = func.arity() == 1L;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object = objectArray[n3];
            Object object2 = bl ? func.call(object) : func.call(object, n3);
            long l = (Long)object2;
            if (l > 0L) {
                n = n3 + 1;
                continue;
            }
            if (l < 0L) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public final List reverse() {
        this.modify();
        Object[] objectArray = this.values;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2 = objectArray[i];
            objectArray[i] = object = objectArray[n - i - 1];
            objectArray[n - i - 1] = object2;
        }
        return this;
    }

    public final List swap(long l, long l2) {
        Object object = this.get(l);
        this.set(l, this.get(l2));
        this.set(l2, object);
        return this;
    }

    public final List moveTo(Object object, long l) {
        this.modify();
        Long l2 = this.index(object);
        if (l2 == null) {
            return this;
        }
        if (l2 == l) {
            return this;
        }
        this.removeAt(l2);
        if (l == -1L) {
            return this.add(object);
        }
        if (l < 0L) {
            ++l;
        }
        return this.insert(l, object);
    }

    public final List flatten() {
        List list = new List(Sys.ObjType.toNullable(), this.size * 2);
        this.doFlatten(list);
        return list;
    }

    private void doFlatten(List list) {
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            if (object instanceof List) {
                ((List)object).doFlatten(list);
                continue;
            }
            list.add(object);
        }
    }

    public final Object random() {
        if (this.size == 0) {
            return null;
        }
        int n = FanInt.random.nextInt();
        if (n < 0) {
            n = -n;
        }
        return this.values[n % this.size];
    }

    public final List shuffle() {
        this.modify();
        for (int i = 0; i < this.size; ++i) {
            int n = FanInt.random.nextInt(i + 1);
            Object object = this.values[i];
            this.values[i] = this.values[n];
            this.values[n] = object;
        }
        return this;
    }

    public final String join() {
        return this.join("", null);
    }

    public final String join(String string) {
        return this.join(string, null);
    }

    public final String join(String string, Func func) {
        if (this.size == 0) {
            return "";
        }
        if (this.size == 1) {
            Object object = this.values[0];
            if (func != null) {
                return (String)func.call(object, 0L);
            }
            if (object == null) {
                return "null";
            }
            return List.toStr(object);
        }
        StringBuilder stringBuilder = new StringBuilder(32 + this.size * 32);
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            if (func == null) {
                stringBuilder.append(this.values[i]);
                continue;
            }
            stringBuilder.append(func.call(this.values[i], i));
        }
        return stringBuilder.toString();
    }

    public final String toStr() {
        if (this.size == 0) {
            return "[,]";
        }
        StringBuilder stringBuilder = new StringBuilder(32 + this.size * 32);
        stringBuilder.append("[");
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.values[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final String toCode() {
        StringBuilder stringBuilder = new StringBuilder(32 + this.size * 32);
        stringBuilder.append(this.of.signature());
        stringBuilder.append('[');
        if (this.size == 0) {
            stringBuilder.append(',');
        }
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(FanObj.trap(this.values[i], "toCode", null));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final void encode(ObjEncoder objEncoder) {
        objEncoder.writeList(this);
    }

    public final int sz() {
        return this.size;
    }

    public final Object get(int n) {
        try {
            if (n >= this.size) {
                throw IndexErr.make("" + n);
            }
            return this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make("" + n);
        }
    }

    private Object[] newArray(int n) {
        Type type = this.of.toNonNullable();
        if (type == Sys.ObjType) {
            return new Object[n];
        }
        if (type == Sys.StrType) {
            return new String[n];
        }
        if (type == Sys.IntType) {
            return new Long[n];
        }
        if (type == Sys.BoolType) {
            return new Boolean[n];
        }
        if (type == Sys.FloatType) {
            return new Double[n];
        }
        if (type == Sys.DecimalType) {
            return new BigDecimal[n];
        }
        if (type == Sys.NumType) {
            return new Number[n];
        }
        if (type == Sys.SlotType) {
            return new Slot[n];
        }
        if (type == Sys.FieldType) {
            return new Field[n];
        }
        if (type == Sys.MethodType) {
            return new Method[n];
        }
        if (type == Sys.ParamType) {
            return new Param[n];
        }
        return (Object[])Array.newInstance(this.of.toClass(), n);
    }

    public final Object[] asArray(Class clazz) {
        if (this.size == this.values.length && clazz == this.values.getClass().getComponentType()) {
            return this.values;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.size);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public final Object[] toArray() {
        if (this.values.length == this.size) {
            return this.values;
        }
        Object[] objectArray = this.newArray(this.size);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public final Object[] toArray(Object[] objectArray) {
        try {
            System.arraycopy(this.values, 0, objectArray, 0, this.size);
            return objectArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make();
        }
    }

    public final Object[] toArray(Object[] objectArray, int n, int n2) {
        try {
            System.arraycopy(this.values, n, objectArray, 0, n2);
            return objectArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make();
        }
    }

    public final Object[] copyInto(Object[] objectArray, int n, int n2) {
        try {
            System.arraycopy(this.values, 0, objectArray, n, n2);
            return objectArray;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw IndexErr.make();
        }
    }

    public final String[] toStrings() {
        String[] stringArray = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            Object object = this.get(i);
            stringArray[i] = object == null ? "null" : List.toStr(object);
        }
        return stringArray;
    }

    public final int[] toInts() {
        int[] nArray = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            nArray[i] = ((Long)this.get(i)).intValue();
        }
        return nArray;
    }

    static Comparator toComparator(final Func func) {
        if (func == null) {
            return defaultComparator;
        }
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Long)func.call(object, object2)).intValue();
            }
        };
    }

    static Comparator toReverseComparator(final Func func) {
        if (func == null) {
            return defaultReverseComparator;
        }
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Long)func.call(object2, object)).intValue();
            }
        };
    }

    public final boolean isRW() {
        return !this.readonly;
    }

    public final boolean isRO() {
        return this.readonly;
    }

    public final List rw() {
        if (!this.readonly) {
            return this;
        }
        Object[] objectArray = this.newArray(this.size);
        System.arraycopy(this.values, 0, objectArray, 0, this.size);
        List list = new List(this.of);
        list.values = objectArray;
        list.size = this.size;
        list.readonly = false;
        list.readonlyList = this;
        return list;
    }

    public final List ro() {
        if (this.readonly) {
            return this;
        }
        if (this.readonlyList == null) {
            List list = new List(this.of);
            list.values = this.values;
            list.size = this.size;
            list.readonly = true;
            this.readonlyList = list;
        }
        return this.readonlyList;
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    public final Object toImmutable() {
        if (this.immutable) {
            return this;
        }
        Object[] objectArray = this.newArray(this.size);
        for (int i = 0; i < this.size; ++i) {
            Object object = this.values[i];
            if (object != null) {
                if (object instanceof List) {
                    object = ((List)object).toImmutable();
                } else if (object instanceof Map) {
                    object = ((Map)object).toImmutable();
                } else if (!List.isImmutable(object)) {
                    throw NotImmutableErr.make("Item [" + i + "] not immutable " + List.typeof(object));
                }
            }
            objectArray[i] = object;
        }
        List list = new List(this.of, objectArray);
        list.readonly = true;
        list.immutable = true;
        return list;
    }

    private void modify() {
        if (this.readonly) {
            throw ReadonlyErr.make("List is readonly");
        }
        if (this.readonlyList != null) {
            Object[] objectArray = this.newArray(this.size);
            System.arraycopy(this.values, 0, objectArray, 0, this.size);
            this.readonlyList.values = objectArray;
            this.readonlyList = null;
        }
    }
}

