/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.CastErr;
import fan.sys.Env;
import fan.sys.IOErr;
import fan.sys.IndexErr;
import fan.sys.InterruptedErr;
import fan.sys.Map;
import fan.sys.MemBuf;
import fan.sys.NullErr;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import java.io.IOException;

public class Err
extends RuntimeException {
    String msg = "";
    Err cause;
    Throwable actual;

    public static Err make(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof Err) {
            return (Err)throwable;
        }
        if (throwable instanceof NullPointerException) {
            return new NullErr(throwable);
        }
        if (throwable instanceof ClassCastException) {
            return new CastErr(throwable);
        }
        if (throwable instanceof IndexOutOfBoundsException) {
            return new IndexErr(throwable);
        }
        if (throwable instanceof IllegalArgumentException) {
            return new ArgErr(throwable);
        }
        if (throwable instanceof IOException) {
            return new IOErr(throwable);
        }
        if (throwable instanceof InterruptedException) {
            return new InterruptedErr(throwable);
        }
        if (throwable instanceof UnsupportedOperationException) {
            return new UnsupportedErr(throwable);
        }
        return new Err(throwable);
    }

    public static String fanToJava(String string) {
        if (string.equals("fan/sys/NullErr")) {
            return "java/lang/NullPointerException";
        }
        if (string.equals("fan/sys/CastErr")) {
            return "java/lang/ClassCastException";
        }
        if (string.equals("fan/sys/IndexErr")) {
            return "java/lang/IndexOutOfBoundsException";
        }
        if (string.equals("fan/sys/ArgErr")) {
            return "java/lang/IllegalArgumentException";
        }
        if (string.equals("fan/sys/IOErr")) {
            return "java/io/IOException";
        }
        if (string.equals("fan/sys/InterruptedErr")) {
            return "java/lang/InterruptedException";
        }
        if (string.equals("fan/sys/UnsupportedErr")) {
            return "java/lang/UnsupportedOperationException";
        }
        return null;
    }

    public static Err make(String string, Throwable throwable) {
        return Err.make(string, Err.make(throwable));
    }

    public static Err make() {
        return Err.make("", null);
    }

    public static Err make(String string) {
        return Err.make(string, null);
    }

    public static Err make(String string, Err err) {
        Err err2 = new Err();
        Err.make$(err2, string, err);
        return err2;
    }

    public static void make$(Err err) {
        Err.make$(err, null);
    }

    public static void make$(Err err, String string) {
        Err.make$(err, string, null);
    }

    public static void make$(Err err, String string, Err err2) {
        if (string == null) {
            throw NullErr.make("msg is null");
        }
        err.msg = string;
        err.cause = err2;
    }

    public Err(Throwable throwable) {
        this.actual = throwable;
        this.msg = throwable.toString();
    }

    public Err() {
    }

    public String msg() {
        return this.msg;
    }

    public Err cause() {
        return this.cause;
    }

    public Type typeof() {
        return Sys.ErrType;
    }

    public final String toString() {
        return this.toStr();
    }

    public String toStr() {
        String string;
        try {
            string = this.typeof().qname();
        }
        catch (Throwable throwable) {
            string = this.getClass().getName();
        }
        if (this.msg == null || this.msg.length() == 0) {
            return string;
        }
        return string + ": " + this.msg;
    }

    public Err trace() {
        return this.trace(Env.cur().out(), null, 0, true);
    }

    public Err trace(OutStream outStream) {
        return this.trace(outStream, null, 0, true);
    }

    public Err trace(OutStream outStream, Map map) {
        return this.trace(outStream, map, 0, true);
    }

    public Err trace(OutStream outStream, Map map, int n, boolean bl) {
        String string;
        StackTraceElement stackTraceElement;
        int n2;
        Long l;
        Err err = this.actual != null && bl ? this.actual : this;
        StackTraceElement[] stackTraceElementArray = err.getStackTrace();
        int n3 = 20;
        if (map != null && (l = (Long)map.get("maxDepth")) != null) {
            n3 = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : l.intValue();
        }
        for (n2 = 0; n2 < stackTraceElementArray.length && (stackTraceElement = stackTraceElementArray[n2]).getClassName().endsWith("Err") && ((string = stackTraceElement.getMethodName()).equals("make") || string.equals("<init>") || string.equals("rebase")); ++n2) {
        }
        outStream.indent(n).writeChars(this.toStr()).writeChar('\n');
        int n4 = 0;
        for (int i = n2; i < stackTraceElementArray.length; ++i) {
            if (Err.trace(stackTraceElementArray[i], outStream, n + 2)) {
                ++n4;
            }
            if (n4 < n3) continue;
            int n5 = stackTraceElementArray.length - i - n2;
            if (n5 <= 0) break;
            outStream.indent(n + 2).writeChars(n5 + " More...\n");
            break;
        }
        outStream.flush();
        if (bl && this.actual instanceof RebaseException) {
            this.trace(outStream, map, n + 2, false);
        }
        if (this.cause != null) {
            outStream.indent(n).writeChars("Cause:\n");
            this.cause.trace(outStream, map, n + 2, true);
        }
        return this;
    }

    public static boolean trace(StackTraceElement stackTraceElement, OutStream outStream, int n) {
        String string = stackTraceElement.getClassName();
        String string2 = stackTraceElement.getMethodName();
        String string3 = stackTraceElement.getFileName();
        int n2 = stackTraceElement.getLineNumber();
        if (string.startsWith("sun.reflect.")) {
            return false;
        }
        if (string.startsWith("fan.") && !string.startsWith("fan.sys.")) {
            String string4 = "?";
            String string5 = string;
            String string6 = string2;
            int n3 = string.indexOf(46, 5);
            if (n3 > 0) {
                int n4;
                string4 = string.substring(4, n3);
                string5 = string.substring(n3 + 1);
                int n5 = string5.indexOf(36);
                int n6 = n4 = n5 < 0 ? -1 : string5.indexOf(36, n5 + 1);
                if (n4 > 0) {
                    if (string6.startsWith("call")) {
                        return false;
                    }
                    if (string6.startsWith("doCall")) {
                        string6 = string5.substring(n5 + 1, n4);
                        string5 = string5.substring(0, n5);
                    }
                }
            }
            outStream.indent(n).writeChars(string4).writeChar(':').writeChar(':').writeChars(string5).writeChar('.').writeChars(string6);
        } else {
            outStream.indent(n).writeChars(string).writeChar('.').writeChars(string2).writeChars("");
        }
        outStream.writeChar(' ').writeChar('(');
        if (string3 == null) {
            outStream.writeChars("Unknown");
        } else {
            outStream.writeChars(string3);
        }
        if (n2 > 0) {
            outStream.writeChar(':').writeChars(String.valueOf(n2));
        }
        outStream.writeChar(')').writeChar('\n');
        return true;
    }

    public String traceToStr() {
        MemBuf memBuf = new MemBuf(1024);
        this.trace(memBuf.out());
        return memBuf.flip().readAllStr();
    }

    public Throwable toJava() {
        if (this.actual != null) {
            return this.actual;
        }
        return this;
    }

    public Err rebase() {
        this.actual = new RebaseException();
        return this;
    }

    public static class RebaseException
    extends RuntimeException {
    }
}

