/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.epubcheck.util.text;

import com.google.common.base.Preconditions;
import com.ibm.icu.text.CaseMap;
import com.ibm.icu.text.Normalizer2;

public final class UnicodeUtils {
    private static final Normalizer2 NFD_NORMALIZER = Normalizer2.getNFDInstance();
    private static final Normalizer2 NFC_NORMALIZER = Normalizer2.getNFCInstance();
    private static final CaseMap.Fold CASE_FOLDER = CaseMap.fold();

    private UnicodeUtils() {
    }

    public static String canonicalCaseFold(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return CASE_FOLDER.apply(NFD_NORMALIZER.normalize(string));
    }

    public static String normalize(String string) {
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        return NFC_NORMALIZER.normalize(string);
    }
}

