/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class ZeroOrMore<T extends Item>
implements GroundedValue,
Iterable<T> {
    private final List<T> value;

    public ZeroOrMore(List<T> list) {
        this.value = list;
    }

    protected List<T> getValue() {
        return this.value;
    }

    public static <T extends Item> ZeroOrMore<T> fromSequenceIterator(SequenceIterator iter) throws XPathException {
        Item item;
        ArrayList<Item> list = new ArrayList<Item>();
        while ((item = iter.next()) != null) {
            list.add(item);
        }
        return new ZeroOrMore(list);
    }

    @Override
    public UnicodeString getUnicodeStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.stringify(this);
    }

    public T head() {
        return this.itemAt(0);
    }

    @Override
    public int getLength() {
        return this.value.size();
    }

    public int getCardinality() {
        switch (this.value.size()) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    public T itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return (T)((Item)this.value.get(n));
    }

    @Override
    public ListIterator.Of<T> iterate() {
        return new ListIterator.Of<T>(this.value);
    }

    public SequenceIterator reverseIterate() {
        return Reverse.reverseIterator(this.value);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        Item first = (Item)this.value.get(0);
        if (first instanceof NodeInfo) {
            return true;
        }
        if (len == 1 && first instanceof AtomicValue) {
            return first.effectiveBooleanValue();
        }
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (start < 0) {
            start = 0;
        }
        if (start > this.value.size()) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent.Of<T>(this.value.subList(start, start + length)).reduce();
    }

    public String toString() {
        StringBuilder fsb = new StringBuilder(64);
        for (int i = 0; i < this.value.size(); ++i) {
            fsb.append(i == 0 ? "(" : ", ");
            fsb.append(((Item)this.value.get(i)).toString());
        }
        fsb.append(')');
        return fsb.toString();
    }

    @Override
    public GroundedValue reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.value.iterator();
    }
}

