/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.util.TextUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class SpiceSegmentedNets {
    private final Spice.SpicePreferences sp;
    private Map<PortInst, NetInfo> segmentedNets = new HashMap<PortInst, NetInfo>();
    private Map<ArcInst, Double> arcRes = new HashMap<ArcInst, Double>();
    private boolean verboseNames = false;
    private Topology.CellNetInfo cni;
    private Map<Network, Integer> netCounters;
    private Cell cell;
    private List<List<String>> shortedExports;
    private Map<ArcInst, Double> longArcCaps;
    private Map<Network, Network> extractedNets;
    private static Comparator<PortInst> PORT_INST_COMPARATOR = new Comparator<PortInst>(){

        @Override
        public int compare(PortInst p1, PortInst p2) {
            if (p1 == p2) {
                return 0;
            }
            int cmp = p1.getNodeInst().compareTo(p2.getNodeInst());
            if (cmp != 0) {
                return cmp;
            }
            if (p1.getPortIndex() < p2.getPortIndex()) {
                return -1;
            }
            return 1;
        }
    };

    public SpiceSegmentedNets(Cell cell, boolean verboseNames, Topology.CellNetInfo cni, Spice.SpicePreferences sp2) {
        this.verboseNames = verboseNames;
        this.cni = cni;
        this.sp = sp2;
        this.netCounters = new HashMap<Network, Integer>();
        this.cell = cell;
        this.shortedExports = new ArrayList<List<String>>();
        this.longArcCaps = new HashMap<ArcInst, Double>();
        this.extractedNets = new HashMap<Network, Network>();
    }

    public NetInfo putSegment(PortInst pi, double cap) {
        NetInfo info = this.segmentedNets.get(pi);
        if (info == null) {
            info = new NetInfo();
            info.netName = this.getNewName(pi, info);
            info.cap += cap;
            if (this.isPowerGround(pi)) {
                info.cap = 0.0;
            }
            info.joinedPorts.add(pi);
            this.segmentedNets.put(pi, info);
        } else {
            info.cap += cap;
        }
        return info;
    }

    private String getNewName(PortInst pi, NetInfo info) {
        Export ex;
        Network net = this.cni.getNetList().getNetwork(pi);
        Topology.CellSignal cs = this.cni.getCellSignal(net);
        if (this.sp.parasiticsLevel == SimulationTool.SpiceParasitics.SIMPLE || !this.sp.parasiticsExtractPowerGround && this.isPowerGround(pi)) {
            return cs.getName();
        }
        Integer i = this.netCounters.get(net);
        if (i == null) {
            i = new Integer(0);
            this.netCounters.put(net, i);
        }
        String name = info.netName;
        Export export = ex = pi.getExports().hasNext() ? pi.getExports().next() : null;
        if (ex != null) {
            name = ex.getName();
        } else {
            name = i == 0 && !cs.isExported() ? cs.getName() : (this.verboseNames ? cs.getName() + "#" + i + pi.getNodeInst().getName() + "_" + pi.getPortProto().getName() : cs.getName() + "#" + i);
            i = new Integer(i + 1);
            this.netCounters.put(net, i);
        }
        return name;
    }

    public void shortSegments(PortInst p1, PortInst p2) {
        if (!this.segmentedNets.containsKey(p1)) {
            this.putSegment(p1, 0.0);
        }
        if (!this.segmentedNets.containsKey(p2)) {
            // empty if block
        }
        this.putSegment(p2, 0.0);
        NetInfo info1 = this.segmentedNets.get(p1);
        NetInfo info2 = this.segmentedNets.get(p2);
        if (info1 == info2) {
            return;
        }
        info1.joinedPorts.addAll(info2.joinedPorts);
        info1.cap += info2.cap;
        if (TextUtils.STRING_NUMBER_ORDER.compare(info2.netName, info1.netName) < 0) {
            info1.netName = info2.netName;
        }
        for (PortInst pi : info1.joinedPorts) {
            this.segmentedNets.put(pi, info1);
        }
    }

    public String getNetName(PortInst pi) {
        if (this.sp.parasiticsLevel == SimulationTool.SpiceParasitics.SIMPLE || this.isPowerGround(pi) && !this.sp.parasiticsExtractPowerGround) {
            Topology.CellSignal cs = this.cni.getCellSignal(this.cni.getNetList().getNetwork(pi));
            if (cs == null) {
                return null;
            }
            return cs.getName();
        }
        NetInfo info = this.segmentedNets.get(pi);
        if (info == null) {
            Topology.CellSignal cs = this.cni.getCellSignal(this.cni.getNetList().getNetwork(pi));
            if (cs == null) {
                return null;
            }
            return cs.getName();
        }
        return info.netName;
    }

    public void addArcRes(ArcInst ai, double res) {
        if (this.isPowerGround(ai.getHeadPortInst()) && this.isPowerGround(ai.getTailPortInst()) && !SimulationTool.isParasiticsExtractPowerGround()) {
            this.shortSegments(ai.getHeadPortInst(), ai.getTailPortInst());
            return;
        }
        this.arcRes.put(ai, new Double(res));
    }

    public Double getRes(ArcInst ai) {
        return this.arcRes.get(ai);
    }

    public boolean isPowerGround(PortInst pi) {
        Network net = this.cni.getNetList().getNetwork(pi);
        Topology.CellSignal cs = this.cni.getCellSignal(net);
        if (cs == null) {
            return false;
        }
        if (cs.isPower() || cs.isGround()) {
            return true;
        }
        if (cs.getName().startsWith("vdd")) {
            return true;
        }
        return cs.getName().startsWith("gnd");
    }

    public TreeSet<NetInfo> getUniqueSegments() {
        return new TreeSet<NetInfo>(this.segmentedNets.values());
    }

    public SimulationTool.SpiceParasitics getParasiticsLevel() {
        return this.sp.parasiticsLevel;
    }

    public void addShortedExports(List<String> exports) {
        this.shortedExports.add(exports);
    }

    public Iterator<List<String>> getShortedExports() {
        return this.shortedExports.iterator();
    }

    public static int getNumPISegments(double res, double maxSeriesResistance) {
        if (res <= 0.0) {
            return 1;
        }
        int arcPImodels = 1;
        arcPImodels = (int)(res / maxSeriesResistance);
        if (res % maxSeriesResistance != 0.0) {
            ++arcPImodels;
        }
        return arcPImodels;
    }

    public void addArcCap(ArcInst ai, double cap) {
        this.longArcCaps.put(ai, new Double(cap));
    }

    public double getArcCap(ArcInst ai) {
        Double d = this.longArcCaps.get(ai);
        return d;
    }

    public void addExtractedNet(Network net) {
        this.extractedNets.put(net, net);
    }

    public boolean isExtractedNet(Network net) {
        return this.extractedNets.containsKey(net);
    }

    public Cell getCell() {
        return this.cell;
    }

    public static class NetInfo
    implements Comparable {
        private String netName = "unassigned";
        private double cap = 0.0;
        private TreeSet<PortInst> joinedPorts = new TreeSet(SpiceSegmentedNets.access$300());

        public int compareTo(Object obj) {
            NetInfo that = (NetInfo)obj;
            if (this.joinedPorts.isEmpty()) {
                return that.joinedPorts.isEmpty() ? 0 : -1;
            }
            if (that.joinedPorts.isEmpty()) {
                return 1;
            }
            return PORT_INST_COMPARATOR.compare(this.joinedPorts.first(), that.joinedPorts.first());
        }

        public Iterator<PortInst> getPortIterator() {
            return this.joinedPorts.iterator();
        }

        public double getCap() {
            return this.cap;
        }

        public String getName() {
            return this.netName;
        }
    }
}

