/*
 * Decompiled with CFR 0.152.
 */
package p.rn.name;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.LazyMap;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;
import p.rn.ClassInfo;
import p.rn.Scann;
import p.rn.util.AccUtils;
import p.rn.util.FileOut;
import p.rn.util.FileWalker;

public class Renamer {
    private static final Remapper EmptyRemapper = new SimpleRemapper(Collections.emptyMap());
    private File from;
    private Remapper remapper;
    private File to;

    private static String doReplace(Collection<E> replace, String str) {
        for (E e : replace) {
            str = str.replaceAll(e.key, e.value);
        }
        return str;
    }

    private void check() {
        if (this.from == null || this.to == null) {
            throw new RuntimeException("from and to must be set");
        }
        if (this.remapper == null) {
            this.remapper = EmptyRemapper;
        }
    }

    private void doRename() throws IOException {
        this.check();
        final Map<String, ClassInfo> clzMap = Scann.scanLib(this.from);
        final HashMap<String, String> _enum = new HashMap<String, String>();
        for (ClassInfo classInfo : clzMap.values()) {
            for (List<ClassInfo.MemberInfo> fs : classInfo.members.values()) {
                for (ClassInfo.MemberInfo f : fs) {
                    int access = f.access;
                    if (AccUtils.isEnum(classInfo.access) && AccUtils.isSynthetic(access) && AccUtils.isPrivate(access) && AccUtils.isStatic(access) && AccUtils.isFinal(access) && f.desc.equals("[L" + classInfo.name + ";") && !"ENUM$VALUES".equals(f.name)) {
                        _enum.put(String.valueOf(classInfo.name) + "." + f.name, "ENUM$VALUES");
                    }
                    if (!AccUtils.isSynthetic(access) || AccUtils.isPrivate(access) || AccUtils.isPublic(access) || AccUtils.isProtected(access) || !AccUtils.isStatic(access) || !f.desc.equals("Z") || "$assertionsDisabled".equals(f.name)) continue;
                    _enum.put(String.valueOf(classInfo.name) + "." + f.name, "$assertionsDisabled");
                }
            }
        }
        final Remapper xRemapper = new Remapper(){

            private String findOwner(String clz, String name, String desc) {
                String key;
                ClassInfo classInfo = (ClassInfo)clzMap.get(clz);
                int index = desc.indexOf(41);
                String string = key = index >= 0 ? String.valueOf(name) + desc.substring(0, index + 1) : name;
                if (classInfo != null) {
                    List<ClassInfo.MemberInfo> members = classInfo.members.get(key);
                    if (members != null) {
                        for (ClassInfo.MemberInfo m : members) {
                            if (!m.name.equals(name) || !m.desc.equals(desc) || !AccUtils.isPrivate(m.access)) continue;
                            return clz;
                        }
                    }
                    for (String p : classInfo.parent) {
                        String oS = this.findOwnerNotPrivate(p, name, desc, key);
                        if (oS == null) continue;
                        return oS;
                    }
                }
                return null;
            }

            private String findOwnerNotPrivate(String clz, String name, String desc, String key) {
                ClassInfo classInfo = (ClassInfo)clzMap.get(clz);
                if (classInfo != null) {
                    for (String p : classInfo.parent) {
                        String oS = this.findOwnerNotPrivate(p, name, desc, key);
                        if (oS == null) continue;
                        return oS;
                    }
                    List<ClassInfo.MemberInfo> members = classInfo.members.get(key);
                    if (members != null) {
                        for (ClassInfo.MemberInfo m : members) {
                            if (!m.name.equals(name) || !m.desc.equals(desc) || AccUtils.isPrivate(m.access)) continue;
                            return clz;
                        }
                    }
                }
                return null;
            }

            public String map(String typeName) {
                if (typeName.startsWith("java/") || typeName.startsWith("javax/")) {
                    return typeName;
                }
                if (typeName.charAt(0) == 'L' && typeName.charAt(typeName.length() - 1) == ';') {
                    return String.valueOf('L') + this.map(typeName.substring(1, typeName.length() - 1)) + ';';
                }
                return Renamer.this.remapper.map(typeName);
            }

            public String mapFieldName(String owner, String name, String desc) {
                if (owner.startsWith("java/") || owner.startsWith("javax/")) {
                    return name;
                }
                String nName = (String)_enum.get(String.valueOf(owner) + "." + name);
                if (nName != null) {
                    return nName;
                }
                String nOwner = this.findOwner(owner, name, desc);
                return Renamer.this.remapper.mapFieldName(nOwner == null ? owner : nOwner, name, desc);
            }

            public String mapMethodName(String owner, String name, String desc) {
                if (owner.startsWith("java/") || owner.startsWith("javax/") || name.startsWith("<")) {
                    return name;
                }
                String nOwner = this.findOwner(owner, name, desc);
                return Renamer.this.remapper.mapMethodName(nOwner == null ? owner : nOwner, name, desc);
            }
        };
        final FileOut.OutHandler zo = FileOut.create(this.to);
        new FileWalker().withStreamHandler(new FileWalker.StreamHandler(){

            @Override
            public void handle(boolean isDir, String name, FileWalker.StreamOpener current, Object nameObject) throws IOException {
                if (!isDir) {
                    if (name.endsWith(".class")) {
                        ClassWriter cw = new ClassWriter(0);
                        new ClassReader(current.get()).accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)cw, xRemapper), 8);
                        name = name.substring(0, name.length() - ".class".length());
                        name = xRemapper.map(name);
                        zo.write(false, String.valueOf(name) + ".class", cw.toByteArray(), null);
                    } else {
                        zo.write(false, name, current.get(), nameObject);
                    }
                }
            }
        }).walk(this.from);
        zo.close();
    }

    public Renamer from(File file) {
        this.from = file;
        return this;
    }

    public void to(File to) throws IOException {
        this.to = to;
        this.doRename();
    }

    public Renamer withConfig(File config) throws IOException {
        final HashMap<String, String> clz = new HashMap<String, String>();
        final HashMap<String, String> pkg = new HashMap<String, String>();
        final HashMap<String, String> member = new HashMap<String, String>();
        TreeSet<E> replace = new TreeSet<E>();
        if (config != null) {
            for (String ln : FileUtils.readLines((File)config, (String)"UTF-8")) {
                int index;
                if ("".equals(ln) || ln.startsWith("#") || (index = ln.lastIndexOf(61)) <= 0) continue;
                String key = ln.substring(2, index);
                String value = ln.substring(index + 1);
                switch (ln.charAt(0)) {
                    case 'F': 
                    case 'M': 
                    case 'f': 
                    case 'm': {
                        member.put(Renamer.doReplace(replace, key), value);
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        clz.put(Renamer.doReplace(replace, key), value);
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        pkg.put(Renamer.doReplace(replace, key), value);
                        break;
                    }
                    case '@': {
                        E e = new E();
                        e.key = String.valueOf('@') + key;
                        e.value = Renamer.doReplace(replace, value);
                        replace.add(e);
                    }
                }
            }
        }
        return this.withTransformer(new Transformer(){
            private Map<String, String> pkgCache = new HashMap<String, String>();

            private StringBuilder doClass(String str) {
                int index = str.lastIndexOf(36);
                if (index > 0) {
                    String nName = (String)clz.get(str);
                    if (nName == null) {
                        nName = str.substring(index + 1);
                    }
                    return this.doClass(str.substring(0, index)).append("$").append(nName);
                }
                index = str.lastIndexOf(47);
                String nName = (String)clz.get(str);
                if (index > 0) {
                    if (nName == null) {
                        nName = str.substring(index + 1);
                    }
                    return this.doPkg(str.substring(0, index)).append('/').append(nName);
                }
                if (nName == null) {
                    nName = str;
                }
                return new StringBuilder(nName);
            }

            private StringBuilder doPkg(String str) {
                StringBuilder sb;
                String x = this.pkgCache.get(str);
                if (x != null) {
                    return new StringBuilder(x);
                }
                int index = str.lastIndexOf(47);
                String nName = (String)pkg.get(str);
                if (index > 0) {
                    if (nName == null) {
                        nName = str.substring(index + 1);
                    }
                    sb = this.doPkg(str.substring(0, index)).append('/').append(nName);
                } else {
                    if (nName == null) {
                        nName = str;
                    }
                    sb = new StringBuilder(nName);
                }
                this.pkgCache.put(str, sb.toString());
                return sb;
            }

            public Object transform(Object input) {
                String key = input.toString();
                int index = key.indexOf(46);
                if (index > 0) {
                    String desc = key.substring(index + 1);
                    String nName = (String)member.get(key);
                    if (nName == null) {
                        index = desc.indexOf(40);
                        nName = index > 0 ? desc.substring(0, index) : ((index = desc.indexOf(91)) > 0 ? desc.substring(0, index) : desc);
                    }
                    return nName;
                }
                return this.doClass(key).toString();
            }
        });
    }

    public Renamer withRemapper(Remapper remapper) {
        this.remapper = remapper;
        return this;
    }

    public Renamer withTransformer(Transformer tf) throws IOException {
        return this.withRemapper((Remapper)new SimpleRemapper(LazyMap.decorate(new HashMap(), (Transformer)tf)){

            public String mapFieldName(String owner, String name, String desc) {
                String s = this.map(String.valueOf(owner) + '.' + name + "[" + desc + "]");
                if (s == null || name.equals(s)) {
                    s = this.map(String.valueOf(owner) + '.' + name);
                }
                return s == null ? name : s;
            }

            public String mapMethodName(String owner, String name, String desc) {
                String s = this.map(String.valueOf(owner) + '.' + name + desc);
                if (s == null || name.equals(s)) {
                    s = this.map(String.valueOf(owner) + '.' + name + desc.substring(0, desc.indexOf(41) + 1));
                }
                return s == null ? name : s;
            }
        });
    }

    private static class E
    implements Comparable<E> {
        public String key;
        public String value;

        private E() {
        }

        @Override
        public int compareTo(E arg0) {
            int i = arg0.key.length() - this.key.length();
            return i == 0 ? arg0.key.compareTo(this.key) : i;
        }
    }
}

