package net.sf.colorer.eclipse.ftpp;

import net.sf.colorer.FileType;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * Content for particular file type preferences from HRC
 * @author Igor Russkih
 *
 */
class TypeParametersContentProvider implements  IStructuredContentProvider{

    public FileType type;
    IPreferenceStore preferenceStore;
    public final static String HRD_SIGNATURE = "@@HRD@@";

    /**
     * @param preferenceStore
     */
    public TypeParametersContentProvider(IPreferenceStore preferenceStore) {
        this.preferenceStore = preferenceStore;
    }

    public Object[] getElements(Object inputElement) {
        type = (FileType)inputElement;
        String[] preflist = type.getParameters();
        Object[] full_preflist = new Object[preflist.length+1];
        System.arraycopy(preflist, 0, full_preflist, 0, preflist.length);
        full_preflist[preflist.length] = HRD_SIGNATURE;
        return full_preflist;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        type = (FileType)newInput;
    }

    /**
     * Returns HRD scheme, assigned with this file type
     */
    public String getAssignedHRD() {
        String hrc = preferenceStore.getString(HRD_SIGNATURE+type.getName());
        if (hrc.equals("")) return null;
        else return hrc;
    }
}
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Colorer Library.
 *
 * The Initial Developer of the Original Code is
 * Igor Russkih <irusskih at gmail.com>.
 * Portions created by the Initial Developer are Copyright (C) 1999-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
