/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package junit.framework.test;

import java.lang.reflect.Method;
import junit.framework.TestCase;

/**
 * This class supports one of the tests from the TestCaseTest
 * class.
 *
 * @version $Id: AssertTestCase.java,v 1.3 2003/05/01 16:45:02 clemens Exp clemens $
 * @author  Chr. Clemens Lee
 */
public class AssertTestCase extends TestCase 
{
    /**
     * Test method that has to be invoked during one of the tests.
     */
    public void testExample() {
        assert( true );
    }

    /**
     * Default constructor.
     */
    public AssertTestCase() 
    {
        super();
    }

    /**
     * Default constructor expected by TestCase base class.
     */
    public AssertTestCase( String name ) 
    {
        super( name );
    }

    /**
     * This method is part of the ccl.util.Test class interface. If you are using regular
     * JUnit, this method will do nothing, but if in reality a ccl.util.Test class is
     * the true base class, we want to invoke the super method of this method.
     */
    protected void _enterSubTest( String name )
    {
        // if possible invoke super _enterSubTest method, if impossible, do nothing
        try
        {
            Class testCaseClass = AssertTestCase.class.getSuperclass();
            Method[] aMethod = testCaseClass.getDeclaredMethods();
            Method method = testCaseClass.getDeclaredMethod( "enterSubTest"
                                                             , new Class[] { String.class } );
            if ( method != null )
            {
                method.invoke( this, new Object[] { name } );
            }
        }
        catch( Exception exception )
        {
            // don't care what went wrong, just do nothing
        }
    }

    /**
     * This method is part of the ccl.util.Test class interface. If you are using regular
     * JUnit, this method will do nothing, but if in reality a ccl.util.Test class is
     * the true base class, we want to invoke the super method of this method.
     */
    protected void _exitSubTest()
    {
        // if possible invoke super _exitSubTest method, if impossible, do nothing
        try
        {
            Class testCaseClass = AssertTestCase.class.getSuperclass();
            Method method = testCaseClass.getDeclaredMethod( "exitSubTest"
                                                             , new Class[ 0 ] );
            if ( method != null )
            {
                method.invoke( this, new Object[ 0 ] );
            }
        }
        catch( Exception exception )
        {
            // don't care what went wrong, just do nothing
        }
    }

    /**
     * Redirects ccl.util.Test assertion to JUnit assertion.
     * 
     * @deprecated   don't use this anymore, use standard JUnit API.
     */
    public void assert( boolean condition, String message )
    {
        assertTrue( message, condition );
    }

    /**
     * Redirects ccl.util.Test assertion to JUnit assertion.
     * 
     * @deprecated   don't use this anymore, use standard JUnit API.
     */
    public void assert( boolean condition )
    {
        assertTrue( condition );
    }
}
