/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import javax.swing.DefaultFocusManager;
import javax.swing.JButton;

/**
 * For an example how to use this see OKCancelPanel.
 *
 * @author   Chr. Clemens Lee
 */
public class OKCancelFocusManager extends DefaultFocusManager 
{
    private JButton _btnOK = null;
    private JButton _btnCancel = null;
    private int mnemonicOK = '&';
    private int mnemonicCancel = '&';
    private int okUpperCase = '&';
    private int okLowerCase = '&';
    
    public OKCancelFocusManager( JButton btnOK_, JButton btnCancel_ ) 
{
        super();

        Util.debug( "OKCancelFocusManager.<init>(..).START" );
        _btnOK = btnOK_;
        _btnCancel = btnCancel_;
        mnemonicOK = _btnOK.getMnemonic();
        mnemonicCancel = _btnCancel.getMnemonic();
        String sOK = "" + (char)mnemonicOK;
        okUpperCase = sOK.toUpperCase().charAt(0);
        okLowerCase = sOK.toLowerCase().charAt(0);
        //mnemonicOK = okLowerCase;
        //mnemonicCancel = WebSUtil.toLowerCase( mnemonicCancel );
    }

    private boolean _bAlt = false;

    public void processKeyEvent( Component cmpFocused_,
                                 KeyEvent pKeyEvent_ ) 
    {
        if ( pKeyEvent_.getID() == KeyEvent.KEY_PRESSED &&
             pKeyEvent_.getKeyCode() == KeyEvent.VK_ENTER ) 
        {
            pKeyEvent_.consume();
            _btnOK.doClick();
        }

        // make sure alt-o does not get processed by text field or so.
        // text fields relies unfortunately not on pressed and released
        // messages and consumes just the KEY_TYPED events. That's why
        // a little more logic is needed to consume the right event.
        if ( pKeyEvent_.getKeyCode() == KeyEvent.VK_ALT ||
             pKeyEvent_.getKeyCode() == KeyEvent.VK_META ) 
        {
            _bAlt = !_bAlt;
        }
        if ( _bAlt && 
             pKeyEvent_.getKeyCode() == KeyEvent.VK_UNDEFINED &&
             ( (pKeyEvent_.getKeyChar() == okUpperCase ||
                pKeyEvent_.getKeyChar() == okLowerCase ) ||
               (pKeyEvent_.getKeyChar() == 
                Util.toLowerCase( mnemonicCancel ) ||
                pKeyEvent_.getKeyChar() == 
                Util.toUpperCase( mnemonicCancel )) ) )
        {
            pKeyEvent_.consume();
        }
        
        // Alt-OK
        if ( pKeyEvent_.getID() == KeyEvent.KEY_RELEASED &&
             (pKeyEvent_.getModifiers() & (InputEvent.ALT_MASK +
                                           InputEvent.META_MASK)) != 0 && 
             pKeyEvent_.getKeyCode() == mnemonicOK ) 
        {
            pKeyEvent_.consume();
            _btnOK.doClick();
        }
        // Alt-Cancel
        if ( pKeyEvent_.getID() == KeyEvent.KEY_RELEASED && 
             (pKeyEvent_.getModifiers() & (InputEvent.ALT_MASK +
                                           InputEvent.META_MASK)) != 0 && 
             pKeyEvent_.getKeyCode() == mnemonicCancel ) 
        {
            pKeyEvent_.consume();
            _btnCancel.doClick();
        }
        // ESC
        if ( pKeyEvent_.getKeyCode() == KeyEvent.VK_ESCAPE ) 
{
            pKeyEvent_.consume();
            _btnCancel.doClick();
        }
        
        super.processKeyEvent( cmpFocused_, pKeyEvent_ );
    }
}
