/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util; 
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.StringBuffer;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;

/**
 * A list that changes item color after item was selected.
 *
 * @version  $Id: HighlightedList.java,v 1.6 2002/10/06 16:41:36 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class HighlightedList extends JList 
{
    private Color _clrHighlight = Color.black;
    
    /**
     * IMPLEMENT-ME used for storing repeated key stroked by
     * user for scrolling in the browser,
     * NOTIMPLEMENTED NOW only works for one character at a
     * time [Paddy]
     */
    private StringBuffer _sbScroll2String = new StringBuffer ();

    /**
     * 10 seconds
     */
    private static final int MAX_TIME_TWEEN_KEYSTROKES = 10000;

    private void highlightSelectedValue() 
{
        Object oValue = getSelectedValue();
        if ( oValue != null &&
             oValue instanceof Highlightable )
        {                    
            ((Highlightable)oValue).setHighlightable( true );
        }
    }

    private void scrollToKeyPressed( StringBuffer sbKey_ ) 
{
        Util.debug( this, "scrollToKeyPressed(..).sbKey_: " +
                    sbKey_ );
        ListModel pListModel = getModel();
        for( int i=0; i < pListModel.getSize(); i++ ) 
{
            String sElement =  pListModel.getElementAt( i ).toString();
            String sLowerElement =  sElement.toLowerCase();
            Util.debug( this, "scrollToKeyPressed(..).sElement: " + sElement );
            if ( sLowerElement.startsWith( sbKey_.toString() ) ) 
{
                setSelectedValue( sElement, true );
                break;
            }
        }
    }

    private void _init() 
{
        setCellRenderer( new HighlightedListCellRenderer() );
        invalidate();
        addMouseListener( new MouseAdapter() {
            public void mouseReleased( MouseEvent pMouseEvent_ ) 
{
                HighlightedList.this.highlightSelectedValue();
            }
        } );
        
        addKeyListener( new KeyAdapter() {
            public void keyPressed( KeyEvent pKeyEvent_ ) 
{
                int keyCode = pKeyEvent_.getKeyCode();
                if ( keyCode == KeyEvent.VK_ENTER ) 
{
                    HighlightedList.this.highlightSelectedValue();
                }
            }
            
            public void keyTyped ( KeyEvent pKeyEvent_ ) 
{
                char c = pKeyEvent_.getKeyChar ();
                // FIX-ME for jdk1.16 with CAPS lock, shift
                // <any keys> gives uppercase that key in
                // this event, leaving it hoping to be fixed
                // in newer jdks should add buffering 
                // capability for multiple keystrokes [Paddy]
                _sbScroll2String.setLength( 0 ); // = new StringBuffer ();// no reset method available in 1.1
                _sbScroll2String.append ( c );
                scrollToKeyPressed ( _sbScroll2String );                
            }
        } );
    }

    public HighlightedList() 
{
        super();
        _init();
    }

    public HighlightedList( Vector vData_ ) 
{
        super( vData_ );
        _init();
    }

    public HighlightedList( ListModel lmData_ ) 
{
        super( lmData_ );
        _init();
    }

    public void setHighlight( Color clrHighlight_ ) 
{
        _clrHighlight = new Color( clrHighlight_.getRGB() );
    }

    public Color getHighlight() 
{
        return new Color( _clrHighlight.getRGB() );
    }

    /**
     * Selects the specified object from the list.
     *
     * @param anObject      the Object to select     
     * @param shouldScroll  true if the list should scroll to display
     *                      the selected object
     */
    public void setSelectedValue(Object anObject,boolean shouldScroll) 
{
        if(anObject == null)
            setSelectedIndex(-1);
        else if(!anObject.equals(getSelectedValue())) 
{
            int i,c;
            ListModel dm = getModel();
            for(i=0,c=dm.getSize();i<c;i++)
                if(dm.getElementAt(i).equals(anObject))
{
                    setSelectedIndex(i);
                    if(shouldScroll)
                        ensureIndexIsVisible(i);
                    repaint();  /** FIX-ME setSelectedIndex does not redraw all the time with the basic l&f**/
                    return;
                }
            setSelectedIndex(-1);
        }
        repaint(); /** FIX-ME setSelectedIndex does not redraw all the time with the basic l&f**/
    }
}
