/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.Exitable;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;

public class FTPUtil
implements Exitable {
    private static final String S_RCS_HEADER = "$Header: /home/clemens/src/java/ccl/src/ccl/util/RCS/FTPUtil.java,v 1.4 2002/10/06 16:42:03 clemens Exp clemens $";
    private static final String S_INI_FILE_CONTENT = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\nHelpUsage=\nOptions=get,put,host,user,password\nget=s,o,Get file from host in bin mode.\nput=s,o,Put file to host in bin mode.\nhost=s,m,The ftp server hostname.\nuser=s,o,The ftp user name. 'ftp' by default.\npassword=s,o,The ftp password for the user.\n";
    private boolean _bExit = false;

    private FTPUtil() {
    }

    public void setExit() {
        this._bExit = true;
    }

    public static void main(String[] args_) {
        String password;
        FTPUtil ftp = new FTPUtil();
        Init init = new Init(ftp, args_, S_RCS_HEADER, S_INI_FILE_CONTENT);
        if (ftp._bExit) {
            System.exit(0);
        }
        String host = (String)init.getOptions().get("host");
        String user = (String)init.getOptions().get("user");
        if (Util.isEmpty(user)) {
            user = "ftp";
        }
        if ((password = (String)init.getOptions().get("password")) == null) {
            password = "";
        }
        String hostfile = (String)init.getOptions().get("get");
        boolean bGet = true;
        if (Util.isEmpty(hostfile)) {
            bGet = false;
            hostfile = (String)init.getOptions().get("put");
        }
        if (Util.isEmpty(hostfile)) {
            Util.printlnErr("Error: no file was specified neither for 'get' or 'put' mode.");
            System.exit(1);
        }
        String localfile = new File(hostfile).getName();
        try {
            if (bGet) {
                FTPUtil.get(host, user, password, hostfile, localfile);
            } else {
                FTPUtil.put(host, user, password, localfile, hostfile);
            }
        }
        catch (IOException ioException) {
            Util.printlnErr(ioException);
            System.exit(1);
        }
        System.exit(0);
    }

    public static void get(String host, String user, String password, String hostfile, String localfile) throws IOException {
        if (FileUtil.exists(localfile)) {
            throw new IOException("Error: there exists already a file '" + localfile + "'");
        }
        FtpClient ftpClient = new FtpClient(host);
        ftpClient.login(user, password);
        ftpClient.binary();
        TelnetInputStream input = ftpClient.get(hostfile);
        int i = 0;
        FileOutputStream output = new FileOutputStream(localfile);
        while ((i = ((InputStream)input).read()) != -1) {
            output.write((byte)i);
        }
        ftpClient.closeServer();
        output.close();
    }

    public static void put(String host, String user, String password, String localfile, String hostfile) throws IOException {
        FtpClient ftpClient = new FtpClient(host);
        ftpClient.login(user, password);
        ftpClient.binary();
        TelnetOutputStream output = ftpClient.put(hostfile);
        FileInputStream input = new FileInputStream(localfile);
        int i = 0;
        while ((i = input.read()) != -1) {
            ((OutputStream)output).write((byte)i);
        }
        ((OutputStream)output).close();
        input.close();
        ftpClient.closeServer();
    }
}

