/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet.test;

import ccl.servlet.XMLImportHandler;
import ccl.util.ClassPathUtil;
import ccl.util.DBUtil;
import ccl.util.FileUtil;
import ccl.util.Test;
import ccl.util.Util;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class XMLImportHandlerTest
extends Test {
    public XMLImportHandlerTest() {
    }

    public XMLImportHandlerTest(Test pTest_) {
        super(pTest_);
    }

    protected void _doIt() throws Exception {
        Connection connection = null;
        try {
            connection = DBUtil.createPGConnection("template1");
        }
        catch (Exception exception) {
            Util.print(" No PostgreSQL database found, skipping corresponding tests! ");
            return;
        }
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("drop database ccltest");
        }
        catch (SQLException sqlException) {
            // empty catch block
        }
        statement.executeUpdate("create database ccltest with encoding = 'LATIN1'");
        statement.close();
        connection.close();
        connection = DBUtil.createPGConnection("ccltest");
        statement = connection.createStatement();
        this.Assert(true);
        String sCreateTablesFile = FileUtil.concatPath(ClassPathUtil.getApplicationHome(this), "test") + File.separator + "create_tables.sql";
        String sCreateTablesSQL = FileUtil.readFile(sCreateTablesFile);
        statement.executeUpdate(sCreateTablesSQL);
        this.Assert(true);
        ResultSet result = statement.executeQuery("select count(*) from tblTransaction");
        result.next();
        this.Assert(Util.atoi(result.getString(1)) == 0);
        result.close();
        statement.close();
        String sImportFile = FileUtil.concatPath(ClassPathUtil.getApplicationHome(this), "test") + File.separator + "xmlimport_test.xml";
        XMLImportHandler.parse(connection, sImportFile);
        statement = connection.createStatement();
        result = statement.executeQuery("select count(*) from tblTransaction");
        result.next();
        this.Assert(Util.atoi(result.getString(1)) == 3);
        result.close();
        statement.close();
        connection.close();
        connection = DBUtil.createPGConnection("ccltest");
        statement = connection.createStatement();
        sImportFile = FileUtil.concatPath(ClassPathUtil.getApplicationHome(this), "test") + File.separator + "xmlimport_test2.xml";
        XMLImportHandler.parse(connection, sImportFile);
        statement = connection.createStatement();
        result = statement.executeQuery("select count(*) from tblTransaction");
        result.next();
        this.Assert(Util.atoi(result.getString(1)) == 4);
        result.close();
        statement.executeUpdate("insert into Account ( id, name, description, currency_iso, type, parent, tax_percentage, tax_deductible ) values ( 3, 'Umla\u00fct', 'T\u00dc\u00fc\u00d6\u00f6\u00c4\u00e4\u00dft', 'EUR', 'Bank', null, 0.0, 0 )");
        result = statement.executeQuery("select name from Account where id = 3");
        result.next();
        String name = result.getString("name");
        this.Assert(name.equals("Umla\u00fct"), "Name should be 'Umla\u00fct' but is: '" + name + "'");
        result.close();
        result = statement.executeQuery("select name from Account where id = 2");
        result.next();
        name = result.getString("name");
        this.Assert(name.equals("Pse\u00fcdo DEM"), "Name should be 'Pse\u00fcdo DEM' but is: '" + name + "'");
        result.close();
        statement.close();
    }

    public static void main(String[] asArg_) {
        XMLImportHandlerTest pTest = new XMLImportHandlerTest();
        pTest.setVerbose(true);
        pTest.setTiming(true);
        pTest.run();
        Test.printResult(pTest);
        System.exit(0);
    }
}

