/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import groovy.lang.CompilerConfig;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.codehaus.groovy.GroovyException;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.classgen.ClassGenerator;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerTokenStream;
import org.codehaus.groovy.syntax.parser.ASTBuilder;
import org.codehaus.groovy.syntax.parser.CSTNode;
import org.codehaus.groovy.syntax.parser.Parser;
import org.codehaus.groovy.tools.CompilationFailuresException;
import org.codehaus.groovy.tools.CompilerBugException;
import org.codehaus.groovy.tools.CompilerClassLoader;
import org.codehaus.groovy.tools.ExceptionCollector;
import org.codehaus.groovy.tools.GroovyClass;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.DumpClassVisitor;

public class Compiler {
    private static final Exception[] EMPTY_EXCEPTION_ARRAY = new Exception[0];
    private Verifier verifier;
    private CompilerClassLoader classLoader;
    private CompilerConfig config = new CompilerConfig();
    private boolean verbose = false;
    private boolean debug = false;
    private int maximumParseFailuresPerFile = 10;
    private int maximumFailuresPerCompile = 15;

    public Compiler() {
        this.verifier = new Verifier();
        this.classLoader = new CompilerClassLoader();
    }

    protected CompilerClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setClasspath(String classpath) throws Exception {
        StringTokenizer paths = new StringTokenizer(classpath, File.pathSeparator);
        while (paths.hasMoreTokens()) {
            this.getClassLoader().addPath(paths.nextToken());
        }
    }

    public CompilerConfig getConfig() {
        return this.config;
    }

    public void setConfig(CompilerConfig config) {
        this.config = config;
    }

    public GroovyClass[] compile(CharStream source) throws CompilationFailuresException, CompilerBugException {
        return this.compile(new CharStream[]{source});
    }

    public GroovyClass[] compile(CharStream[] sources) throws CompilationFailuresException, CompilerBugException {
        CompilationFailuresException failures = new CompilationFailuresException();
        String[] descriptors = new String[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            descriptors[i] = sources[i].getDescription();
            if (descriptors[i] != null) continue;
            descriptors[i] = "unknown" + i;
        }
        CSTNode[] csts = new CSTNode[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            try {
                csts[i] = this.parseSource(sources[i], descriptors[i]);
                continue;
            }
            catch (ExceptionCollector e) {
                if (!e.isEmpty()) {
                    failures.add(descriptors[i], e);
                }
                if (failures.total() <= this.maximumFailuresPerCompile) continue;
                throw failures;
            }
            catch (Exception e) {
                throw new CompilerBugException(descriptors[i], "parse", e);
            }
            finally {
                try {
                    sources[i].close();
                }
                catch (Exception e) {}
            }
        }
        if (!failures.isEmpty()) {
            throw failures;
        }
        CompileUnit unit = new CompileUnit(this.getClassLoader(), this.config);
        ArrayList classes = new ArrayList();
        for (int i = 0; i < csts.length; ++i) {
            try {
                ModuleNode ast = this.buildAST(csts[i], descriptors[i]);
                unit.addModule(ast);
                continue;
            }
            catch (ExceptionCollector e) {
                if (e.isEmpty()) continue;
                failures.add(descriptors[i], e);
                continue;
            }
            catch (Exception e) {
                throw new CompilerBugException(descriptors[i], "AST creation", e);
            }
        }
        Iterator iter = unit.getModules().iterator();
        while (iter.hasNext()) {
            ModuleNode module = (ModuleNode)iter.next();
            try {
                Iterator classNodes = module.getClasses().iterator();
                while (classNodes.hasNext()) {
                    ClassNode classNode = (ClassNode)classNodes.next();
                    if (this.verbose) {
                        System.out.println("Generating class: " + classNode.getName());
                    }
                    classes.addAll(this.generateClasses(new GeneratorContext(unit), classNode, module.getDescription()));
                }
            }
            catch (ExceptionCollector e) {
                if (e.isEmpty()) continue;
                failures.add(module.getDescription(), e);
            }
            catch (Exception e) {
                throw new CompilerBugException(module.getDescription(), "class generation", e);
            }
        }
        if (!failures.isEmpty()) {
            throw failures;
        }
        return classes.toArray(GroovyClass.EMPTY_ARRAY);
    }

    protected CSTNode parseSource(CharStream charStream, String descriptor) throws ExceptionCollector, Exception {
        CSTNode tree = null;
        if (this.verbose) {
            System.out.println("Parsing: " + descriptor);
        }
        ExceptionCollector collector = new ExceptionCollector(this.maximumParseFailuresPerFile);
        try {
            Lexer lexer = new Lexer(charStream);
            Parser parser = new Parser(new LexerTokenStream(lexer), collector);
            collector.throwUnlessEmpty();
            tree = parser.compilationUnit();
        }
        catch (ExceptionCollector e) {
            collector.merge(e, false);
        }
        catch (GroovyException e) {
            collector.add(e, false);
        }
        collector.throwUnlessEmpty();
        return tree;
    }

    protected ModuleNode buildAST(CSTNode cst, String descriptor) throws Exception {
        ASTBuilder astBuilder = new ASTBuilder(this.getClassLoader());
        ModuleNode module = astBuilder.build(cst);
        module.setDescription(descriptor);
        return module;
    }

    protected ArrayList generateClasses(GeneratorContext context, ClassNode classNode, String descriptor) throws Exception {
        ArrayList<GroovyClass> results = new ArrayList<GroovyClass>();
        ClassGenerator classGenerator = null;
        this.verifier.visitClass(classNode);
        if (this.debug) {
            DumpClassVisitor dumpVisitor = new DumpClassVisitor(new PrintWriter(new OutputStreamWriter(System.out)));
            classGenerator = new ClassGenerator(context, (ClassVisitor)dumpVisitor, this.getClassLoader(), descriptor);
            classGenerator.visitClass(classNode);
        } else {
            ClassWriter classWriter = new ClassWriter(true);
            classGenerator = new ClassGenerator(context, (ClassVisitor)classWriter, this.getClassLoader(), descriptor);
            classGenerator.visitClass(classNode);
            byte[] bytes = classWriter.toByteArray();
            results.add(new GroovyClass(classNode.getName(), bytes));
        }
        LinkedList innerClasses = classGenerator.getInnerClasses();
        while (!innerClasses.isEmpty()) {
            results.addAll(this.generateClasses(context, (ClassNode)innerClasses.removeFirst(), descriptor));
        }
        return results;
    }
}

