/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.LDAPUrl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.controls.LDAPVirtualListResponse;
import netscape.ldap.util.DSMLWriter;
import netscape.ldap.util.GetOpt;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIFWriter;
import netscape.ldap.util.MimeBase64Encoder;

public class LDAPSearch
extends LDAPTool {
    private static final String DSML_INTRO = "<dsml:dsml xmlns:dsml=\"http://www.dsml.org/DSML\">";
    private static final String DSML_END = "</dsml:dsml>";
    private static final String DSML_RESULTS_INTRO = " <dsml:directory-entries>";
    private static final String DSML_RESULTS_END = " </dsml:directory-entries>";
    private static boolean m_attrsonly = false;
    private static int m_deref = 0;
    private static int m_scope = 2;
    private static int m_sizelimit = 0;
    private static int m_timelimit = 0;
    private static int verbose = 0;
    private static String[] m_attrs = null;
    private static String m_base = "o=ace industry,c=us";
    private static String m_filter = null;
    private static String m_sep = ":";
    private static Vector m_sort = new Vector();
    private static boolean m_sortOnServer = false;
    private static boolean m_tempFiles = false;
    private static int m_beforeCount = 0;
    private static int m_afterCount = 0;
    private static int m_index = 0;
    private static int m_count = 0;
    private static int m_vlvTokens = 0;
    private static String m_searchVal = null;
    private static boolean m_foldLine = true;
    private static final int MAX_LINE = 77;
    private static PrintWriter m_pw = new PrintWriter(System.out);
    private static MimeBase64Encoder m_encoder = new MimeBase64Encoder();
    private static boolean m_printDSML = false;

    public static void main(String[] stringArray) {
        LDAPSearch.extractParameters(stringArray);
        if (!m_justShow) {
            try {
                m_client = new LDAPConnection();
                m_client.connect(m_ldaphost, m_ldapport);
            }
            catch (Exception exception) {
                System.err.println("Error: client connection failed!");
                System.exit(0);
            }
            try {
                m_client.authenticate(m_version, m_binddn, m_passwd);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.exit(0);
            }
            LDAPSearch.dosearch();
            m_pw.flush();
            m_pw.close();
            try {
                m_client.disconnect();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        }
        System.exit(0);
    }

    private static void doUsage() {
        System.err.println("usage: LDAPSearch -b basedn [options] filter [attributes...]");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -v            run in verbose mode");
        System.err.println("  -n            show what would be done but don't actually do it");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -t            write values to files");
        System.err.println("  -A            retrieve attribute names only");
        System.err.println("  -F sep        print 'sep' instead of '=' between attribute names and values");
        System.err.println("  -S attr       sort the results by attribute 'attr'");
        System.err.println("  -s scope      one of base, one, or sub (search scope)");
        System.err.println("  -a deref      one of never, always, search, or find (alias dereferencing)");
        System.err.println("  -l timelimit  time limit (in seconds) for search");
        System.err.println("  -T            do not fold (wrap) long lines (default is to fold)");
        System.err.println("  -x            perform sorting on server");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -z sizelimit  size limit (in entries) for search");
        System.err.println("  -G before:after:index:count | before:after:value where 'before' and 'after' are the number of entries surrounding 'index'. 'count' is the content count, 'value' is the search value.");
        System.err.println("  -y proxy-DN   DN to use for access control");
        System.err.println("  -X            output DSML instead of LDIF");
    }

    protected static void extractParameters(String[] stringArray) {
        Object object;
        String string = "HATtxvnXa:b:F:l:s:S:z:G:";
        GetOpt getOpt = LDAPTool.extractParameters(string, stringArray);
        if (getOpt.hasOption('H')) {
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (getOpt.hasOption('A')) {
            m_attrsonly = true;
        }
        if (getOpt.hasOption('x')) {
            m_sortOnServer = true;
        }
        if (getOpt.hasOption('t')) {
            m_tempFiles = true;
        }
        if (getOpt.hasOption('F')) {
            m_sep = getOpt.getOptionParam('F');
        }
        if (getOpt.hasOption('a')) {
            object = getOpt.getOptionParam('a');
            if (((String)object).equalsIgnoreCase("never")) {
                m_deref = 0;
            } else if (((String)object).equalsIgnoreCase("search")) {
                m_deref = 1;
            } else if (((String)object).equalsIgnoreCase("find")) {
                m_deref = 2;
            } else if (((String)object).equalsIgnoreCase("always")) {
                m_deref = 3;
            } else {
                System.err.println("Error: alias deref option should be never, search, find, or always.");
            }
        }
        if (getOpt.hasOption('b')) {
            m_base = getOpt.getOptionParam('b');
        }
        if (getOpt.hasOption('S')) {
            m_sort.addElement(getOpt.getOptionParam('S'));
        }
        if (getOpt.hasOption('l')) {
            try {
                m_timelimit = Integer.parseInt(getOpt.getOptionParam('l'));
            }
            catch (NumberFormatException numberFormatException) {
                m_timelimit = 0;
            }
        }
        if (getOpt.hasOption('s')) {
            object = getOpt.getOptionParam('s');
            if (((String)object).equalsIgnoreCase("base")) {
                m_scope = 0;
            } else if (((String)object).equalsIgnoreCase("one")) {
                m_scope = 1;
            } else if (((String)object).equalsIgnoreCase("sub")) {
                m_scope = 2;
            } else {
                System.err.println("Error: scope should be base, one or sub.");
            }
        }
        if (getOpt.hasOption('z')) {
            try {
                m_sizelimit = Integer.parseInt(getOpt.getOptionParam('z'));
            }
            catch (NumberFormatException numberFormatException) {
                m_sizelimit = 0;
            }
        }
        if (getOpt.hasOption('T')) {
            m_foldLine = false;
        }
        if (getOpt.hasOption('X')) {
            m_printDSML = true;
        }
        LDAPSearch.parseVlv(getOpt);
        object = getOpt.getParameters().elements();
        Vector vector = new Vector();
        while (object.hasMoreElements()) {
            vector.addElement(object.nextElement());
        }
        int n = vector.size();
        if (n <= 0) {
            System.err.println("Error: must supply filter string!");
            LDAPSearch.doUsage();
            System.exit(0);
        }
        if (n == 1) {
            m_filter = (String)vector.elementAt(0);
            if (m_verbose) {
                System.err.println("filter pattern: " + m_filter);
            }
            m_attrs = null;
            if (m_verbose) {
                System.err.println("returning: ALL");
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
        if (n > 1) {
            m_filter = (String)vector.elementAt(0);
            if (m_verbose) {
                System.err.println("filter pattern: " + m_filter);
                System.err.print("returning:");
            }
            m_attrs = new String[n];
            for (int i = 1; i < n; ++i) {
                LDAPSearch.m_attrs[i - 1] = (String)vector.elementAt(i);
                if (!m_verbose) continue;
                System.err.print(" " + m_attrs[i - 1]);
            }
            if (m_verbose) {
                System.err.println();
                System.err.println("filter is: (" + m_filter + ")");
            }
        }
    }

    private static void parseVlv(GetOpt getOpt) {
        if (getOpt.hasOption('G')) {
            String string = getOpt.getOptionParam('G');
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            m_vlvTokens = stringTokenizer.countTokens();
            if (m_vlvTokens < 3) {
                LDAPSearch.doUsage();
                System.exit(0);
            }
            try {
                m_beforeCount = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                m_beforeCount = 0;
            }
            try {
                m_afterCount = Integer.parseInt((String)stringTokenizer.nextElement());
            }
            catch (NumberFormatException numberFormatException) {
                m_afterCount = 0;
            }
            if (m_vlvTokens == 3) {
                m_searchVal = (String)stringTokenizer.nextElement();
            } else if (m_vlvTokens > 3) {
                try {
                    m_index = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    m_index = 0;
                }
                try {
                    m_count = Integer.parseInt((String)stringTokenizer.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    m_count = 0;
                }
            }
        }
    }

    private static void dosearch() {
        String[] stringArray;
        Serializable serializable;
        Object[] objectArray = null;
        try {
            Object object;
            serializable = new Vector<Object>();
            stringArray = null;
            if (m_sortOnServer && m_sort.size() > 0) {
                object = new LDAPSortKey[m_sort.size()];
                for (int i = 0; i < ((LDAPSortKey[])object).length; ++i) {
                    object[i] = new LDAPSortKey((String)m_sort.elementAt(i));
                }
                stringArray = new LDAPSortControl((LDAPSortKey[])object, true);
                serializable.addElement(stringArray);
            }
            if (stringArray == null && m_vlvTokens >= 3) {
                System.err.println("Server-side sorting is required for virtual list option");
                LDAPSearch.doUsage();
                System.exit(0);
            }
            object = null;
            if (m_vlvTokens == 3) {
                object = new LDAPVirtualListControl(m_searchVal, m_beforeCount, m_afterCount);
            } else if (m_vlvTokens > 3) {
                object = new LDAPVirtualListControl(m_index, m_beforeCount, m_afterCount, m_count);
            }
            if (object != null) {
                serializable.addElement(object);
            }
            if (m_proxyControl != null) {
                serializable.addElement(m_proxyControl);
            }
            if (m_ordinary) {
                LDAPControl lDAPControl = new LDAPControl("2.16.840.1.113730.3.4.2", true, null);
                serializable.addElement(lDAPControl);
            }
            if (serializable.size() > 0) {
                objectArray = new LDAPControl[serializable.size()];
                serializable.copyInto(objectArray);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(0);
        }
        serializable = null;
        try {
            stringArray = m_client.getSearchConstraints();
            stringArray.setServerControls((LDAPControl[])objectArray);
            stringArray.setDereference(m_deref);
            stringArray.setMaxResults(m_sizelimit);
            stringArray.setServerTimeLimit(m_timelimit);
            stringArray.setReferrals(m_referrals);
            if (m_referrals) {
                LDAPSearch.setDefaultReferralCredentials((LDAPConstraints)stringArray);
            }
            stringArray.setHopLimit(m_hopLimit);
            serializable = m_client.search(m_base, m_scope, m_filter, m_attrs, m_attrsonly, (LDAPSearchConstraints)stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        if (m_sort.size() > 0 && !m_sortOnServer) {
            stringArray = new String[m_sort.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)m_sort.elementAt(i);
            }
            ((LDAPSearchResults)serializable).sort(new LDAPCompareAttrNames(stringArray));
        }
        LDAPSearch.printResults(serializable);
        LDAPSearch.showControls(m_client.getResponseControls());
    }

    private static void printResults(LDAPSearchResults lDAPSearchResults) {
        LDAPWriter lDAPWriter;
        boolean bl = false;
        boolean bl2 = false;
        if (m_printDSML) {
            LDAPSearch.printString(DSML_INTRO);
            lDAPWriter = new DSMLWriter(m_pw);
        } else {
            lDAPWriter = new LDIFWriter(m_pw, m_attrsonly, m_sep, m_foldLine, m_tempFiles);
        }
        try {
            while (lDAPSearchResults.hasMoreElements()) {
                LDAPEntry lDAPEntry = null;
                try {
                    lDAPEntry = lDAPSearchResults.next();
                }
                catch (LDAPReferralException lDAPReferralException) {
                    LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
                    System.err.println("Referral entries: ");
                    for (int i = 0; i < lDAPUrlArray.length; ++i) {
                        System.err.println("\t" + lDAPUrlArray[i].getUrl().toString());
                    }
                    continue;
                }
                catch (Exception exception) {
                    m_pw.flush();
                    System.err.println(exception.toString());
                    continue;
                }
                if (LDAPSearch.isSchemaEntry(lDAPEntry)) {
                    lDAPWriter.printSchema(lDAPEntry);
                    continue;
                }
                if (m_printDSML && !bl2) {
                    LDAPSearch.printString(DSML_RESULTS_INTRO);
                    bl2 = true;
                }
                lDAPWriter.printEntry(lDAPEntry);
            }
        }
        catch (Exception exception) {
            m_pw.flush();
            System.err.println(exception.toString());
            System.exit(0);
        }
        if (m_printDSML) {
            if (bl2) {
                LDAPSearch.printString(DSML_RESULTS_END);
            }
            LDAPSearch.printString(DSML_END);
        }
    }

    protected static void printString(String string) {
        m_pw.print(string);
        m_pw.print('\n');
    }

    protected static boolean isSchemaEntry(LDAPEntry lDAPEntry) {
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclass");
        if (lDAPAttribute != null) {
            String[] stringArray = lDAPAttribute.getStringValueArray();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("subschema")) continue;
                return true;
            }
        }
        return false;
    }

    private static void showControls(LDAPControl[] lDAPControlArray) {
        int n;
        if (lDAPControlArray == null) {
            return;
        }
        LDAPSortControl lDAPSortControl = null;
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        for (n = 0; n < lDAPControlArray.length; ++n) {
            if (lDAPControlArray[n] instanceof LDAPSortControl) {
                lDAPSortControl = (LDAPSortControl)lDAPControlArray[n];
                continue;
            }
            if (!(lDAPControlArray[n] instanceof LDAPVirtualListResponse)) continue;
            lDAPVirtualListResponse = (LDAPVirtualListResponse)lDAPControlArray[n];
        }
        if (lDAPSortControl != null) {
            String string = lDAPSortControl.getFailedAttribute();
            int n2 = lDAPSortControl.getResultCode();
            if (n2 != 0) {
                System.err.println("Error code: " + n2);
                if (string != null) {
                    System.err.println("Offending attribute: " + string);
                } else {
                    System.err.println("No offending attribute returned");
                }
            } else {
                m_pw.println("Server indicated results sorted OK");
            }
        }
        if (lDAPVirtualListResponse != null) {
            n = lDAPVirtualListResponse.getResultCode();
            if (n == 0) {
                m_pw.println("Server indicated virtual list positioning OK");
                m_pw.println("index " + lDAPVirtualListResponse.getFirstPosition() + " content count " + lDAPVirtualListResponse.getContentCount());
            } else {
                System.err.println("Virtual List Error: " + LDAPException.errorCodeToString(n));
            }
        }
    }
}

