/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class Base64 {
    private static final char[] ALPHABET_TABLE2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final byte[] translateTable = "BBBBBBBBBBAABBABBBBBBBBBBBBBBBBBABBBBBBBBBB>BBB?456789:;<=BBB@BBB\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019BBBBBB\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123".getBytes();

    private Base64() {
    }

    public static String encode(byte[] data) throws IOException {
        StringWriter writer = new StringWriter();
        int charCount = 0;
        int dLimit = data.length / 3 * 3;
        for (int dIndex = 0; dIndex != dLimit; dIndex += 3) {
            int d = (data[dIndex] & 0xFF) << 16 | (data[dIndex + 1] & 0xFF) << 8 | data[dIndex + 2] & 0xFF;
            ((Writer)writer).write(ALPHABET_TABLE2[d >> 18]);
            ((Writer)writer).write(ALPHABET_TABLE2[d >> 12 & 0x3F]);
            ((Writer)writer).write(ALPHABET_TABLE2[d >> 6 & 0x3F]);
            ((Writer)writer).write(ALPHABET_TABLE2[d & 0x3F]);
            if (++charCount != 18) continue;
            ((Writer)writer).write(10);
            charCount = 0;
        }
        if (dLimit != data.length) {
            int d = (data[dLimit] & 0xFF) << 16;
            if (dLimit + 1 != data.length) {
                d |= (data[dLimit + 1] & 0xFF) << 8;
            }
            ((Writer)writer).write(ALPHABET_TABLE2[d >> 18]);
            ((Writer)writer).write(ALPHABET_TABLE2[d >> 12 & 0x3F]);
            ((Writer)writer).write(dLimit + 1 < data.length ? ALPHABET_TABLE2[d >> 6 & 0x3F] : 61);
            ((Writer)writer).write(61);
        }
        return ((Object)writer).toString();
    }

    public static byte[] decode(String value) {
        int byteShift = 4;
        int tmp = 0;
        boolean done = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i != value.length(); ++i) {
            int sixBit;
            char c = value.charAt(i);
            int n = sixBit = c < '{' ? translateTable[c] : 66;
            if (sixBit < 64) {
                if (done) {
                    throw new RuntimeException("= character not at end of base64 value");
                }
                tmp = tmp << 6 | sixBit;
                if (byteShift-- != 4) {
                    buffer.append((char)(tmp >> byteShift * 2 & 0xFF));
                }
            } else if (sixBit == 64) {
                --byteShift;
                done = true;
            } else if (sixBit == 66) {
                throw new RuntimeException("bad character in base64 value");
            }
            if (byteShift != 0) continue;
            byteShift = 4;
        }
        try {
            return buffer.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Base 64 decode produced byte values > 255");
        }
    }
}

