/*
 * Decompiled with CFR 0.152.
 */
package scalax.io;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import resource.package$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcJ$sp;
import scala.util.Either;
import scala.util.control.Exception$;
import scalax.io.CloseAction$Noop$;
import scalax.io.DefaultResourceContext$;
import scalax.io.KnownName;
import scalax.io.OpenOption;
import scalax.io.PrefixedName;
import scalax.io.ResourceContext;
import scalax.io.ResourceDescName;
import scalax.io.SeekableByteChannel;
import scalax.io.StandardOpenOption$;
import scalax.io.managed.ByteChannelResource;
import scalax.io.managed.ByteChannelResource$;
import scalax.io.managed.InputStreamResource;
import scalax.io.managed.InputStreamResource$;
import scalax.io.managed.OutputStreamResource;
import scalax.io.managed.OutputStreamResource$;
import scalax.io.managed.ReadableByteChannelResource;
import scalax.io.managed.ReadableByteChannelResource$;
import scalax.io.managed.ReaderResource;
import scalax.io.managed.ReaderResource$;
import scalax.io.managed.SeekableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource;
import scalax.io.managed.WritableByteChannelResource$;
import scalax.io.managed.WriterResource;
import scalax.io.managed.WriterResource$;
import scalax.io.nio.SeekableFileChannel;
import scalax.io.support.FileUtils$;

public final class Resource$ {
    public static Resource$ MODULE$;

    static {
        new Resource$();
    }

    public <A extends InputStream> InputStreamResource<A> fromInputStream(Function0<A> opener) {
        return new InputStreamResource<Object>(opener, InputStreamResource$.MODULE$.$lessinit$greater$default$2(), InputStreamResource$.MODULE$.$lessinit$greater$default$3(), InputStreamResource$.MODULE$.$lessinit$greater$default$4());
    }

    public <A extends OutputStream> OutputStreamResource<A> fromOutputStream(Function0<A> opener) {
        return new OutputStreamResource<Object>(opener, OutputStreamResource$.MODULE$.$lessinit$greater$default$2(), OutputStreamResource$.MODULE$.$lessinit$greater$default$3());
    }

    public <A extends Reader> ReaderResource<A> fromReader(Function0<A> opener) {
        return new ReaderResource<Object>(opener, ReaderResource$.MODULE$.$lessinit$greater$default$2(), ReaderResource$.MODULE$.$lessinit$greater$default$3());
    }

    public <A extends Writer> WriterResource<A> fromWriter(Function0<A> opener) {
        return new WriterResource<Object>(opener, WriterResource$.MODULE$.$lessinit$greater$default$2(), WriterResource$.MODULE$.$lessinit$greater$default$3());
    }

    public <A extends ReadableByteChannel> ReadableByteChannelResource<A> fromReadableByteChannel(Function0<A> opener) {
        return new ReadableByteChannelResource<Object>(opener, ReadableByteChannelResource$.MODULE$.$lessinit$greater$default$2(), ReadableByteChannelResource$.MODULE$.$lessinit$greater$default$3(), ReadableByteChannelResource$.MODULE$.$lessinit$greater$default$4());
    }

    public <A extends WritableByteChannel> WritableByteChannelResource<A> fromWritableByteChannel(Function0<A> opener) {
        return new WritableByteChannelResource<Object>(opener, WritableByteChannelResource$.MODULE$.$lessinit$greater$default$2(), WritableByteChannelResource$.MODULE$.$lessinit$greater$default$3());
    }

    public <A extends ByteChannel> ByteChannelResource<A> fromByteChannel(Function0<A> opener) {
        return new ByteChannelResource<Object>(opener, ByteChannelResource$.MODULE$.$lessinit$greater$default$2(), ByteChannelResource$.MODULE$.$lessinit$greater$default$3(), ByteChannelResource$.MODULE$.$lessinit$greater$default$4());
    }

    public <A extends SeekableByteChannel> SeekableByteChannelResource<A> fromSeekableByteChannel(Function0<A> opener) {
        return new SeekableByteChannelResource<Object>((Function1<Seq, SeekableByteChannel> & java.io.Serializable & Serializable)x$3 -> (SeekableByteChannel)opener.apply(), DefaultResourceContext$.MODULE$, CloseAction$Noop$.MODULE$, this.seekablesizeFunction(opener), None$.MODULE$);
    }

    public <A extends SeekableByteChannel> SeekableByteChannelResource<A> fromSeekableByteChannel(Function1<Seq<OpenOption>, A> opener) {
        return new SeekableByteChannelResource<Object>(opener, DefaultResourceContext$.MODULE$, CloseAction$Noop$.MODULE$, this.seekablesizeFunction((Function0<SeekableByteChannel> & java.io.Serializable & Serializable)() -> {
            Enumeration.Val val = StandardOpenOption$.MODULE$.Read();
            return (SeekableByteChannel)opener.apply(Nil$.MODULE$.$colon$colon(val));
        }), None$.MODULE$);
    }

    private Function0<Option<Object>> seekablesizeFunction(Function0<SeekableByteChannel> resource) {
        return (Function0<Option> & java.io.Serializable & Serializable)() -> {
            SeekableByteChannel r = (SeekableByteChannel)resource.apply();
            return Exception$.MODULE$.allCatch().opt((JFunction0$mcJ$sp & Serializable)() -> {
                long l;
                try {
                    l = r.size();
                }
                finally {
                    r.close();
                }
                return l;
            });
        };
    }

    public SeekableByteChannelResource<SeekableFileChannel> fromRandomAccessFile(Function0<RandomAccessFile> opener) {
        return new SeekableByteChannelResource<Object>(Resource$.open$1(opener), new ResourceContext(){

            public Throwable openErrorHandler(Throwable openException) {
                return ResourceContext.openErrorHandler$(this, openException);
            }

            public <U> U errorHandler(Either<Throwable, U> accessResult, List<Throwable> closingExceptions) {
                return (U)ResourceContext.errorHandler$(this, accessResult, closingExceptions);
            }

            public int byteBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.byteBufferSize$(this, dataSize, readOnly);
            }

            public int charBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.charBufferSize$(this, dataSize, readOnly);
            }

            public ByteBuffer createNioBuffer(int bufferSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, bufferSize, channel, readOnly);
            }

            public final ByteBuffer createNioBuffer(Option<Object> dataSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, dataSize, channel, readOnly);
            }

            public <U> ResourceContext copy(Option<Function2<Option<Object>, Object, Object>> newByteBufferSize, Option<Function2<Option<Object>, Object, Object>> newCharBufferSize, Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> newCreateNioBuffer, Option<Function1<Throwable, Throwable>> newOpenErrorHandler, Option<Function2<Either<Throwable, U>, List<Throwable>, U>> newErrorHandler, Option<ResourceDescName> newDescName) {
                return ResourceContext.copy$(this, newByteBufferSize, newCharBufferSize, newCreateNioBuffer, newOpenErrorHandler, newErrorHandler, newDescName);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$1() {
                return ResourceContext.copy$default$1$(this);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$2() {
                return ResourceContext.copy$default$2$(this);
            }

            public <U> Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> copy$default$3() {
                return ResourceContext.copy$default$3$(this);
            }

            public <U> Option<Function1<Throwable, Throwable>> copy$default$4() {
                return ResourceContext.copy$default$4$(this);
            }

            public <U> None$ copy$default$5() {
                return ResourceContext.copy$default$5$(this);
            }

            public <U> Option<ResourceDescName> copy$default$6() {
                return ResourceContext.copy$default$6$(this);
            }

            public PrefixedName descName() {
                return new PrefixedName("RandomAccessFile");
            }
            {
                ResourceContext.$init$(this);
            }
        }, CloseAction$Noop$.MODULE$, Resource$.sizeFunc$1(opener), new Some<Seq<OpenOption>>(StandardOpenOption$.MODULE$.ReadWrite()));
    }

    public InputStreamResource<InputStream> fromURL(URL url) {
        Function0<Option> & java.io.Serializable & Serializable sizeFunc = (Function0<Option> & java.io.Serializable & Serializable)() -> Exception$.MODULE$.allCatch().opt((JFunction0$mcJ$sp & Serializable)() -> {
            long l;
            URLConnection conn = url.openConnection();
            try {
                conn.connect();
                int n = conn.getContentLength();
                if (n <= -1) {
                    throw new MatchError(BoxesRunTime.boxToInteger(n));
                }
                long l2 = n;
                l = l2;
            }
            finally {
                conn.getInputStream().close();
            }
            return l;
        });
        return new InputStreamResource<Object>((Function0<InputStream> & java.io.Serializable & Serializable)() -> url.openStream(), new ResourceContext(url){
            private final URL url$1;

            public Throwable openErrorHandler(Throwable openException) {
                return ResourceContext.openErrorHandler$(this, openException);
            }

            public <U> U errorHandler(Either<Throwable, U> accessResult, List<Throwable> closingExceptions) {
                return (U)ResourceContext.errorHandler$(this, accessResult, closingExceptions);
            }

            public int byteBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.byteBufferSize$(this, dataSize, readOnly);
            }

            public int charBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.charBufferSize$(this, dataSize, readOnly);
            }

            public ByteBuffer createNioBuffer(int bufferSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, bufferSize, channel, readOnly);
            }

            public final ByteBuffer createNioBuffer(Option<Object> dataSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, dataSize, channel, readOnly);
            }

            public <U> ResourceContext copy(Option<Function2<Option<Object>, Object, Object>> newByteBufferSize, Option<Function2<Option<Object>, Object, Object>> newCharBufferSize, Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> newCreateNioBuffer, Option<Function1<Throwable, Throwable>> newOpenErrorHandler, Option<Function2<Either<Throwable, U>, List<Throwable>, U>> newErrorHandler, Option<ResourceDescName> newDescName) {
                return ResourceContext.copy$(this, newByteBufferSize, newCharBufferSize, newCreateNioBuffer, newOpenErrorHandler, newErrorHandler, newDescName);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$1() {
                return ResourceContext.copy$default$1$(this);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$2() {
                return ResourceContext.copy$default$2$(this);
            }

            public <U> Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> copy$default$3() {
                return ResourceContext.copy$default$3$(this);
            }

            public <U> Option<Function1<Throwable, Throwable>> copy$default$4() {
                return ResourceContext.copy$default$4$(this);
            }

            public <U> None$ copy$default$5() {
                return ResourceContext.copy$default$5$(this);
            }

            public <U> Option<ResourceDescName> copy$default$6() {
                return ResourceContext.copy$default$6$(this);
            }

            public KnownName descName() {
                return new KnownName(this.url$1.toExternalForm());
            }
            {
                this.url$1 = url$1;
                ResourceContext.$init$(this);
            }
        }, CloseAction$Noop$.MODULE$, (Function0<Option<Object>>)sizeFunc);
    }

    public InputStreamResource<InputStream> fromURL(String url) {
        return this.fromURL(new URL(url));
    }

    public SeekableByteChannelResource<SeekableByteChannel> fromFile(File file) {
        return new SeekableByteChannelResource<Object>(Resource$.open$2(file), new ResourceContext(file){
            private final File file$1;

            public Throwable openErrorHandler(Throwable openException) {
                return ResourceContext.openErrorHandler$(this, openException);
            }

            public <U> U errorHandler(Either<Throwable, U> accessResult, List<Throwable> closingExceptions) {
                return (U)ResourceContext.errorHandler$(this, accessResult, closingExceptions);
            }

            public int byteBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.byteBufferSize$(this, dataSize, readOnly);
            }

            public int charBufferSize(Option<Object> dataSize, boolean readOnly) {
                return ResourceContext.charBufferSize$(this, dataSize, readOnly);
            }

            public ByteBuffer createNioBuffer(int bufferSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, bufferSize, channel, readOnly);
            }

            public final ByteBuffer createNioBuffer(Option<Object> dataSize, Option<Channel> channel, boolean readOnly) {
                return ResourceContext.createNioBuffer$((ResourceContext)this, dataSize, channel, readOnly);
            }

            public <U> ResourceContext copy(Option<Function2<Option<Object>, Object, Object>> newByteBufferSize, Option<Function2<Option<Object>, Object, Object>> newCharBufferSize, Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> newCreateNioBuffer, Option<Function1<Throwable, Throwable>> newOpenErrorHandler, Option<Function2<Either<Throwable, U>, List<Throwable>, U>> newErrorHandler, Option<ResourceDescName> newDescName) {
                return ResourceContext.copy$(this, newByteBufferSize, newCharBufferSize, newCreateNioBuffer, newOpenErrorHandler, newErrorHandler, newDescName);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$1() {
                return ResourceContext.copy$default$1$(this);
            }

            public <U> Option<Function2<Option<Object>, Object, Object>> copy$default$2() {
                return ResourceContext.copy$default$2$(this);
            }

            public <U> Option<Function3<Object, Option<Channel>, Object, ByteBuffer>> copy$default$3() {
                return ResourceContext.copy$default$3$(this);
            }

            public <U> Option<Function1<Throwable, Throwable>> copy$default$4() {
                return ResourceContext.copy$default$4$(this);
            }

            public <U> None$ copy$default$5() {
                return ResourceContext.copy$default$5$(this);
            }

            public <U> Option<ResourceDescName> copy$default$6() {
                return ResourceContext.copy$default$6$(this);
            }

            public KnownName descName() {
                return new KnownName(this.file$1.getPath());
            }
            {
                this.file$1 = file$1;
                ResourceContext.$init$(this);
            }
        }, CloseAction$Noop$.MODULE$, Resource$.sizeFunc$2(file), None$.MODULE$);
    }

    public SeekableByteChannelResource<SeekableByteChannel> fromFile(String file) {
        return this.fromFile(new File(file));
    }

    public InputStreamResource<InputStream> fromClasspath(String name, Class<?> cl) {
        URL url = cl.getClassLoader().getResource(name);
        Predef$.MODULE$.require(url != null);
        return this.fromURL(url);
    }

    public InputStreamResource<InputStream> fromClasspath(String name) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        Predef$.MODULE$.require(url != null);
        return this.fromURL(url);
    }

    private static final Function1 open$1(Function0 opener$1) {
        return (Function1<Seq, SeekableFileChannel> & java.io.Serializable & Serializable)opts -> FileUtils$.MODULE$.openChannel((RandomAccessFile)opener$1.apply(), (Seq<OpenOption>)opts);
    }

    public static final /* synthetic */ long $anonfun$fromRandomAccessFile$4(RandomAccessFile x$5) {
        long l = x$5.length();
        if (l <= -1L) {
            throw new MatchError(BoxesRunTime.boxToLong(l));
        }
        long l2 = l;
        return l2;
    }

    private static final Function0 sizeFunc$1(Function0 opener$1) {
        return (Function0<Option> & java.io.Serializable & Serializable)() -> Exception$.MODULE$.allCatch().opt((JFunction0$mcJ$sp & Serializable)() -> BoxesRunTime.unboxToLong(package$.MODULE$.managed(opener$1, resource.Resource$.MODULE$.closeableResource(), ClassManifestFactory$.MODULE$.classType(RandomAccessFile.class)).acquireAndGet((Function1<RandomAccessFile, Object> & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToLong(Resource$.$anonfun$fromRandomAccessFile$4(x$5)))));
    }

    private static final Function1 open$2(File file$1) {
        return (Function1<Seq, SeekableFileChannel> & java.io.Serializable & Serializable)opts -> FileUtils$.MODULE$.openChannel(file$1, (Seq<OpenOption>)opts);
    }

    private static final Function0 sizeFunc$2(File file$1) {
        return (Function0<Option> & java.io.Serializable & Serializable)() -> Exception$.MODULE$.allCatch().opt((JFunction0$mcJ$sp & Serializable)() -> file$1.length());
    }

    private Resource$() {
        MODULE$ = this;
    }
}

