/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Subject;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TableSubject
extends Subject {
    private final Table<?, ?, ?> actual;

    TableSubject(FailureMetadata metadata, @Nullable Table<?, ?, ?> table) {
        super(metadata, table);
        this.actual = table;
    }

    public void isEmpty() {
        if (!this.actual.isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (this.actual.isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public final void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize(%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(this.actual.size()).isEqualTo(expectedSize);
    }

    public void contains(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (!this.actual.contains(rowKey, columnKey)) {
            this.fail("contains mapping for row/column", rowKey, columnKey);
        }
    }

    public void doesNotContain(@Nullable Object rowKey, @Nullable Object columnKey) {
        if (this.actual.contains(rowKey, columnKey)) {
            this.fail("does not contain mapping for row/column", rowKey, columnKey);
        }
    }

    public void containsCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        this.containsCell(Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value));
    }

    public void containsCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        this.checkNoNeedToDisplayBothValues("cellSet()", new Object[0]).that(this.actual.cellSet()).contains(cell);
    }

    public void doesNotContainCell(@Nullable Object rowKey, @Nullable Object colKey, @Nullable Object value) {
        this.doesNotContainCell(Tables.immutableCell((Object)rowKey, (Object)colKey, (Object)value));
    }

    public void doesNotContainCell(Table.Cell<?, ?, ?> cell) {
        Preconditions.checkNotNull(cell);
        this.checkNoNeedToDisplayBothValues("cellSet()", new Object[0]).that(this.actual.cellSet()).doesNotContain(cell);
    }

    public void containsRow(@Nullable Object rowKey) {
        this.check("rowKeySet()", new Object[0]).that(this.actual.rowKeySet()).contains(rowKey);
    }

    public void containsColumn(@Nullable Object columnKey) {
        this.check("columnKeySet()", new Object[0]).that(this.actual.columnKeySet()).contains(columnKey);
    }

    public void containsValue(@Nullable Object value) {
        this.check("values()", new Object[0]).that(this.actual.values()).contains(value);
    }
}

