/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

@BugPattern(summary="contains() is a legacy method that is equivalent to containsValue()", severity=BugPattern.SeverityLevel.ERROR)
public class HashtableContains
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    static final Matcher<ExpressionTree> CONTAINS_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(Hashtable.class.getName()).named("contains"), MethodMatchers.instanceMethod().onDescendantOf(ConcurrentHashMap.class.getName()).named("contains")});

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CONTAINS_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder result = this.buildDescription(tree);
        List<Type> tyargs = ASTHelpers.getReceiverType((ExpressionTree)tree).getTypeArguments();
        if (tyargs.size() == 2) {
            Types types = state.getTypes();
            Type key = ASTHelpers.getUpperBound((Type)((Type)tyargs.get(0)), (Types)types);
            Type value = ASTHelpers.getUpperBound((Type)((Type)tyargs.get(1)), (Types)types);
            Type arg = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())));
            boolean valueShaped = types.isAssignable(arg, value);
            boolean keyShaped = types.isAssignable(arg, key);
            if (keyShaped && !valueShaped) {
                result.addFix(HashtableContains.replaceMethodName(tree, state, "containsKey"));
                result.setMessage(String.format("contains() is a legacy method that is equivalent to containsValue(), but the argument type '%s' looks like a key", key));
                return result.build();
            } else if (valueShaped && !keyShaped) {
                result.addFix(HashtableContains.replaceMethodName(tree, state, "containsValue"));
                return result.build();
            } else {
                if (!valueShaped || !keyShaped) throw new AssertionError((Object)String.format("unexpected argument to contains(): key: %s, value: %s, argument: %s", key, value, arg));
                result.addFix(HashtableContains.replaceMethodName(tree, state, "containsValue"));
                result.addFix(HashtableContains.replaceMethodName(tree, state, "containsKey"));
                result.setMessage(String.format("contains() is a legacy method that is equivalent to containsValue(), but the argument type '%s' could be a key or a value", key));
            }
            return result.build();
        } else {
            result.addFix(HashtableContains.replaceMethodName(tree, state, "containsValue"));
        }
        return result.build();
    }

    private static Fix replaceMethodName(MethodInvocationTree tree, VisitorState state, String newName) {
        String source = state.getSourceForNode((Tree)tree.getMethodSelect());
        int idx = source.lastIndexOf("contains");
        String replacement = source.substring(0, idx) + newName + source.substring(idx + "contains".length());
        SuggestedFix fix = SuggestedFix.replace((Tree)tree.getMethodSelect(), (String)replacement);
        return fix;
    }
}

