/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.installer;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.installer.PackageInstaller;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class BasicInstaller
implements PackageInstaller {
    @Override
    public boolean uninstall(LocalPackage p, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        String path = p.getPath();
        path = path.replace(';', File.separatorChar);
        File location = new File(manager.getLocalPath(), path);
        fop.deleteFileOrFolder(location);
        manager.markInvalid();
        return !fop.exists(location);
    }

    @Override
    public boolean install(RemotePackage p, Downloader downloader, SettingsController settings, ProgressIndicator progress, RepoManager manager, FileOp fop) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl(p, progress);
        if (url == null) {
            return false;
        }
        try {
            String path = p.getPath();
            path = path.replace(';', File.separatorChar);
            File dest = new File(manager.getLocalPath(), path);
            if (!InstallerUtil.checkValidPath(dest, manager, progress)) {
                return false;
            }
            File in = downloader.downloadFully(url, settings, progress);
            File out = FileOpUtils.getNewTempDir("BasicInstaller", fop);
            if (out == null || !fop.mkdirs(out)) {
                throw new IOException("Failed to create temp dir");
            }
            fop.deleteOnExit(out);
            progress.logInfo(String.format("Installing %1$s in %2$s", p.getDisplayName(), dest));
            InstallerUtil.unzip(in, out, fop, p.getArchive().getComplete().getSize(), progress);
            fop.delete(in);
            File[] topDirContents = fop.listFiles(out);
            File packageRoot = topDirContents.length != 1 ? out : topDirContents[0];
            InstallerUtil.writePackageXml(p, packageRoot, manager, fop, progress);
            FileOpUtils.safeRecursiveOverwrite(packageRoot, dest, fop, progress);
            manager.markInvalid();
            return true;
        }
        catch (IOException e) {
            String message = e.getMessage();
            progress.logWarning("An error occurred during installation" + (message.isEmpty() ? "." : ": " + message + "."), e);
            return false;
        }
    }
}

