/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth.extensions.proto;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.truth.extensions.proto.AutoValue_FieldScopeImpl;
import com.google.common.truth.extensions.proto.FieldScope;
import com.google.common.truth.extensions.proto.FieldScopeLogic;
import com.google.common.truth.extensions.proto.FieldScopeUtil;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;

@AutoValue
abstract class FieldScopeImpl
extends FieldScope {
    private static final FieldScope ALL = FieldScopeImpl.create(FieldScopeLogic.all(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"FieldScopes.all()"));
    private static final FieldScope NONE = FieldScopeImpl.create(FieldScopeLogic.none(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)"FieldScopes.none()"));

    FieldScopeImpl() {
    }

    private static FieldScope create(FieldScopeLogic logic, Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction) {
        return new AutoValue_FieldScopeImpl(logic, usingCorrespondenceStringFunction);
    }

    @Override
    abstract FieldScopeLogic logic();

    abstract Function<? super Optional<Descriptors.Descriptor>, String> usingCorrespondenceStringFunction();

    static FieldScope createFromSetFields(Message message) {
        return FieldScopeImpl.create(FieldScopeLogic.partialScope(message), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format("FieldScopes.fromSetFields({%s})", message.toString())));
    }

    static FieldScope createFromSetFields(Iterable<? extends Message> messages) {
        if (FieldScopeImpl.emptyOrAllNull(messages)) {
            return FieldScopeImpl.create(FieldScopeLogic.none(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format("FieldScopes.fromSetFields(%s)", messages.toString())));
        }
        Optional<Descriptors.Descriptor> optDescriptor = FieldScopeUtil.getSingleDescriptor(messages);
        Preconditions.checkArgument((boolean)optDescriptor.isPresent(), (String)"Cannot create scope from messages with different descriptors: %s", FieldScopeImpl.getDescriptors(messages));
        Message.Builder builder = null;
        for (Message message : messages) {
            if (message == null) continue;
            if (builder != null) {
                builder.mergeFrom(message);
                continue;
            }
            builder = message.toBuilder();
        }
        Message aggregateMessage = builder.build();
        return FieldScopeImpl.create(FieldScopeLogic.partialScope(aggregateMessage), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format("FieldScopes.fromSetFields(%s)", FieldScopeImpl.formatList(messages))));
    }

    static FieldScope createIgnoringFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.create(FieldScopeLogic.all().ignoringFields(fieldNumbers), FieldScopeUtil.fieldNumbersFunction("FieldScopes.ignoringFields(%s)", fieldNumbers));
    }

    static FieldScope createIgnoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.create(FieldScopeLogic.all().ignoringFieldDescriptors(fieldDescriptors), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format("FieldScopes.ignoringFieldDescriptors(%s)", FieldScopeUtil.join(fieldDescriptors))));
    }

    static FieldScope createAllowingFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.create(FieldScopeLogic.none().allowingFields(fieldNumbers), FieldScopeUtil.fieldNumbersFunction("FieldScopes.allowingFields(%s)", fieldNumbers));
    }

    static FieldScope createAllowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.create(FieldScopeLogic.none().allowingFieldDescriptors(fieldDescriptors), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format("FieldScopes.allowingFieldDescriptors(%s)", FieldScopeUtil.join(fieldDescriptors))));
    }

    static FieldScope all() {
        return ALL;
    }

    static FieldScope none() {
        return NONE;
    }

    private static boolean emptyOrAllNull(Iterable<?> objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    @Override
    String usingCorrespondenceString(Optional<Descriptors.Descriptor> descriptor) {
        return (String)this.usingCorrespondenceStringFunction().apply(descriptor);
    }

    @Override
    public final FieldScope ignoringFields(int firstFieldNumber, int ... rest) {
        return this.ignoringFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    @Override
    public final FieldScope ignoringFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.create(this.logic().ignoringFields(fieldNumbers), this.addUsingCorrespondenceFieldNumbersString(".ignoringFields(%s)", fieldNumbers));
    }

    @Override
    public final FieldScope ignoringFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.ignoringFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    @Override
    public final FieldScope ignoringFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.create(this.logic().ignoringFieldDescriptors(fieldDescriptors), this.addUsingCorrespondenceFieldDescriptorsString(".ignoringFieldDescriptors(%s)", fieldDescriptors));
    }

    @Override
    public final FieldScope allowingFields(int firstFieldNumber, int ... rest) {
        return this.allowingFields(FieldScopeUtil.asList(firstFieldNumber, rest));
    }

    @Override
    public final FieldScope allowingFields(Iterable<Integer> fieldNumbers) {
        return FieldScopeImpl.create(this.logic().allowingFields(fieldNumbers), this.addUsingCorrespondenceFieldNumbersString(".allowingFields(%s)", fieldNumbers));
    }

    @Override
    public final FieldScope allowingFieldDescriptors(Descriptors.FieldDescriptor firstFieldDescriptor, Descriptors.FieldDescriptor ... rest) {
        return this.allowingFieldDescriptors(Lists.asList((Object)firstFieldDescriptor, (Object[])rest));
    }

    @Override
    public final FieldScope allowingFieldDescriptors(Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeImpl.create(this.logic().allowingFieldDescriptors(fieldDescriptors), this.addUsingCorrespondenceFieldDescriptorsString(".allowingFieldDescriptors(%s)", fieldDescriptors));
    }

    private Function<Optional<Descriptors.Descriptor>, String> addUsingCorrespondenceFieldNumbersString(String fmt, Iterable<Integer> fieldNumbers) {
        return FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), FieldScopeUtil.fieldNumbersFunction(fmt, fieldNumbers));
    }

    private Function<Optional<Descriptors.Descriptor>, String> addUsingCorrespondenceFieldDescriptorsString(String fmt, Iterable<Descriptors.FieldDescriptor> fieldDescriptors) {
        return FieldScopeUtil.concat(this.usingCorrespondenceStringFunction(), (Function<? super Optional<Descriptors.Descriptor>, String>)Functions.constant((Object)String.format(fmt, FieldScopeUtil.join(fieldDescriptors))));
    }

    private static Iterable<String> getDescriptors(Iterable<? extends Message> messages) {
        ArrayList descriptors = Lists.newArrayList();
        for (Message message : messages) {
            descriptors.add(message == null ? "null" : message.getDescriptorForType().getFullName());
        }
        return descriptors;
    }

    private static String formatList(Iterable<? extends Message> messages) {
        ArrayList strings = Lists.newArrayList();
        for (Message message : messages) {
            strings.add(message == null ? "null" : "{" + message + "}");
        }
        return "[" + FieldScopeUtil.join(strings) + "]";
    }
}

