/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.flogger;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@BugPattern(name="FloggerWithCause", summary="Calling withCause(Throwable) with an inline allocated Throwable is discouraged. Consider using withStackTrace(StackSize) instead, and specifying a reduced stack size (e.g. SMALL, MEDIUM or LARGE) instead of FULL, to improve performance.", linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/flogger/best_practice#stack-trace", severity=BugPattern.SeverityLevel.WARNING)
public class FloggerWithCause
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String STACK_SIZE_MEDIUM_IMPORT = "com.google.common.flogger.StackSize.MEDIUM";
    private static final Matcher<ExpressionTree> WITH_CAUSE_MATCHER = Matchers.instanceMethod().onDescendantOf("com.google.common.flogger.LoggingApi").named("withCause");
    private static final Matcher<ExpressionTree> FIXABLE_THROWABLE_MATCHER = MethodMatchers.constructor().forClass(TypePredicates.isExactTypeAny((Iterable)ImmutableList.of((Object)"java.lang.AssertionError", (Object)"java.lang.Error", (Object)"java.lang.Exception", (Object)"java.lang.IllegalArgumentException", (Object)"java.lang.IllegalStateException", (Object)"java.lang.RuntimeException", (Object)"java.lang.Throwable", (Object)"com.google.photos.be.util.StackTraceLoggerException"))).withParameters((Iterable)ImmutableList.of());
    private static final Matcher<Tree> THROWABLE_MATCHER = Matchers.isSubtypeOf((String)"java.lang.Throwable");
    private static final Matcher<ExpressionTree> THROWABLE_STRING_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("getMessage"), Matchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("toString")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Optional<ExpressionTree> throwableArgument;
        if (!WITH_CAUSE_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree cause = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        if (cause.getKind() == Tree.Kind.NEW_CLASS && ((throwableArgument = FloggerWithCause.getThrowableArgument(cause, state)).isPresent() || FIXABLE_THROWABLE_MATCHER.matches((Tree)cause, state))) {
            List<Fix> fixes = FloggerWithCause.getFixes(tree, state, throwableArgument.orElse(null));
            return this.getDescription(tree, fixes);
        }
        return Description.NO_MATCH;
    }

    private Description getDescription(MethodInvocationTree tree, List<Fix> fixes) {
        Description.Builder description = this.buildDescription(tree);
        for (Fix fix : fixes) {
            description.addFix(fix);
        }
        return description.build();
    }

    private static List<Fix> getFixes(MethodInvocationTree tree, VisitorState state, ExpressionTree throwableArgument) {
        if (throwableArgument != null) {
            String withCauseReplacement = ".withCause(" + state.getSourceForNode((Tree)throwableArgument) + ")";
            String withStackTraceAndWithCauseReplacement = ".withStackTrace(MEDIUM)" + withCauseReplacement;
            return Arrays.asList(FloggerWithCause.getFix(tree, state, withCauseReplacement), FloggerWithCause.getFix(tree, state, withStackTraceAndWithCauseReplacement, STACK_SIZE_MEDIUM_IMPORT));
        }
        return Collections.singletonList(FloggerWithCause.getFix(tree, state, ".withStackTrace(MEDIUM)", STACK_SIZE_MEDIUM_IMPORT));
    }

    private static Optional<ExpressionTree> getThrowableArgument(ExpressionTree cause, VisitorState state) {
        for (ExpressionTree argument : ((JCTree.JCNewClass)cause).getArguments()) {
            if (THROWABLE_MATCHER.matches((Tree)argument, state)) {
                return Optional.of(argument);
            }
            if (!THROWABLE_STRING_MATCHER.matches((Tree)argument, state)) continue;
            return Optional.ofNullable(ASTHelpers.getReceiver((ExpressionTree)argument));
        }
        return Optional.empty();
    }

    private static Fix getFix(MethodInvocationTree tree, VisitorState state, String replacement, String importString) {
        return FloggerWithCause.getFixBuilder(tree, state, replacement).addStaticImport(importString).build();
    }

    private static Fix getFix(MethodInvocationTree tree, VisitorState state, String replacement) {
        return FloggerWithCause.getFixBuilder(tree, state, replacement).build();
    }

    private static SuggestedFix.Builder getFixBuilder(MethodInvocationTree tree, VisitorState state, String methodReplacement) {
        int methodStart = FloggerWithCause.getMethodStart(tree, state);
        int methodEnd = FloggerWithCause.getMethodEnd(tree, state);
        return SuggestedFix.builder().replace(methodStart, methodEnd, methodReplacement);
    }

    private static int getMethodStart(MethodInvocationTree tree, VisitorState state) {
        return state.getEndPosition((Tree)((JCTree)((Object)ASTHelpers.getReceiver((ExpressionTree)tree))));
    }

    private static int getMethodEnd(MethodInvocationTree tree, VisitorState state) {
        return state.getEndPosition((Tree)((JCTree)((Object)tree)));
    }
}

