/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="AutoValueBuilderDefaultsInConstructor", summary="Defaults for AutoValue Builders should be set in the factory method returning Builder instances, not the constructor", severity=BugPattern.SeverityLevel.ERROR)
public final class AutoValueBuilderDefaultsInConstructor
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (!symbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)"com.google.auto.value.AutoValue.Builder", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ImmutableList<String> invocations = AutoValueBuilderDefaultsInConstructor.extractInvocations(symbol, tree.getBody().getStatements(), state);
        if (invocations.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)AutoValueBuilderDefaultsInConstructor.appendDefaultsToConstructors(tree, symbol, invocations, state));
    }

    private static SuggestedFix appendDefaultsToConstructors(MethodTree tree, final Symbol.MethodSymbol symbol, ImmutableList<String> invocations, final VisitorState state) {
        final SuggestedFix.Builder fix = SuggestedFix.builder().delete((Tree)tree);
        final String defaultSetters = "." + String.join((CharSequence)".", invocations);
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitNewClass(NewClassTree tree, Void unused) {
                if (ASTHelpers.isSubtype((Type)ASTHelpers.getType((Tree)tree), (Type)symbol.owner.type, (VisitorState)state)) {
                    fix.postfixWith((Tree)tree, defaultSetters);
                }
                return (Void)super.visitNewClass(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    private static ImmutableList<String> extractInvocations(Symbol.MethodSymbol symbol, List<? extends StatementTree> statements, VisitorState state) {
        return (ImmutableList)statements.stream().filter(t -> t instanceof ExpressionStatementTree).map(t -> (ExpressionStatementTree)t).filter(t -> t.getExpression() instanceof MethodInvocationTree).map(t -> (MethodInvocationTree)t.getExpression()).filter(t -> {
            Symbol calledSymbol = ASTHelpers.getSymbol((Tree)t.getMethodSelect());
            return calledSymbol.owner.equals(symbol.owner) && calledSymbol.getModifiers().contains((Object)Modifier.ABSTRACT);
        }).map(t -> state.getSourceForNode((Tree)t).replaceFirst("^this\\.", "")).collect(ImmutableList.toImmutableList());
    }
}

