/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public abstract class AbstractMustBeClosedChecker
extends BugChecker {
    protected static final Matcher<Tree> HAS_MUST_BE_CLOSED_ANNOTATION = Matchers.symbolHasAnnotation((String)MustBeClosed.class.getCanonicalName());
    private static final Matcher<ExpressionTree> CLOSE_METHOD = Matchers.instanceMethod().onDescendantOf("java.lang.AutoCloseable").named("close");
    private static final Matcher<Tree> MOCKITO_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when"));

    protected Description scanEntireMethodFor(final Matcher<? super MethodInvocationTree> m, MethodTree tree, final VisitorState state) {
        final FixAggregator aggregator = this.findingPerMethod();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree methodTree, Void aVoid) {
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void aVoid) {
                VisitorState localState = state.withPath(this.getCurrentPath());
                if (m.matches((Tree)methodInvocationTree, localState)) {
                    Description description = AbstractMustBeClosedChecker.this.matchNewClassOrMethodInvocation(methodInvocationTree, localState, aggregator);
                    Verify.verify((boolean)description.fixes.isEmpty());
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, aVoid);
            }
        }.scan(tree.getBody(), null);
        return aggregator.flush().map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    protected Description matchNewClassOrMethodInvocation(ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        if (AbstractMustBeClosedChecker.isInStaticInitializer(state)) {
            return Description.NO_MATCH;
        }
        Description description = this.checkClosed(tree, state, aggregator);
        if (description == Description.NO_MATCH) {
            return Description.NO_MATCH;
        }
        if (AbstractReturnValueIgnored.expectedExceptionTest(tree, state) || AbstractReturnValueIgnored.mockitoInvocation(tree, state) || MOCKITO_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return description;
    }

    private Description checkClosed(ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        MethodTree callerMethodTree = AbstractMustBeClosedChecker.enclosingMethod(state);
        TreePath path = state.getPath();
        block7: while (true) {
            TreePath prev = path;
            path = path.getParentPath();
            switch (path.getLeaf().getKind()) {
                case RETURN: {
                    if (callerMethodTree != null) {
                        if (HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)callerMethodTree, state)) {
                            return Description.NO_MATCH;
                        }
                        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith((Tree)callerMethodTree, "@MustBeClosed\n").addImport(MustBeClosed.class.getCanonicalName()).build());
                    }
                    return this.emptyFix(tree);
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)path.getLeaf();
                    if (!conditionalExpressionTree.getTrueExpression().equals(prev.getLeaf()) && !conditionalExpressionTree.getFalseExpression().equals(prev.getLeaf())) break block7;
                    continue block7;
                }
                case MEMBER_SELECT: {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)path.getLeaf();
                    if (!memberSelectTree.getExpression().equals(prev.getLeaf())) break block7;
                    Type type = ASTHelpers.getType((Tree)memberSelectTree);
                    Symbol sym = ASTHelpers.getSymbol((Tree)memberSelectTree);
                    Type streamType = state.getTypeFromString(Stream.class.getName());
                    if (!ASTHelpers.isSubtype((Type)sym.enclClass().asType(), (Type)streamType, (VisitorState)state) || !ASTHelpers.isSameType((Type)type.getReturnType(), (Type)streamType, (VisitorState)state)) break block7;
                    path = path.getParentPath();
                    continue block7;
                }
                case VARIABLE: {
                    Symbol.VarSymbol var;
                    Symbol sym = ASTHelpers.getSymbol((Tree)path.getLeaf());
                    if (!(sym instanceof Symbol.VarSymbol) || (var = (Symbol.VarSymbol)sym).getKind() != ElementKind.RESOURCE_VARIABLE && !AbstractMustBeClosedChecker.isClosedInFinallyClause(var, path, state) && !AbstractMustBeClosedChecker.variableInitializationCountsAsClosing(var)) break block7;
                    return Description.NO_MATCH;
                }
                case ASSIGNMENT: {
                    return this.emptyFix(tree);
                }
            }
            break;
        }
        Description.Builder description = this.buildDescription(tree);
        this.addFix(description, tree, state, aggregator);
        return description.build();
    }

    private Description emptyFix(Tree tree) {
        return this.describeMatch(tree);
    }

    private static boolean variableInitializationCountsAsClosing(Symbol.VarSymbol var) {
        return var.isStatic() && var.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isInStaticInitializer(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(tree -> tree instanceof VariableTree && AbstractMustBeClosedChecker.variableInitializationCountsAsClosing((Symbol.VarSymbol)ASTHelpers.getSymbol((Tree)tree)));
    }

    @Nullable
    private static MethodTree enclosingMethod(VisitorState state) {
        for (Tree node : state.getPath().getParentPath()) {
            switch (node.getKind()) {
                case LAMBDA_EXPRESSION: 
                case NEW_CLASS: {
                    return null;
                }
                case METHOD: {
                    return (MethodTree)node;
                }
            }
        }
        return null;
    }

    private static boolean isClosedInFinallyClause(final Symbol.VarSymbol var, TreePath path, final VisitorState state) {
        if (!ASTHelpers.isConsideredFinal((Symbol)var)) {
            return false;
        }
        Tree parent = path.getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.BLOCK) {
            return false;
        }
        BlockTree block = (BlockTree)parent;
        int idx = block.getStatements().indexOf(path.getLeaf());
        if (idx == -1 || idx == block.getStatements().size() - 1) {
            return false;
        }
        StatementTree next = block.getStatements().get(idx + 1);
        if (!(next instanceof TryTree)) {
            return false;
        }
        TryTree tryTree = (TryTree)next;
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        final boolean[] closed = new boolean[]{false};
        tryTree.getFinallyBlock().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (CLOSE_METHOD.matches((Tree)tree, state) && Objects.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), var)) {
                    closed[0] = true;
                }
                return null;
            }
        }, null);
        return closed[0];
    }

    private Optional<TryBlock> chooseFixType(ExpressionTree tree, VisitorState state) {
        TreePath path = state.getPath();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof VariableTree) {
            return this.wrapTryFinallyAroundVariableScope((VariableTree)parent, state);
        }
        StatementTree stmt = (StatementTree)state.findEnclosing(new Class[]{StatementTree.class});
        if (stmt == null) {
            return Optional.empty();
        }
        if (!(stmt instanceof VariableTree)) {
            return this.introduceSingleStatementTry(tree, stmt, state);
        }
        Symbol.VarSymbol varSym = ASTHelpers.getSymbol((VariableTree)((VariableTree)stmt));
        if (varSym.getKind() == ElementKind.RESOURCE_VARIABLE) {
            return this.extractToResourceInCurrentTry(tree, stmt, state);
        }
        return this.splitVariableDeclarationAroundTry(tree, (VariableTree)stmt, state);
    }

    protected void addFix(Description.Builder description, ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        this.chooseFixType(tree, state).flatMap(aggregator::report).ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
    }

    private Optional<TryBlock> introduceSingleStatementTry(ExpressionTree tree, StatementTree stmt, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String name = this.suggestName(tree);
        if (state.getPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
            fix.delete((Tree)stmt);
        } else {
            fix.replace((Tree)tree, name);
        }
        return Optional.of(new TryBlock(stmt, fix.prefixWith((Tree)stmt, String.format("try (%s %s = %s) {", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)type), name, state.getSourceForNode((Tree)tree)))));
    }

    private Optional<TryBlock> extractToResourceInCurrentTry(ExpressionTree tree, StatementTree declaringStatement, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return Optional.empty();
        }
        String name = this.suggestName(tree);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(new TryBlock(fix.prefixWith((Tree)declaringStatement, String.format("%s %s = %s;", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)type), name, state.getSourceForNode((Tree)tree))).replace((Tree)tree, name)));
    }

    private Optional<TryBlock> splitVariableDeclarationAroundTry(ExpressionTree tree, VariableTree var, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (type == null) {
            return Optional.empty();
        }
        int initPos = ASTHelpers.getStartPosition((Tree)var.getInitializer());
        int afterTypePos = state.getEndPosition(var.getType());
        String name = this.suggestName(tree);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(new TryBlock(var, fix.replace(afterTypePos, initPos, String.format(" %s;\ntry (%s %s = %s) {\n%s =", var.getName(), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (TypeMirror)type), name, state.getSourceForNode((Tree)tree), var.getName())).replace((Tree)tree, name)));
    }

    private Optional<TryBlock> wrapTryFinallyAroundVariableScope(VariableTree decl, VisitorState state) {
        BlockTree enclosingBlock = (BlockTree)state.findEnclosing(new Class[]{BlockTree.class});
        if (enclosingBlock == null) {
            return Optional.empty();
        }
        return Optional.of(new TryBlock(enclosingBlock, SuggestedFix.builder().prefixWith((Tree)decl, String.format("try (%s %s = %s) {", state.getSourceForNode(decl.getType()), decl.getName().toString(), state.getSourceForNode((Tree)decl.getInitializer()))).delete((Tree)decl)));
    }

    private String suggestName(ExpressionTree tree) {
        String symbolName;
        switch (tree.getKind()) {
            case NEW_CLASS: {
                symbolName = ASTHelpers.getSymbol((Tree)((NewClassTree)tree).getIdentifier()).getSimpleName().toString();
                break;
            }
            case METHOD_INVOCATION: {
                symbolName = ((Name)ASTHelpers.getReturnType((ExpressionTree)tree).asElement().getSimpleName()).toString();
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, symbolName);
    }

    protected FixAggregator findingPerMethod() {
        return new FindingPerMethod();
    }

    protected FixAggregator findingPerSite() {
        return FindingPerSite.INSTANCE;
    }

    private static final class FindingPerSite
    implements FixAggregator {
        private static final FindingPerSite INSTANCE = new FindingPerSite();

        private FindingPerSite() {
        }

        @Override
        public Optional<SuggestedFix> report(TryBlock t) {
            return Optional.of(t.closeBraceAfter.map(where -> t.otherChanges.postfixWith(where, "}")).orElse(t.otherChanges).build());
        }

        @Override
        public Optional<SuggestedFix> flush() {
            return Optional.empty();
        }
    }

    private static final class FindingPerMethod
    implements FixAggregator {
        private final ListMultimap<Optional<Tree>, TryBlock> reports = ArrayListMultimap.create();

        private FindingPerMethod() {
        }

        @Override
        public Optional<SuggestedFix> report(TryBlock fix) {
            this.reports.put(fix.closeBraceAfter, (Object)fix);
            return Optional.empty();
        }

        @Override
        public Optional<SuggestedFix> flush() {
            if (this.reports.isEmpty()) {
                return Optional.empty();
            }
            SuggestedFix.Builder fix = SuggestedFix.builder();
            for (Map.Entry e : this.reports.asMap().entrySet()) {
                Optional block = (Optional)e.getKey();
                Collection changes = (Collection)e.getValue();
                block.ifPresent(b -> fix.postfixWith(b, Strings.repeat((String)"}", (int)changes.size())));
                for (TryBlock change : changes) {
                    fix.merge(change.otherChanges);
                }
            }
            this.reports.clear();
            return Optional.of(fix.build());
        }
    }

    protected static interface FixAggregator {
        public Optional<SuggestedFix> report(TryBlock var1);

        public Optional<SuggestedFix> flush();
    }

    private static class TryBlock {
        final Optional<Tree> closeBraceAfter;
        final SuggestedFix.Builder otherChanges;

        TryBlock(SuggestedFix.Builder changes) {
            this.closeBraceAfter = Optional.empty();
            this.otherChanges = changes;
        }

        TryBlock(Tree closeBraceAfter, SuggestedFix.Builder otherChanges) {
            this.closeBraceAfter = Optional.of(closeBraceAfter);
            this.otherChanges = otherChanges;
        }
    }
}

