/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(name="IgnoredPureGetter", severity=BugPattern.SeverityLevel.WARNING, summary="Getters on AutoValue classes and protos are side-effect free, so there is no point in calling them if the return value is ignored.")
public final class IgnoredPureGetter
extends AbstractReturnValueIgnored {
    private static final String MESSAGE_LITE = "com.google.protobuf.MessageLite";
    private static final String MUTABLE_MESSAGE_LITE = "com.google.protobuf.MutableMessageLite";

    @Override
    protected Matcher<? super ExpressionTree> specializedMatcher() {
        return IgnoredPureGetter::isPureGetter;
    }

    private static boolean isPureGetter(ExpressionTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (!(symbol instanceof Symbol.MethodSymbol)) {
            return false;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol.owner, (String)"com.google.auto.value.AutoValue", (VisitorState)state) && symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)state.getTypeFromString(MESSAGE_LITE), (VisitorState)state) && !ASTHelpers.isSubtype((Type)symbol.owner.type, (Type)state.getTypeFromString(MUTABLE_MESSAGE_LITE), (VisitorState)state)) {
            String name = symbol.getSimpleName().toString();
            return (name.startsWith("get") || name.startsWith("has")) && ((List)((Symbol.MethodSymbol)symbol).getParameters()).isEmpty();
        }
        return false;
    }
}

