/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassFile;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.ByteBuffer;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class ClassWriter
extends ClassFile {
    protected static final Context.Key<ClassWriter> classWriterKey = new Context.Key();
    private final Options options;
    private boolean verbose;
    private boolean emitSourceFile;
    private boolean genCrt;
    private boolean debugstackmap;
    private Preview preview;
    private Target target;
    private Source source;
    private Types types;
    private Check check;
    public boolean multiModuleMode;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    Pool pool;
    Set<Symbol.ClassSymbol> innerClasses;
    ListBuffer<Symbol.ClassSymbol> innerClassesQueue;
    Map<Pool.DynamicMethod.BootstrapMethodsKey, Pool.DynamicMethod.BootstrapMethodsValue> bootstrapMethods;
    private final Log log;
    private final Names names;
    private final JavaFileManager fileManager;
    private final CWSignatureGenerator signatureGen;
    static final int SAME_FRAME_SIZE = 64;
    static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
    static final int SAME_FRAME_EXTENDED = 251;
    static final int FULL_FRAME = 255;
    static final int MAX_LOCAL_LENGTH_DIFF = 4;
    private boolean dumpClassModifiers;
    private boolean dumpFieldModifiers;
    private boolean dumpInnerClassModifiers;
    private boolean dumpMethodModifiers;
    private static final String[] flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    AttributeWriter awriter = new AttributeWriter();

    public static ClassWriter instance(Context context) {
        ClassWriter instance = context.get(classWriterKey);
        if (instance == null) {
            instance = new ClassWriter(context);
        }
        return instance;
    }

    protected ClassWriter(Context context) {
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.options = Options.instance(context);
        this.preview = Preview.instance(context);
        this.target = Target.instance(context);
        this.source = Source.instance(context);
        this.types = Types.instance(context);
        this.check = Check.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        this.signatureGen = new CWSignatureGenerator(this.types);
        this.verbose = this.options.isSet(Option.VERBOSE);
        this.genCrt = this.options.isSet(Option.XJCOV);
        this.debugstackmap = this.options.isSet("debug.stackmap");
        this.emitSourceFile = this.options.isUnset(Option.G_CUSTOM) || this.options.isSet(Option.G_CUSTOM, "source");
        String modifierFlags = this.options.get("debug.dumpmodifiers");
        if (modifierFlags != null) {
            this.dumpClassModifiers = modifierFlags.indexOf(99) != -1;
            this.dumpFieldModifiers = modifierFlags.indexOf(102) != -1;
            this.dumpInnerClassModifiers = modifierFlags.indexOf(105) != -1;
            this.dumpMethodModifiers = modifierFlags.indexOf(109) != -1;
        }
    }

    public static String flagNames(long flags) {
        StringBuilder sbuf = new StringBuilder();
        int i = 0;
        long f = flags & 0xFFFL;
        while (f != 0L) {
            if ((f & 1L) != 0L) {
                sbuf.append(" ");
                sbuf.append(flagName[i]);
            }
            f >>= 1;
            ++i;
        }
        return sbuf.toString();
    }

    void putChar(ByteBuffer buf, int op, int x) {
        buf.elems[op] = (byte)(x >> 8 & 0xFF);
        buf.elems[op + 1] = (byte)(x & 0xFF);
    }

    void putInt(ByteBuffer buf, int adr, int x) {
        buf.elems[adr] = (byte)(x >> 24 & 0xFF);
        buf.elems[adr + 1] = (byte)(x >> 16 & 0xFF);
        buf.elems[adr + 2] = (byte)(x >> 8 & 0xFF);
        buf.elems[adr + 3] = (byte)(x & 0xFF);
    }

    Name typeSig(Type type) {
        Assert.check(this.signatureGen.isEmpty());
        this.signatureGen.assembleSig(type);
        Name n = this.signatureGen.toName();
        this.signatureGen.reset();
        return n;
    }

    public Name xClassName(Type t) {
        if (t.hasTag(TypeTag.CLASS)) {
            return this.names.fromUtf(ClassWriter.externalize(t.tsym.flatName()));
        }
        if (t.hasTag(TypeTag.ARRAY)) {
            return this.typeSig(this.types.erasure(t));
        }
        throw new AssertionError((Object)("xClassName expects class or array type, got " + t));
    }

    void writePool(Pool pool) throws PoolOverflow, StringOverflow {
        int poolCountIdx = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        for (int i = 1; i < pool.pp; ++i) {
            Symbol m;
            Object value = pool.pool[i];
            Assert.checkNonNull(value);
            if (value instanceof Pool.Method || value instanceof Pool.Variable) {
                value = ((Symbol.DelegatedSymbol)value).getUnderlyingSymbol();
            }
            if (value instanceof Symbol.MethodSymbol) {
                m = (Symbol.MethodSymbol)value;
                if (!m.isDynamic()) {
                    this.poolbuf.appendByte((m.owner.flags() & 0x200L) != 0L ? 11 : 10);
                    this.poolbuf.appendChar(pool.put(m.owner));
                    this.poolbuf.appendChar(pool.put(this.nameType(m)));
                    continue;
                }
                Symbol.DynamicMethodSymbol dynSym = (Symbol.DynamicMethodSymbol)m;
                Pool.MethodHandle handle = new Pool.MethodHandle(dynSym.bsmKind, dynSym.bsm, this.types);
                Pool.DynamicMethod.BootstrapMethodsKey key = new Pool.DynamicMethod.BootstrapMethodsKey(dynSym, this.types);
                Pool.DynamicMethod.BootstrapMethodsValue val = this.bootstrapMethods.get(key);
                if (val == null) {
                    int index = this.bootstrapMethods.size();
                    val = new Pool.DynamicMethod.BootstrapMethodsValue(handle, index);
                    this.bootstrapMethods.put(key, val);
                }
                pool.put(this.names.BootstrapMethods);
                pool.put(handle);
                for (Object staticArg : dynSym.staticArgs) {
                    pool.put(staticArg);
                }
                this.poolbuf.appendByte(18);
                this.poolbuf.appendChar(val.index);
                this.poolbuf.appendChar(pool.put(this.nameType(dynSym)));
                continue;
            }
            if (value instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)value;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(v.owner));
                this.poolbuf.appendChar(pool.put(this.nameType(v)));
                continue;
            }
            if (value instanceof Name) {
                this.poolbuf.appendByte(1);
                byte[] bs = ((Name)value).toUtf();
                this.poolbuf.appendChar(bs.length);
                this.poolbuf.appendBytes(bs, 0, bs.length);
                if (bs.length <= 65535) continue;
                throw new StringOverflow(value.toString());
            }
            if (value instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol c = (Symbol.ClassSymbol)value;
                if (c.owner.kind == Kinds.Kind.TYP) {
                    pool.put(c.owner);
                }
                this.poolbuf.appendByte(7);
                if (c.type.hasTag(TypeTag.ARRAY)) {
                    this.poolbuf.appendChar(pool.put(this.typeSig(c.type)));
                    continue;
                }
                this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(c.flatname))));
                this.enterInner(c);
                continue;
            }
            if (value instanceof ClassFile.NameAndType) {
                ClassFile.NameAndType nt = (ClassFile.NameAndType)value;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(nt.name));
                this.poolbuf.appendChar(pool.put(this.typeSig(nt.uniqueType.type)));
                continue;
            }
            if (value instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)value);
                ++i;
                continue;
            }
            if (value instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)value);
                ++i;
                continue;
            }
            if (value instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(this.names.fromString((String)value)));
                continue;
            }
            if (value instanceof Types.UniqueType) {
                Type type = ((Types.UniqueType)value).type;
                if (type.hasTag(TypeTag.METHOD)) {
                    this.poolbuf.appendByte(16);
                    this.poolbuf.appendChar(pool.put(this.typeSig((Type.MethodType)type)));
                    continue;
                }
                Assert.check(type.hasTag(TypeTag.ARRAY));
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName(type)));
                continue;
            }
            if (value instanceof Pool.MethodHandle) {
                Pool.MethodHandle ref = (Pool.MethodHandle)value;
                this.poolbuf.appendByte(15);
                this.poolbuf.appendByte(ref.refKind);
                this.poolbuf.appendChar(pool.put(ref.refSym));
                continue;
            }
            if (value instanceof Symbol.ModuleSymbol) {
                m = (Symbol.ModuleSymbol)value;
                this.poolbuf.appendByte(19);
                this.poolbuf.appendChar(pool.put(((Symbol.ModuleSymbol)m).name));
                continue;
            }
            if (value instanceof Symbol.PackageSymbol) {
                m = (Symbol.PackageSymbol)value;
                this.poolbuf.appendByte(20);
                this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(((Symbol.PackageSymbol)m).fullname))));
                continue;
            }
            Assert.error("writePool " + value);
        }
        if (pool.pp > 65535) {
            throw new PoolOverflow();
        }
        this.putChar(this.poolbuf, poolCountIdx, pool.pp);
    }

    ClassFile.NameAndType nameType(Symbol sym) {
        return new ClassFile.NameAndType(sym.name, sym.externalType(this.types), this.types);
    }

    int writeAttr(Name attrName) {
        this.databuf.appendChar(this.pool.put(attrName));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int index) {
        this.putInt(this.databuf, index - 4, this.databuf.length - index);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int index, int count) {
        this.putChar(this.databuf, index - 2, count);
    }

    int writeEnclosingMethodAttribute(Symbol.ClassSymbol c) {
        return this.writeEnclosingMethodAttribute(this.names.EnclosingMethod, c);
    }

    protected int writeEnclosingMethodAttribute(Name attributeName, Symbol.ClassSymbol c) {
        if (c.owner.kind != Kinds.Kind.MTH && c.name != this.names.empty) {
            return 0;
        }
        int alenIdx = this.writeAttr(attributeName);
        Symbol.ClassSymbol enclClass = c.owner.enclClass();
        Symbol.MethodSymbol enclMethod = c.owner.type == null || c.owner.kind != Kinds.Kind.MTH ? null : (Symbol.MethodSymbol)c.owner;
        this.databuf.appendChar(this.pool.put(enclClass));
        this.databuf.appendChar(enclMethod == null ? 0 : this.pool.put(this.nameType(c.owner)));
        this.endAttr(alenIdx);
        return 1;
    }

    int writeFlagAttrs(long flags) {
        int acount = 0;
        if ((flags & 0x20000L) != 0L) {
            int alenIdx = this.writeAttr(this.names.Deprecated);
            this.endAttr(alenIdx);
            ++acount;
        }
        return acount;
    }

    int writeMemberAttrs(Symbol sym) {
        int acount = this.writeFlagAttrs(sym.flags());
        long flags = sym.flags();
        if ((flags & 0x80001000L) != 4096L && (flags & 0x20000000L) == 0L && (!this.types.isSameType(sym.type, sym.erasure(this.types)) || this.signatureGen.hasTypeVar(sym.type.getThrownTypes()))) {
            int alenIdx = this.writeAttr(this.names.Signature);
            this.databuf.appendChar(this.pool.put(this.typeSig(sym.type)));
            this.endAttr(alenIdx);
            ++acount;
        }
        acount += this.writeJavaAnnotations(sym.getRawAttributes());
        return acount += this.writeTypeAnnotations(sym.getRawTypeAttributes(), false);
    }

    int writeMethodParametersAttr(Symbol.MethodSymbol m) {
        Type.MethodType ty = m.externalType(this.types).asMethodType();
        int allparams = ty.argtypes.size();
        if (m.params != null && allparams != 0) {
            int flags;
            int attrIndex = this.writeAttr(this.names.MethodParameters);
            this.databuf.appendByte(allparams);
            for (Symbol.VarSymbol s : m.extraParams) {
                flags = (int)s.flags() & 0x9010 | (int)m.flags() & 0x1000;
                this.databuf.appendChar(this.pool.put(s.name));
                this.databuf.appendChar(flags);
            }
            for (Symbol.VarSymbol s : m.params) {
                flags = (int)s.flags() & 0x9010 | (int)m.flags() & 0x1000;
                this.databuf.appendChar(this.pool.put(s.name));
                this.databuf.appendChar(flags);
            }
            for (Symbol.VarSymbol s : m.capturedLocals) {
                flags = (int)s.flags() & 0x9010 | (int)m.flags() & 0x1000;
                this.databuf.appendChar(this.pool.put(s.name));
                this.databuf.appendChar(flags);
            }
            this.endAttr(attrIndex);
            return 1;
        }
        return 0;
    }

    private void writeParamAnnotations(List<Symbol.VarSymbol> params, Attribute.RetentionPolicy retention) {
        for (Symbol.VarSymbol s : params) {
            ListBuffer<Attribute.Compound> buf = new ListBuffer<Attribute.Compound>();
            for (Attribute.Compound a : s.getRawAttributes()) {
                if (this.types.getRetention(a) != retention) continue;
                buf.append(a);
            }
            this.databuf.appendChar(buf.length());
            for (Attribute.Compound a : buf) {
                this.writeCompoundAttribute(a);
            }
        }
    }

    private void writeParamAnnotations(Symbol.MethodSymbol m, Attribute.RetentionPolicy retention) {
        this.databuf.appendByte(m.params.length());
        this.writeParamAnnotations(m.params, retention);
    }

    int writeParameterAttrs(Symbol.MethodSymbol m) {
        boolean hasVisible = false;
        boolean hasInvisible = false;
        if (m.params != null) {
            for (Symbol.VarSymbol s : m.params) {
                for (Attribute.Compound a : s.getRawAttributes()) {
                    switch (this.types.getRetention(a)) {
                        case SOURCE: {
                            break;
                        }
                        case CLASS: {
                            hasInvisible = true;
                            break;
                        }
                        case RUNTIME: {
                            hasVisible = true;
                            break;
                        }
                    }
                }
            }
        }
        int attrCount = 0;
        if (hasVisible) {
            int attrIndex = this.writeAttr(this.names.RuntimeVisibleParameterAnnotations);
            this.writeParamAnnotations(m, Attribute.RetentionPolicy.RUNTIME);
            this.endAttr(attrIndex);
            ++attrCount;
        }
        if (hasInvisible) {
            int attrIndex = this.writeAttr(this.names.RuntimeInvisibleParameterAnnotations);
            this.writeParamAnnotations(m, Attribute.RetentionPolicy.CLASS);
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    int writeJavaAnnotations(List<Attribute.Compound> attrs) {
        if (attrs.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.Compound> visibles = new ListBuffer<Attribute.Compound>();
        ListBuffer<Attribute.Compound> invisibles = new ListBuffer<Attribute.Compound>();
        for (Attribute.Compound a : attrs) {
            switch (this.types.getRetention(a)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    invisibles.append(a);
                    break;
                }
                case RUNTIME: {
                    visibles.append(a);
                    break;
                }
            }
        }
        int attrCount = 0;
        if (visibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeVisibleAnnotations);
            this.databuf.appendChar(visibles.length());
            for (Attribute.Compound a : visibles) {
                this.writeCompoundAttribute(a);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        if (invisibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeInvisibleAnnotations);
            this.databuf.appendChar(invisibles.length());
            for (Attribute.Compound a : invisibles) {
                this.writeCompoundAttribute(a);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    int writeTypeAnnotations(List<Attribute.TypeCompound> typeAnnos, boolean inCode) {
        if (typeAnnos.isEmpty()) {
            return 0;
        }
        ListBuffer<Attribute.TypeCompound> visibles = new ListBuffer<Attribute.TypeCompound>();
        ListBuffer<Attribute.TypeCompound> invisibles = new ListBuffer<Attribute.TypeCompound>();
        for (Attribute.TypeCompound tc : typeAnnos) {
            boolean fixed;
            if (tc.hasUnknownPosition() && !(fixed = tc.tryFixPosition())) {
                PrintWriter pw = this.log.getWriter(Log.WriterKind.ERROR);
                pw.println("ClassWriter: Position UNKNOWN in type annotation: " + tc);
                continue;
            }
            if (tc.position.type.isLocal() != inCode || !tc.position.emitToClassfile()) continue;
            switch (this.types.getRetention(tc)) {
                case SOURCE: {
                    break;
                }
                case CLASS: {
                    invisibles.append(tc);
                    break;
                }
                case RUNTIME: {
                    visibles.append(tc);
                    break;
                }
            }
        }
        int attrCount = 0;
        if (visibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeVisibleTypeAnnotations);
            this.databuf.appendChar(visibles.length());
            for (Attribute.TypeCompound p : visibles) {
                this.writeTypeAnnotation(p);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        if (invisibles.length() != 0) {
            int attrIndex = this.writeAttr(this.names.RuntimeInvisibleTypeAnnotations);
            this.databuf.appendChar(invisibles.length());
            for (Attribute.TypeCompound p : invisibles) {
                this.writeTypeAnnotation(p);
            }
            this.endAttr(attrIndex);
            ++attrCount;
        }
        return attrCount;
    }

    void writeCompoundAttribute(Attribute.Compound c) {
        this.databuf.appendChar(this.pool.put(this.typeSig(c.type)));
        this.databuf.appendChar(c.values.length());
        for (Pair<Symbol.MethodSymbol, Attribute> p : c.values) {
            this.databuf.appendChar(this.pool.put(((Symbol.MethodSymbol)p.fst).name));
            ((Attribute)p.snd).accept(this.awriter);
        }
    }

    void writeTypeAnnotation(Attribute.TypeCompound c) {
        this.writePosition(c.position);
        this.writeCompoundAttribute(c);
    }

    void writePosition(TypeAnnotationPosition p) {
        this.databuf.appendByte(p.type.targetTypeValue());
        switch (p.type) {
            case INSTANCEOF: 
            case NEW: 
            case CONSTRUCTOR_REFERENCE: 
            case METHOD_REFERENCE: {
                this.databuf.appendChar(p.offset);
                break;
            }
            case LOCAL_VARIABLE: 
            case RESOURCE_VARIABLE: {
                this.databuf.appendChar(p.lvarOffset.length);
                for (int i = 0; i < p.lvarOffset.length; ++i) {
                    this.databuf.appendChar(p.lvarOffset[i]);
                    this.databuf.appendChar(p.lvarLength[i]);
                    this.databuf.appendChar(p.lvarIndex[i]);
                }
                break;
            }
            case EXCEPTION_PARAMETER: {
                this.databuf.appendChar(p.getExceptionIndex());
                break;
            }
            case METHOD_RECEIVER: {
                break;
            }
            case CLASS_TYPE_PARAMETER: 
            case METHOD_TYPE_PARAMETER: {
                this.databuf.appendByte(p.parameter_index);
                break;
            }
            case CLASS_TYPE_PARAMETER_BOUND: 
            case METHOD_TYPE_PARAMETER_BOUND: {
                this.databuf.appendByte(p.parameter_index);
                this.databuf.appendByte(p.bound_index);
                break;
            }
            case CLASS_EXTENDS: {
                this.databuf.appendChar(p.type_index);
                break;
            }
            case THROWS: {
                this.databuf.appendChar(p.type_index);
                break;
            }
            case METHOD_FORMAL_PARAMETER: {
                this.databuf.appendByte(p.parameter_index);
                break;
            }
            case CAST: 
            case CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT: 
            case METHOD_INVOCATION_TYPE_ARGUMENT: 
            case CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT: 
            case METHOD_REFERENCE_TYPE_ARGUMENT: {
                this.databuf.appendChar(p.offset);
                this.databuf.appendByte(p.type_index);
                break;
            }
            case METHOD_RETURN: 
            case FIELD: {
                break;
            }
            case UNKNOWN: {
                throw new AssertionError((Object)"jvm.ClassWriter: UNKNOWN target type should never occur!");
            }
            default: {
                throw new AssertionError((Object)("jvm.ClassWriter: Unknown target type for position: " + p));
            }
        }
        this.databuf.appendByte(p.location.size());
        List<Integer> loc = TypeAnnotationPosition.getBinaryFromTypePath(p.location);
        Iterator iterator = loc.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.databuf.appendByte((byte)i);
        }
    }

    int writeModuleAttribute(Symbol.ClassSymbol c) {
        Symbol.ModuleSymbol m = (Symbol.ModuleSymbol)c.owner;
        int alenIdx = this.writeAttr(this.names.Module);
        this.databuf.appendChar(this.pool.put(m));
        this.databuf.appendChar(Symbol.ModuleFlags.value(m.flags));
        this.databuf.appendChar(m.version != null ? this.pool.put(m.version) : 0);
        ListBuffer<Directive.RequiresDirective> requires = new ListBuffer<Directive.RequiresDirective>();
        for (Directive.RequiresDirective requiresDirective : m.requires) {
            if (requiresDirective.flags.contains((Object)Directive.RequiresFlag.EXTRA)) continue;
            requires.add(requiresDirective);
        }
        this.databuf.appendChar(requires.size());
        for (Directive.RequiresDirective requiresDirective : requires) {
            this.databuf.appendChar(this.pool.put(requiresDirective.module));
            this.databuf.appendChar(Directive.RequiresFlag.value(requiresDirective.flags));
            this.databuf.appendChar(requiresDirective.module.version != null ? this.pool.put(requiresDirective.module.version) : 0);
        }
        List<Directive.ExportsDirective> exports = m.exports;
        this.databuf.appendChar(exports.size());
        for (Directive.ExportsDirective exportsDirective : exports) {
            this.databuf.appendChar(this.pool.put(exportsDirective.packge));
            this.databuf.appendChar(Directive.ExportsFlag.value(exportsDirective.flags));
            if (exportsDirective.modules == null) {
                this.databuf.appendChar(0);
                continue;
            }
            this.databuf.appendChar(exportsDirective.modules.size());
            for (Symbol.ModuleSymbol moduleSymbol : exportsDirective.modules) {
                this.databuf.appendChar(this.pool.put(moduleSymbol));
            }
        }
        List<Directive.OpensDirective> list = m.opens;
        this.databuf.appendChar(list.size());
        for (Directive.OpensDirective opensDirective : list) {
            this.databuf.appendChar(this.pool.put(opensDirective.packge));
            this.databuf.appendChar(Directive.OpensFlag.value(opensDirective.flags));
            if (opensDirective.modules == null) {
                this.databuf.appendChar(0);
                continue;
            }
            this.databuf.appendChar(opensDirective.modules.size());
            for (Symbol.ModuleSymbol msym : opensDirective.modules) {
                this.databuf.appendChar(this.pool.put(msym));
            }
        }
        List<Directive.UsesDirective> list2 = m.uses;
        this.databuf.appendChar(list2.size());
        for (Directive.UsesDirective usesDirective : list2) {
            this.databuf.appendChar(this.pool.put(usesDirective.service));
        }
        LinkedHashMap<Symbol.ClassSymbol, Set> linkedHashMap = new LinkedHashMap<Symbol.ClassSymbol, Set>();
        for (Directive.ProvidesDirective p : m.provides) {
            linkedHashMap.computeIfAbsent(p.service, s -> new LinkedHashSet()).addAll(p.impls);
        }
        this.databuf.appendChar(linkedHashMap.size());
        linkedHashMap.forEach((srvc, impls) -> {
            this.databuf.appendChar(this.pool.put(srvc));
            this.databuf.appendChar(impls.size());
            impls.forEach(impl -> this.databuf.appendChar(this.pool.put(impl)));
        });
        this.endAttr(alenIdx);
        return 1;
    }

    void enterInner(Symbol.ClassSymbol c) {
        if (c.type.isCompound()) {
            throw new AssertionError((Object)("Unexpected intersection type: " + c.type));
        }
        try {
            c.complete();
        }
        catch (Symbol.CompletionFailure ex) {
            System.err.println("error: " + c + ": " + ex.getMessage());
            throw ex;
        }
        if (!c.type.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (!(this.pool == null || c.owner.enclClass() == null || this.innerClasses != null && this.innerClasses.contains(c))) {
            this.enterInner(c.owner.enclClass());
            this.pool.put(c);
            if (c.name != this.names.empty) {
                this.pool.put(c.name);
            }
            if (this.innerClasses == null) {
                this.innerClasses = new HashSet<Symbol.ClassSymbol>();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(this.names.InnerClasses);
            }
            this.innerClasses.add(c);
            this.innerClassesQueue.append(c);
        }
    }

    void writeInnerClasses() {
        int alenIdx = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List<Symbol.ClassSymbol> l = this.innerClassesQueue.toList();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol inner = (Symbol.ClassSymbol)l.head;
            inner.markAbstractIfNeeded(this.types);
            char flags = (char)this.adjustFlags(inner.flags_field);
            if ((flags & 0x200) != 0) {
                flags = (char)(flags | 0x400);
            }
            flags = (char)(flags & 0xFFFFF7FF);
            if (this.dumpInnerClassModifiers) {
                PrintWriter pw = this.log.getWriter(Log.WriterKind.ERROR);
                pw.println("INNERCLASS  " + inner.name);
                pw.println("---" + ClassWriter.flagNames(flags));
            }
            this.databuf.appendChar(this.pool.get(inner));
            this.databuf.appendChar(inner.owner.kind == Kinds.Kind.TYP && !inner.name.isEmpty() ? this.pool.get(inner.owner) : 0);
            this.databuf.appendChar(!inner.name.isEmpty() ? this.pool.get(inner.name) : 0);
            this.databuf.appendChar(flags);
            l = l.tail;
        }
        this.endAttr(alenIdx);
    }

    int writeNestMembersIfNeeded(Symbol.ClassSymbol csym) {
        ListBuffer<Symbol> nested = new ListBuffer<Symbol>();
        this.listNested(csym, nested);
        LinkedHashSet<Symbol> nestedUnique = new LinkedHashSet<Symbol>(nested);
        if (csym.owner.kind == Kinds.Kind.PCK && !nestedUnique.isEmpty()) {
            int alenIdx = this.writeAttr(this.names.NestMembers);
            this.databuf.appendChar(nestedUnique.size());
            for (Symbol s : nestedUnique) {
                this.databuf.appendChar(this.pool.put(s));
            }
            this.endAttr(alenIdx);
            return 1;
        }
        return 0;
    }

    int writeNestHostIfNeeded(Symbol.ClassSymbol csym) {
        if (csym.owner.kind != Kinds.Kind.PCK) {
            int alenIdx = this.writeAttr(this.names.NestHost);
            this.databuf.appendChar(this.pool.put(csym.outermostClass()));
            this.endAttr(alenIdx);
            return 1;
        }
        return 0;
    }

    private void listNested(Symbol sym, ListBuffer<Symbol> seen) {
        if (sym.kind != Kinds.Kind.TYP) {
            return;
        }
        Symbol.ClassSymbol csym = (Symbol.ClassSymbol)sym;
        if (csym.owner.kind != Kinds.Kind.PCK) {
            seen.add(csym);
        }
        if (csym.members() != null) {
            for (Symbol symbol : sym.members().getSymbols()) {
                this.listNested(symbol, seen);
            }
        }
        if (csym.trans_local != null) {
            for (Symbol symbol : csym.trans_local) {
                this.listNested(symbol, seen);
            }
        }
    }

    void writeBootstrapMethods() {
        int alenIdx = this.writeAttr(this.names.BootstrapMethods);
        this.databuf.appendChar(this.bootstrapMethods.size());
        for (Map.Entry<Pool.DynamicMethod.BootstrapMethodsKey, Pool.DynamicMethod.BootstrapMethodsValue> entry : this.bootstrapMethods.entrySet()) {
            Pool.DynamicMethod.BootstrapMethodsKey bsmKey = entry.getKey();
            this.databuf.appendChar(this.pool.get(entry.getValue().mh));
            Object[] uniqueArgs = bsmKey.getUniqueArgs();
            this.databuf.appendChar(uniqueArgs.length);
            for (Object o : uniqueArgs) {
                this.databuf.appendChar(this.pool.get(o));
            }
        }
        this.endAttr(alenIdx);
    }

    void writeField(Symbol.VarSymbol v) {
        int flags = this.adjustFlags(v.flags());
        this.databuf.appendChar(flags);
        if (this.dumpFieldModifiers) {
            PrintWriter pw = this.log.getWriter(Log.WriterKind.ERROR);
            pw.println("FIELD  " + v.name);
            pw.println("---" + ClassWriter.flagNames(v.flags()));
        }
        this.databuf.appendChar(this.pool.put(v.name));
        this.databuf.appendChar(this.pool.put(this.typeSig(v.erasure(this.types))));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (v.getConstValue() != null) {
            int alenIdx = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.pool.put(v.getConstValue()));
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount += this.writeMemberAttrs(v));
    }

    void writeMethod(Symbol.MethodSymbol m) {
        int alenIdx;
        List<Type> thrown;
        int flags = this.adjustFlags(m.flags());
        this.databuf.appendChar(flags);
        if (this.dumpMethodModifiers) {
            PrintWriter pw = this.log.getWriter(Log.WriterKind.ERROR);
            pw.println("METHOD  " + m.name);
            pw.println("---" + ClassWriter.flagNames(m.flags()));
        }
        this.databuf.appendChar(this.pool.put(m.name));
        this.databuf.appendChar(this.pool.put(this.typeSig(m.externalType(this.types))));
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (m.code != null) {
            int alenIdx2 = this.writeAttr(this.names.Code);
            this.writeCode(m.code);
            m.code = null;
            this.endAttr(alenIdx2);
            ++acount;
        }
        if ((thrown = m.erasure(this.types).getThrownTypes()).nonEmpty()) {
            alenIdx = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(thrown.length());
            List<Type> l = thrown;
            while (l.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(((Type)l.head).tsym));
                l = l.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (m.defaultValue != null) {
            alenIdx = this.writeAttr(this.names.AnnotationDefault);
            m.defaultValue.accept(this.awriter);
            this.endAttr(alenIdx);
            ++acount;
        }
        if (this.options.isSet(Option.PARAMETERS) && this.target.hasMethodParameters() && !m.isLambdaMethod()) {
            acount += this.writeMethodParametersAttr(m);
        }
        acount += this.writeMemberAttrs(m);
        if (!m.isLambdaMethod()) {
            acount += this.writeParameterAttrs(m);
        }
        this.endAttrs(acountIdx, acount);
    }

    void writeCode(Code code) {
        int i;
        int alenIdx;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List<Object> l = code.catchInfo.toList();
        while (l.nonEmpty()) {
            for (int i2 = 0; i2 < ((char[])l.head).length; ++i2) {
                this.databuf.appendChar(((char[])l.head)[i2]);
            }
            l = l.tail;
        }
        int acountIdx = this.beginAttrs();
        int acount = 0;
        if (code.lineInfo.nonEmpty()) {
            alenIdx = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List<Object> l2 = code.lineInfo.reverse();
            while (l2.nonEmpty()) {
                for (i = 0; i < ((char[])l2.head).length; ++i) {
                    this.databuf.appendChar(((char[])l2.head)[i]);
                }
                l2 = l2.tail;
            }
            this.endAttr(alenIdx);
            ++acount;
        }
        if (this.genCrt && code.crt != null) {
            CRTable crt = code.crt;
            int alenIdx2 = this.writeAttr(this.names.CharacterRangeTable);
            int crtIdx = this.beginAttrs();
            int crtEntries = crt.writeCRT(this.databuf, code.lineMap, this.log);
            this.endAttrs(crtIdx, crtEntries);
            this.endAttr(alenIdx2);
            ++acount;
        }
        if (code.varDebugInfo && code.varBufferSize > 0) {
            int nGenericVars = 0;
            int alenIdx3 = this.writeAttr(this.names.LocalVariableTable);
            this.databuf.appendChar(code.getLVTSize());
            for (i = 0; i < code.varBufferSize; ++i) {
                Code.LocalVar var = code.varBuffer[i];
                for (Code.LocalVar.Range r : var.aliveRanges) {
                    Assert.check(r.start_pc >= '\u0000' && r.start_pc <= code.cp);
                    this.databuf.appendChar(r.start_pc);
                    Assert.check(r.length > '\u0000' && r.start_pc + r.length <= code.cp);
                    this.databuf.appendChar(r.length);
                    Symbol.VarSymbol sym = var.sym;
                    this.databuf.appendChar(this.pool.put(sym.name));
                    Type vartype = sym.erasure(this.types);
                    this.databuf.appendChar(this.pool.put(this.typeSig(vartype)));
                    this.databuf.appendChar(var.reg);
                    if (!this.needsLocalVariableTypeEntry(var.sym.type)) continue;
                    ++nGenericVars;
                }
            }
            this.endAttr(alenIdx3);
            ++acount;
            if (nGenericVars > 0) {
                alenIdx3 = this.writeAttr(this.names.LocalVariableTypeTable);
                this.databuf.appendChar(nGenericVars);
                int count = 0;
                for (int i3 = 0; i3 < code.varBufferSize; ++i3) {
                    Code.LocalVar var = code.varBuffer[i3];
                    Symbol.VarSymbol sym = var.sym;
                    if (!this.needsLocalVariableTypeEntry(sym.type)) continue;
                    for (Code.LocalVar.Range r : var.aliveRanges) {
                        this.databuf.appendChar(r.start_pc);
                        this.databuf.appendChar(r.length);
                        this.databuf.appendChar(this.pool.put(sym.name));
                        this.databuf.appendChar(this.pool.put(this.typeSig(sym.type)));
                        this.databuf.appendChar(var.reg);
                        ++count;
                    }
                }
                Assert.check(count == nGenericVars);
                this.endAttr(alenIdx3);
                ++acount;
            }
        }
        if (code.stackMapBufferSize > 0) {
            if (this.debugstackmap) {
                System.out.println("Stack map for " + code.meth);
            }
            alenIdx = this.writeAttr(code.stackMap.getAttributeName(this.names));
            this.writeStackMap(code);
            this.endAttr(alenIdx);
            ++acount;
        }
        this.endAttrs(acountIdx, acount += this.writeTypeAnnotations(code.meth.getRawTypeAttributes(), true));
    }

    private boolean needsLocalVariableTypeEntry(Type t) {
        return !this.types.isSameType(t, this.types.erasure(t)) && this.check.checkDenotable(t);
    }

    void writeStackMap(Code code) {
        int nframes = code.stackMapBufferSize;
        if (this.debugstackmap) {
            System.out.println(" nframes = " + nframes);
        }
        this.databuf.appendChar(nframes);
        switch (code.stackMap) {
            case CLDC: {
                for (int i = 0; i < nframes; ++i) {
                    int j;
                    int j2;
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    Code.StackMapFrame frame = code.stackMapBuffer[i];
                    if (this.debugstackmap) {
                        System.out.print(" pc=" + frame.pc);
                    }
                    this.databuf.appendChar(frame.pc);
                    int localCount = 0;
                    for (j2 = 0; j2 < frame.locals.length; j2 += Code.width(frame.locals[j2])) {
                        ++localCount;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nlocals=" + localCount);
                    }
                    this.databuf.appendChar(localCount);
                    for (j2 = 0; j2 < frame.locals.length; j2 += Code.width(frame.locals[j2])) {
                        if (this.debugstackmap) {
                            System.out.print(" local[" + j2 + "]=");
                        }
                        this.writeStackMapType(frame.locals[j2]);
                    }
                    int stackCount = 0;
                    for (j = 0; j < frame.stack.length; j += Code.width(frame.stack[j])) {
                        ++stackCount;
                    }
                    if (this.debugstackmap) {
                        System.out.print(" nstack=" + stackCount);
                    }
                    this.databuf.appendChar(stackCount);
                    for (j = 0; j < frame.stack.length; j += Code.width(frame.stack[j])) {
                        if (this.debugstackmap) {
                            System.out.print(" stack[" + j + "]=");
                        }
                        this.writeStackMapType(frame.stack[j]);
                    }
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            case JSR202: {
                Assert.checkNull(code.stackMapBuffer);
                for (int i = 0; i < nframes; ++i) {
                    if (this.debugstackmap) {
                        System.out.print("  " + i + ":");
                    }
                    StackMapTableFrame frame = code.stackMapTableBuffer[i];
                    frame.write(this);
                    if (!this.debugstackmap) continue;
                    System.out.println();
                }
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected stackmap format value");
            }
        }
    }

    void writeStackMapType(Type t) {
        if (t == null) {
            if (this.debugstackmap) {
                System.out.print("empty");
            }
            this.databuf.appendByte(0);
        } else {
            switch (t.getTag()) {
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case INT: 
                case BOOLEAN: {
                    if (this.debugstackmap) {
                        System.out.print("int");
                    }
                    this.databuf.appendByte(1);
                    break;
                }
                case FLOAT: {
                    if (this.debugstackmap) {
                        System.out.print("float");
                    }
                    this.databuf.appendByte(2);
                    break;
                }
                case DOUBLE: {
                    if (this.debugstackmap) {
                        System.out.print("double");
                    }
                    this.databuf.appendByte(3);
                    break;
                }
                case LONG: {
                    if (this.debugstackmap) {
                        System.out.print("long");
                    }
                    this.databuf.appendByte(4);
                    break;
                }
                case BOT: {
                    if (this.debugstackmap) {
                        System.out.print("null");
                    }
                    this.databuf.appendByte(5);
                    break;
                }
                case CLASS: 
                case ARRAY: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + t + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(t));
                    break;
                }
                case TYPEVAR: {
                    if (this.debugstackmap) {
                        System.out.print("object(" + this.types.erasure((Type)t).tsym + ")");
                    }
                    this.databuf.appendByte(7);
                    this.databuf.appendChar(this.pool.put(this.types.erasure((Type)t).tsym));
                    break;
                }
                case UNINITIALIZED_THIS: {
                    if (this.debugstackmap) {
                        System.out.print("uninit_this");
                    }
                    this.databuf.appendByte(6);
                    break;
                }
                case UNINITIALIZED_OBJECT: {
                    UninitializedType uninitType = (UninitializedType)t;
                    this.databuf.appendByte(8);
                    if (this.debugstackmap) {
                        System.out.print("uninit_object@" + uninitType.offset);
                    }
                    this.databuf.appendChar(uninitType.offset);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    void writeFields(Scope s) {
        List<Symbol.VarSymbol> vars = List.nil();
        for (Symbol sym : s.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (sym.kind != Kinds.Kind.VAR) continue;
            vars = vars.prepend((Symbol.VarSymbol)sym);
        }
        while (vars.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)vars.head);
            vars = vars.tail;
        }
    }

    void writeMethods(Scope s) {
        List<Symbol.MethodSymbol> methods = List.nil();
        for (Symbol sym : s.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            if (sym.kind != Kinds.Kind.MTH || (sym.flags() & 0x2000000000L) != 0L) continue;
            methods = methods.prepend((Symbol.MethodSymbol)sym);
        }
        while (methods.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)methods.head);
            methods = methods.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaFileObject writeClass(Symbol.ClassSymbol c) throws IOException, PoolOverflow, StringOverflow {
        JavaFileManager.Location outLocn;
        String name = (c.owner.kind == Kinds.Kind.MDL ? c.name : c.flatname).toString();
        if (this.multiModuleMode) {
            Symbol.ModuleSymbol msym = c.owner.kind == Kinds.Kind.MDL ? (Symbol.ModuleSymbol)c.owner : c.packge().modle;
            outLocn = this.fileManager.getLocationForModule((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, msym.name.toString());
        } else {
            outLocn = StandardLocation.CLASS_OUTPUT;
        }
        JavaFileObject outFile = this.fileManager.getJavaFileForOutput(outLocn, name, JavaFileObject.Kind.CLASS, c.sourcefile);
        OutputStream out = outFile.openOutputStream();
        try {
            this.writeClassFile(out, c);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile.getName());
            }
            out.close();
            out = null;
        }
        catch (Types.SignatureGenerator.InvalidSignatureException ex) {
            this.log.error(CompilerProperties.Errors.CannotGenerateClass(c, CompilerProperties.Fragments.IllegalSignature(c, ex.type())));
        }
        finally {
            if (out != null) {
                out.close();
                outFile.delete();
                outFile = null;
            }
        }
        return outFile;
    }

    public void writeClassFile(OutputStream out, Symbol.ClassSymbol c) throws IOException, PoolOverflow, StringOverflow {
        int flags;
        Assert.check((c.flags() & 0x1000000L) == 0L);
        this.databuf.reset();
        this.poolbuf.reset();
        this.signatureGen.reset();
        this.pool = c.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        this.bootstrapMethods = new LinkedHashMap<Pool.DynamicMethod.BootstrapMethodsKey, Pool.DynamicMethod.BootstrapMethodsValue>();
        Type supertype = this.types.supertype(c.type);
        List<Type> interfaces = this.types.interfaces(c.type);
        List<Type> typarams = c.type.getTypeArguments();
        if (c.owner.kind == Kinds.Kind.MDL) {
            flags = 32768;
        } else {
            flags = this.adjustFlags(c.flags() & 0xFFFFF7FFFFFFFFFFL);
            if ((flags & 4) != 0) {
                flags |= 1;
            }
            if (((flags = flags & 0x7E11 & 0xFFFFF7FF) & 0x200) == 0) {
                flags |= 0x20;
            }
        }
        if (this.dumpClassModifiers) {
            PrintWriter pw = this.log.getWriter(Log.WriterKind.ERROR);
            pw.println();
            pw.println("CLASSFILE  " + c.getQualifiedName());
            pw.println("---" + ClassWriter.flagNames(flags));
        }
        this.databuf.appendChar(flags);
        if (c.owner.kind == Kinds.Kind.MDL) {
            Symbol.PackageSymbol unnamed = ((Symbol.ModuleSymbol)c.owner).unnamedPackage;
            this.databuf.appendChar(this.pool.put(new Symbol.ClassSymbol(0L, this.names.module_info, unnamed)));
        } else {
            this.databuf.appendChar(this.pool.put(c));
        }
        this.databuf.appendChar(supertype.hasTag(TypeTag.CLASS) ? this.pool.put(supertype.tsym) : 0);
        this.databuf.appendChar(interfaces.length());
        List<Type> l = interfaces;
        while (l.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)l.head).tsym));
            l = l.tail;
        }
        int fieldsCount = 0;
        int methodsCount = 0;
        block6: for (Symbol sym : c.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            switch (sym.kind) {
                case VAR: {
                    ++fieldsCount;
                    continue block6;
                }
                case MTH: {
                    if ((sym.flags() & 0x2000000000L) != 0L) continue block6;
                    ++methodsCount;
                    continue block6;
                }
                case TYP: {
                    this.enterInner((Symbol.ClassSymbol)sym);
                    continue block6;
                }
            }
            Assert.error();
        }
        if (c.trans_local != null) {
            for (Symbol.ClassSymbol local : c.trans_local) {
                this.enterInner(local);
            }
        }
        this.databuf.appendChar(fieldsCount);
        this.writeFields(c.members());
        this.databuf.appendChar(methodsCount);
        this.writeMethods(c.members());
        int acountIdx = this.beginAttrs();
        int acount = 0;
        boolean sigReq = typarams.length() != 0 || supertype.allparams().length() != 0;
        List<Type> l2 = interfaces;
        while (!sigReq && l2.nonEmpty()) {
            sigReq = ((Type)l2.head).allparams().length() != 0;
            l2 = l2.tail;
        }
        if (sigReq) {
            int alenIdx = this.writeAttr(this.names.Signature);
            if (typarams.length() != 0) {
                this.signatureGen.assembleParamsSig(typarams);
            }
            this.signatureGen.assembleSig(supertype);
            List<Type> l3 = interfaces;
            while (l3.nonEmpty()) {
                this.signatureGen.assembleSig((Type)l3.head);
                l3 = l3.tail;
            }
            this.databuf.appendChar(this.pool.put(this.signatureGen.toName()));
            this.signatureGen.reset();
            this.endAttr(alenIdx);
            ++acount;
        }
        if (c.sourcefile != null && this.emitSourceFile) {
            int alenIdx = this.writeAttr(this.names.SourceFile);
            String simpleName = PathFileObject.getSimpleName(c.sourcefile);
            this.databuf.appendChar(c.pool.put(this.names.fromString(simpleName)));
            this.endAttr(alenIdx);
            ++acount;
        }
        if (this.genCrt) {
            int alenIdx = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(c.pool.put(this.names.fromString(Long.toString(this.getLastModified(c.sourcefile)))));
            this.endAttr(alenIdx);
            ++acount;
            alenIdx = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(c.pool.put(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(alenIdx);
            ++acount;
        }
        acount += this.writeFlagAttrs(c.flags());
        acount += this.writeJavaAnnotations(c.getRawAttributes());
        acount += this.writeTypeAnnotations(c.getRawTypeAttributes(), false);
        acount += this.writeEnclosingMethodAttribute(c);
        if (c.owner.kind == Kinds.Kind.MDL) {
            acount += this.writeModuleAttribute(c);
            acount += this.writeFlagAttrs(c.owner.flags() & 0xFFFFFFFFFFFDFFFFL);
        }
        acount += this.writeExtraClassAttributes(c);
        this.poolbuf.appendInt(-889275714);
        if (this.preview.isEnabled()) {
            this.poolbuf.appendChar(65535);
        } else {
            this.poolbuf.appendChar(this.target.minorVersion);
        }
        this.poolbuf.appendChar(this.target.majorVersion);
        if (c.owner.kind != Kinds.Kind.MDL && this.target.hasNestmateAccess()) {
            acount += this.writeNestMembersIfNeeded(c);
            acount += this.writeNestHostIfNeeded(c);
        }
        this.writePool(c.pool);
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++acount;
        }
        if (!this.bootstrapMethods.isEmpty()) {
            this.writeBootstrapMethods();
            ++acount;
        }
        this.endAttrs(acountIdx, acount);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        out.write(this.poolbuf.elems, 0, this.poolbuf.length);
        c.pool = null;
        this.pool = null;
    }

    protected int writeExtraClassAttributes(Symbol.ClassSymbol c) {
        return 0;
    }

    int adjustFlags(long flags) {
        int result = (int)flags;
        if ((flags & 0x80000000L) != 0L) {
            result |= 0x40;
        }
        if ((flags & 0x400000000L) != 0L) {
            result |= 0x80;
        }
        if ((flags & 0x80000000000L) != 0L) {
            result &= 0xFFFFFBFF;
        }
        return result;
    }

    long getLastModified(FileObject filename) {
        long mod = 0L;
        try {
            mod = filename.getLastModified();
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + e.getMessage()));
        }
        return mod;
    }

    static abstract class StackMapTableFrame {
        StackMapTableFrame() {
        }

        abstract int getFrameType();

        void write(ClassWriter writer) {
            int frameType = this.getFrameType();
            writer.databuf.appendByte(frameType);
            if (writer.debugstackmap) {
                System.out.print(" frame_type=" + frameType);
            }
        }

        static StackMapTableFrame getInstance(Code.StackMapFrame this_frame, int prev_pc, Type[] prev_locals, Types types) {
            Type[] locals = this_frame.locals;
            Type[] stack = this_frame.stack;
            int offset_delta = this_frame.pc - prev_pc - 1;
            if (stack.length == 1) {
                if (locals.length == prev_locals.length && StackMapTableFrame.compare(prev_locals, locals, types) == 0) {
                    return new SameLocals1StackItemFrame(offset_delta, stack[0]);
                }
            } else if (stack.length == 0) {
                int diff_length = StackMapTableFrame.compare(prev_locals, locals, types);
                if (diff_length == 0) {
                    return new SameFrame(offset_delta);
                }
                if (-4 < diff_length && diff_length < 0) {
                    Type[] local_diff = new Type[-diff_length];
                    int i = prev_locals.length;
                    int j = 0;
                    while (i < locals.length) {
                        local_diff[j] = locals[i];
                        ++i;
                        ++j;
                    }
                    return new AppendFrame(251 - diff_length, offset_delta, local_diff);
                }
                if (0 < diff_length && diff_length < 4) {
                    return new ChopFrame(251 - diff_length, offset_delta);
                }
            }
            return new FullFrame(offset_delta, locals, stack);
        }

        static boolean isInt(Type t) {
            return t.getTag().isStrictSubRangeOf(TypeTag.INT) || t.hasTag(TypeTag.BOOLEAN);
        }

        static boolean isSameType(Type t1, Type t2, Types types) {
            if (t1 == null) {
                return t2 == null;
            }
            if (t2 == null) {
                return false;
            }
            if (StackMapTableFrame.isInt(t1) && StackMapTableFrame.isInt(t2)) {
                return true;
            }
            if (t1.hasTag(TypeTag.UNINITIALIZED_THIS)) {
                return t2.hasTag(TypeTag.UNINITIALIZED_THIS);
            }
            if (t1.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                if (t2.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                    return ((UninitializedType)t1).offset == ((UninitializedType)t2).offset;
                }
                return false;
            }
            if (t2.hasTag(TypeTag.UNINITIALIZED_THIS) || t2.hasTag(TypeTag.UNINITIALIZED_OBJECT)) {
                return false;
            }
            return types.isSameType(t1, t2);
        }

        static int compare(Type[] arr1, Type[] arr2, Types types) {
            int diff_length = arr1.length - arr2.length;
            if (diff_length > 4 || diff_length < -4) {
                return Integer.MAX_VALUE;
            }
            int len = diff_length > 0 ? arr2.length : arr1.length;
            for (int i = 0; i < len; ++i) {
                if (StackMapTableFrame.isSameType(arr1[i], arr2[i], types)) continue;
                return Integer.MAX_VALUE;
            }
            return diff_length;
        }

        static class FullFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type[] locals;
            final Type[] stack;

            FullFrame(int offsetDelta, Type[] locals, Type[] stack) {
                this.offsetDelta = offsetDelta;
                this.locals = locals;
                this.stack = stack;
            }

            @Override
            int getFrameType() {
                return 255;
            }

            @Override
            void write(ClassWriter writer) {
                int i;
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                writer.databuf.appendChar(this.locals.length);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                    System.out.print(" nlocals=" + this.locals.length);
                }
                for (i = 0; i < this.locals.length; ++i) {
                    if (writer.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    writer.writeStackMapType(this.locals[i]);
                }
                writer.databuf.appendChar(this.stack.length);
                if (writer.debugstackmap) {
                    System.out.print(" nstack=" + this.stack.length);
                }
                for (i = 0; i < this.stack.length; ++i) {
                    if (writer.debugstackmap) {
                        System.out.print(" stack[" + i + "]=");
                    }
                    writer.writeStackMapType(this.stack[i]);
                }
            }
        }

        static class AppendFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;
            final Type[] locals;

            AppendFrame(int frameType, int offsetDelta, Type[] locals) {
                this.frameType = frameType;
                this.offsetDelta = offsetDelta;
                this.locals = locals;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
                for (int i = 0; i < this.locals.length; ++i) {
                    if (writer.debugstackmap) {
                        System.out.print(" locals[" + i + "]=");
                    }
                    writer.writeStackMapType(this.locals[i]);
                }
            }
        }

        static class ChopFrame
        extends StackMapTableFrame {
            final int frameType;
            final int offsetDelta;

            ChopFrame(int frameType, int offsetDelta) {
                this.frameType = frameType;
                this.offsetDelta = offsetDelta;
            }

            @Override
            int getFrameType() {
                return this.frameType;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                writer.databuf.appendChar(this.offsetDelta);
                if (writer.debugstackmap) {
                    System.out.print(" offset_delta=" + this.offsetDelta);
                }
            }
        }

        static class SameLocals1StackItemFrame
        extends StackMapTableFrame {
            final int offsetDelta;
            final Type stack;

            SameLocals1StackItemFrame(int offsetDelta, Type stack) {
                this.offsetDelta = offsetDelta;
                this.stack = stack;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? 64 + this.offsetDelta : 247;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                if (this.getFrameType() == 247) {
                    writer.databuf.appendChar(this.offsetDelta);
                    if (writer.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
                if (writer.debugstackmap) {
                    System.out.print(" stack[0]=");
                }
                writer.writeStackMapType(this.stack);
            }
        }

        static class SameFrame
        extends StackMapTableFrame {
            final int offsetDelta;

            SameFrame(int offsetDelta) {
                this.offsetDelta = offsetDelta;
            }

            @Override
            int getFrameType() {
                return this.offsetDelta < 64 ? this.offsetDelta : 251;
            }

            @Override
            void write(ClassWriter writer) {
                super.write(writer);
                if (this.getFrameType() == 251) {
                    writer.databuf.appendChar(this.offsetDelta);
                    if (writer.debugstackmap) {
                        System.out.print(" offset_delta=" + this.offsetDelta);
                    }
                }
            }
        }
    }

    class AttributeWriter
    implements Attribute.Visitor {
        AttributeWriter() {
        }

        @Override
        public void visitConstant(Attribute.Constant _value) {
            Object value = _value.value;
            switch (_value.type.getTag()) {
                case BYTE: {
                    ClassWriter.this.databuf.appendByte(66);
                    break;
                }
                case CHAR: {
                    ClassWriter.this.databuf.appendByte(67);
                    break;
                }
                case SHORT: {
                    ClassWriter.this.databuf.appendByte(83);
                    break;
                }
                case INT: {
                    ClassWriter.this.databuf.appendByte(73);
                    break;
                }
                case LONG: {
                    ClassWriter.this.databuf.appendByte(74);
                    break;
                }
                case FLOAT: {
                    ClassWriter.this.databuf.appendByte(70);
                    break;
                }
                case DOUBLE: {
                    ClassWriter.this.databuf.appendByte(68);
                    break;
                }
                case BOOLEAN: {
                    ClassWriter.this.databuf.appendByte(90);
                    break;
                }
                case CLASS: {
                    Assert.check(value instanceof String);
                    ClassWriter.this.databuf.appendByte(115);
                    value = ClassWriter.this.names.fromString(value.toString());
                    break;
                }
                default: {
                    throw new AssertionError(_value.type);
                }
            }
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(value));
        }

        @Override
        public void visitEnum(Attribute.Enum e) {
            ClassWriter.this.databuf.appendByte(101);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(e.value.type)));
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(e.value.name));
        }

        @Override
        public void visitClass(Attribute.Class clazz) {
            ClassWriter.this.databuf.appendByte(99);
            ClassWriter.this.databuf.appendChar(ClassWriter.this.pool.put(ClassWriter.this.typeSig(ClassWriter.this.types.erasure(clazz.classType))));
        }

        @Override
        public void visitCompound(Attribute.Compound compound) {
            ClassWriter.this.databuf.appendByte(64);
            ClassWriter.this.writeCompoundAttribute(compound);
        }

        @Override
        public void visitError(Attribute.Error x) {
            throw new AssertionError(x);
        }

        @Override
        public void visitArray(Attribute.Array array) {
            ClassWriter.this.databuf.appendByte(91);
            ClassWriter.this.databuf.appendChar(array.values.length);
            for (Attribute a : array.values) {
                a.accept(this);
            }
        }
    }

    public static class StringOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
        public final String value;

        public StringOverflow(String s) {
            this.value = s;
        }
    }

    public static class PoolOverflow
    extends Exception {
        private static final long serialVersionUID = 0L;
    }

    private class CWSignatureGenerator
    extends Types.SignatureGenerator {
        ByteBuffer sigbuf;

        CWSignatureGenerator(Types types) {
            super(types);
            this.sigbuf = new ByteBuffer();
        }

        @Override
        public void assembleSig(Type type) {
            switch (type.getTag()) {
                case UNINITIALIZED_THIS: 
                case UNINITIALIZED_OBJECT: {
                    this.assembleSig(ClassWriter.this.types.erasure(((UninitializedType)type).qtype));
                    break;
                }
                default: {
                    super.assembleSig(type);
                }
            }
        }

        @Override
        protected void append(char ch) {
            this.sigbuf.appendByte(ch);
        }

        @Override
        protected void append(byte[] ba) {
            this.sigbuf.appendBytes(ba);
        }

        @Override
        protected void append(Name name) {
            this.sigbuf.appendName(name);
        }

        @Override
        protected void classReference(Symbol.ClassSymbol c) {
            ClassWriter.this.enterInner(c);
        }

        private void reset() {
            this.sigbuf.reset();
        }

        private Name toName() {
            return this.sigbuf.toName(ClassWriter.this.names);
        }

        private boolean isEmpty() {
            return this.sigbuf.length == 0;
        }
    }
}

