/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.data_structure;

import blogspot.software_and_algorithms.stern_library.data_structure.Interval;
import blogspot.software_and_algorithms.stern_library.data_structure.RedBlackTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public class DynamicIntervalTree<U extends Comparable<U>, T extends Interval<U>> {
    public RedBlackTree<T> binarySearchTree = new RedBlackTree<T>(new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            int result = ((Interval)o1).getLow().compareTo(((Interval)o2).getLow());
            if (result == 0) {
                result = ((Interval)o1).isClosedOnLow() != ((Interval)o2).isClosedOnLow() ? (((Interval)o1).isClosedOnLow() ? -1 : 1) : ((Interval)o1).compareTo(o2);
            }
            return result;
        }
    }){

        @Override
        protected RedBlackTree.Node<T> createNewNode(T value) {
            return new Node(value);
        }

        @Override
        public RedBlackTree.Node<T> delete(T value) {
            RedBlackTree.Node node = super.delete(value);
            if (node != null && node.getColor() != RedBlackTree.Node.NodeColor.BLACK) {
                for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                    temp.computeSubtreeSpan();
                }
            }
            return node;
        }

        @Override
        protected void fixAfterDeletion(RedBlackTree.Node<T> node) {
            for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                temp.computeSubtreeSpan();
            }
            super.fixAfterDeletion(node);
        }

        @Override
        protected void fixAfterInsertion(RedBlackTree.Node<T> node) {
            for (RedBlackTree.Node temp = (Node)node.getParent(); temp != null; temp = temp.getParent()) {
                temp.computeSubtreeSpan();
            }
            super.fixAfterInsertion(node);
        }

        @Override
        protected void leftRotate(RedBlackTree.Node<T> node) {
            super.leftRotate(node);
            Node temp = (Node)node;
            temp.computeSubtreeSpan();
            ((Node)temp.getParent()).computeSubtreeSpan();
        }

        @Override
        protected void rightRotate(RedBlackTree.Node<T> node) {
            super.rightRotate(node);
            Node temp = (Node)node;
            temp.computeSubtreeSpan();
            ((Node)temp.getParent()).computeSubtreeSpan();
        }
    };

    public void clear() {
        this.binarySearchTree.clear();
    }

    public boolean delete(T interval) {
        return this.binarySearchTree.delete(interval) != null;
    }

    protected T fetchContainingInterval(U queryPoint) {
        RedBlackTree.Node node = (Node)this.binarySearchTree.getRoot();
        while (node != null) {
            int cmp;
            if (((Interval)node.getValue()).contains(queryPoint)) {
                return (T)((Interval)node.getValue());
            }
            RedBlackTree.Node leftChild = node.getLeft();
            node = node.getRight();
            if (leftChild == null || (cmp = ((Node)leftChild).getSubtreeSpanHigh().compareTo(queryPoint)) <= 0 && (cmp != 0 || !((Node)leftChild).isClosedOnSubtreeSpanHigh())) continue;
            node = leftChild;
        }
        return null;
    }

    public Collection<T> fetchContainingIntervals(U queryPoint) {
        if (queryPoint == null) {
            throw new NullPointerException("queryPoint is null");
        }
        ArrayList result = new ArrayList();
        Node node = (Node)this.binarySearchTree.getRoot();
        ArrayList<RedBlackTree.Node> queue = new ArrayList<RedBlackTree.Node>();
        if (node != null) {
            queue.add(node);
        }
        while (!queue.isEmpty()) {
            int cmp;
            RedBlackTree.Node child;
            node = (Node)queue.remove(queue.size() - 1);
            if (((Interval)node.getValue()).contains(queryPoint)) {
                result.add(node.getValue());
            }
            if ((child = node.getLeft()) != null && ((cmp = ((Node)child).getSubtreeSpanHigh().compareTo(queryPoint)) > 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanHigh())) {
                queue.add(child);
            }
            if ((child = node.getRight()) == null || (cmp = ((Node)child).getSubtreeSpanLow().compareTo(queryPoint)) >= 0 && (cmp != 0 || !((Node)child).isClosedOnSubtreeSpanLow())) continue;
            queue.add(child);
        }
        return result;
    }

    protected T fetchOverlappingInterval(T queryInterval) {
        RedBlackTree.Node node = (Node)this.binarySearchTree.getRoot();
        while (node != null) {
            int cmp;
            if (((Interval)node.getValue()).overlaps(queryInterval)) {
                return (T)((Interval)node.getValue());
            }
            RedBlackTree.Node leftChild = node.getLeft();
            node = node.getRight();
            if (leftChild == null || (cmp = ((Node)leftChild).getSubtreeSpanHigh().compareTo(((Interval)queryInterval).getLow())) <= 0 && (cmp != 0 || !((Node)leftChild).isClosedOnSubtreeSpanHigh() || !((Interval)queryInterval).isClosedOnLow())) continue;
            node = leftChild;
        }
        return null;
    }

    public Collection<T> fetchOverlappingIntervals(T queryInterval) {
        if (queryInterval == null) {
            throw new NullPointerException("queryInterval is null");
        }
        ArrayList result = new ArrayList();
        Node node = (Node)this.binarySearchTree.getRoot();
        ArrayList<RedBlackTree.Node> queue = new ArrayList<RedBlackTree.Node>();
        if (node != null) {
            queue.add(node);
        }
        while (!queue.isEmpty()) {
            int cmp;
            RedBlackTree.Node child;
            node = (Node)queue.remove(queue.size() - 1);
            if (((Interval)node.getValue()).overlaps(queryInterval)) {
                result.add(node.getValue());
            }
            if ((child = node.getLeft()) != null && ((cmp = ((Node)child).getSubtreeSpanHigh().compareTo(((Interval)queryInterval).getLow())) > 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanHigh() && ((Interval)queryInterval).isClosedOnLow())) {
                queue.add(child);
            }
            if ((child = node.getRight()) == null || (cmp = ((Node)child).getSubtreeSpanLow().compareTo(((Interval)queryInterval).getHigh())) >= 0 && (cmp != 0 || !((Node)child).isClosedOnSubtreeSpanLow() || !((Interval)queryInterval).isClosedOnHigh())) continue;
            queue.add(child);
        }
        return result;
    }

    public int getSize() {
        return this.binarySearchTree.getSize();
    }

    public boolean insert(T interval) {
        return this.binarySearchTree.insert(interval) != null;
    }

    protected static class Node<U extends Comparable<U>, T extends Interval<U>>
    extends RedBlackTree.Node<T> {
        private U subtreeSpanLow;
        private U subtreeSpanHigh;
        private boolean isClosedOnSubtreeSpanLow;
        private boolean isClosedOnSubtreeSpanHigh;

        public Node(T interval) {
            super(interval);
            this.subtreeSpanLow = ((Interval)interval).getLow();
            this.subtreeSpanHigh = ((Interval)interval).getHigh();
            this.isClosedOnSubtreeSpanLow = ((Interval)interval).isClosedOnLow();
            this.isClosedOnSubtreeSpanHigh = ((Interval)interval).isClosedOnHigh();
        }

        protected void computeSubtreeSpan() {
            int cmp;
            Object subtreeSpanLow = ((Interval)this.getValue()).getLow();
            Object subtreeSpanHigh = ((Interval)this.getValue()).getHigh();
            boolean isClosedOnSubtreeSpanLow = ((Interval)this.getValue()).isClosedOnLow();
            boolean isClosedOnSubtreeSpanHigh = ((Interval)this.getValue()).isClosedOnHigh();
            RedBlackTree.Node child = this.getLeft();
            if (child != null) {
                cmp = ((Node)child).subtreeSpanLow.compareTo(subtreeSpanLow);
                if (cmp < 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanLow) {
                    subtreeSpanLow = ((Node)child).subtreeSpanLow;
                    isClosedOnSubtreeSpanLow = ((Node)child).isClosedOnSubtreeSpanLow;
                }
                if ((cmp = ((Node)child).subtreeSpanHigh.compareTo(subtreeSpanHigh)) > 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanHigh) {
                    subtreeSpanHigh = ((Node)child).subtreeSpanHigh;
                    isClosedOnSubtreeSpanHigh = ((Node)child).isClosedOnSubtreeSpanHigh;
                }
            }
            if ((child = this.getRight()) != null) {
                cmp = ((Node)child).subtreeSpanLow.compareTo(subtreeSpanLow);
                if (cmp < 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanLow) {
                    subtreeSpanLow = ((Node)child).subtreeSpanLow;
                    isClosedOnSubtreeSpanLow = ((Node)child).isClosedOnSubtreeSpanLow;
                }
                if ((cmp = ((Node)child).subtreeSpanHigh.compareTo(subtreeSpanHigh)) > 0 || cmp == 0 && ((Node)child).isClosedOnSubtreeSpanHigh) {
                    subtreeSpanHigh = ((Node)child).subtreeSpanHigh;
                    isClosedOnSubtreeSpanHigh = ((Node)child).isClosedOnSubtreeSpanHigh;
                }
            }
            this.subtreeSpanLow = subtreeSpanLow;
            this.isClosedOnSubtreeSpanLow = isClosedOnSubtreeSpanLow;
            this.subtreeSpanHigh = subtreeSpanHigh;
            this.isClosedOnSubtreeSpanHigh = isClosedOnSubtreeSpanHigh;
        }

        public Node<U, T> getLeft() {
            return (Node)super.getLeft();
        }

        public Node<U, T> getParent() {
            return (Node)super.getParent();
        }

        public Node<U, T> getRight() {
            return (Node)super.getRight();
        }

        public U getSubtreeSpanHigh() {
            return this.subtreeSpanHigh;
        }

        public U getSubtreeSpanLow() {
            return this.subtreeSpanLow;
        }

        public boolean isClosedOnSubtreeSpanHigh() {
            return this.isClosedOnSubtreeSpanHigh;
        }

        public boolean isClosedOnSubtreeSpanLow() {
            return this.isClosedOnSubtreeSpanLow;
        }
    }
}

