/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.IsSubtypeOf;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.type.DescendantOfAny;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@BugPattern(name="ModifiedButNotUsed", summary="A collection or proto builder was created, but its values were never accessed.", category=BugPattern.Category.JDK, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, severity=BugPattern.SeverityLevel.WARNING)
public class ModifiedButNotUsed
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> GUAVA_IMMUTABLES = ImmutableSet.of((Object)"com.google.common.collect.ImmutableCollection", (Object)"com.google.common.collect.ImmutableMap", (Object)"com.google.common.collect.ImmutableMultimap");
    private static final ImmutableSet<String> COLLECTIONS = (ImmutableSet)Streams.concat((Stream[])new Stream[]{GUAVA_IMMUTABLES.stream().map(i -> i + ".Builder"), Stream.of("java.util.Collection", "java.util.Map", "com.google.common.collect.Multimap")}).collect(ImmutableSet.toImmutableSet());
    private static final Matcher<ExpressionTree> COLLECTION_SETTER = MethodMatchers.instanceMethod().onDescendantOfAny(COLLECTIONS).withNameMatching(Pattern.compile("add|addAll|clear|put|putAll|remove|removeAll|removeIf|replaceAll|retainAll|set|sort"));
    private static final ImmutableSet<String> PROTO_CLASSES = ImmutableSet.of((Object)"com.google.protobuf.GeneratedMessage", (Object)"com.google.protobuf.GeneratedMessageLite");
    private static final Matcher<ExpressionTree> FLUENT_SETTER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOfAny((Iterable)PROTO_CLASSES.stream().map(p -> p + ".Builder").collect(ImmutableList.toImmutableList())).withNameMatching(Pattern.compile("(add|set|clear|remove|merge).+")), MethodMatchers.instanceMethod().onDescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(c -> c + ".Builder").collect(ImmutableSet.toImmutableSet())).withNameMatching(Pattern.compile("(add|put)(All)?"))});
    private static final Matcher<Tree> COLLECTION_TYPE = Matchers.anyOf((Iterable)((Iterable)COLLECTIONS.stream().map(IsSubtypeOf::new).collect(ImmutableList.toImmutableList())));
    private static final Matcher<Tree> PROTO_TYPE = Matchers.anyOf((Iterable)((Iterable)PROTO_CLASSES.stream().map(p -> new IsSubtypeOf(p + ".Builder")).collect(ImmutableList.toImmutableList())));
    private static final Matcher<ExpressionTree> FLUENT_CONSTRUCTOR = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(i -> Suppliers.typeFromString((String)(i + ".Builder"))).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)GUAVA_IMMUTABLES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).withNameMatching(Pattern.compile("builder(WithExpectedSize)?")), MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(c -> Suppliers.typeFromString((String)(c + ".Builder"))).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).named("newBuilder"), MethodMatchers.instanceMethod().onClass((TypePredicate)new DescendantOfAny((Iterable)PROTO_CLASSES.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))).withNameMatching(Pattern.compile("toBuilder|newBuilderForType"))});
    private static final Matcher<ExpressionTree> NEW_COLLECTION = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.constructor().forClass((TypePredicate)new DescendantOfAny((Iterable)COLLECTIONS.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClassAny(new String[]{"com.google.common.collect.Lists", "com.google.common.collect.Maps", "com.google.common.collect.Sets"}).withNameMatching(Pattern.compile("new.+"))});

    private static boolean newFluentChain(ExpressionTree tree, VisitorState state) {
        while (tree instanceof MethodInvocationTree && FLUENT_SETTER.matches((Tree)tree, state)) {
            tree = ASTHelpers.getReceiver((ExpressionTree)tree);
        }
        return FLUENT_CONSTRUCTOR.matches((Tree)tree, state);
    }

    private static boolean collectionUsed(VisitorState state) {
        TreePath path = state.getPath();
        return !(path.getParentPath().getLeaf() instanceof MemberSelectTree) || !(path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree) || !COLLECTION_SETTER.matches((Tree)((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf()), state) || ASTHelpers.targetType((VisitorState)state.withPath(path.getParentPath().getParentPath())) != null;
    }

    private static boolean fluentUsed(VisitorState state) {
        TreePath path = state.getPath();
        while (path != null) {
            if (path.getParentPath().getLeaf() instanceof ExpressionStatementTree) {
                return false;
            }
            if (!(path.getParentPath().getLeaf() instanceof MemberSelectTree) || !(path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree) || !FLUENT_SETTER.matches((Tree)((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf()), state)) break;
            path = path.getParentPath().getParentPath();
        }
        return true;
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol((VariableTree)tree);
        if (!ModifiedButNotUsed.effectivelyFinal(symbol)) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf() instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        if (!COLLECTION_TYPE.matches((Tree)tree, state) && !PROTO_TYPE.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final ArrayList<ExpressionTree> initializers = new ArrayList<ExpressionTree>();
        if (tree.getInitializer() == null) {
            new TreeScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void aVoid) {
                    if (symbol.equals(ASTHelpers.getSymbol((Tree)node.getVariable()))) {
                        initializers.add(node.getExpression());
                    }
                    return (Void)super.visitAssignment(node, aVoid);
                }
            }.scan(state.getPath().getParentPath().getLeaf(), null);
        } else {
            initializers.add(tree.getInitializer());
        }
        initializers.removeIf(i -> !NEW_COLLECTION.matches((Tree)i, state) && !ModifiedButNotUsed.newFluentChain(i, state));
        if (initializers.isEmpty()) {
            return Description.NO_MATCH;
        }
        UnusedScanner isUnusedScanner = new UnusedScanner(symbol, state, ModifiedButNotUsed.getMatcher(tree, state));
        isUnusedScanner.scan(state.getPath().getParentPath(), null);
        return isUnusedScanner.isUnused ? this.describeMatch((Tree)initializers.get(0)) : Description.NO_MATCH;
    }

    private static Matcher<IdentifierTree> getMatcher(Tree tree, VisitorState state) {
        return COLLECTION_TYPE.matches(tree, state) ? (Matcher & Serializable)(t, s) -> ModifiedButNotUsed.collectionUsed(s) : (Matcher & Serializable)(t, s) -> ModifiedButNotUsed.fluentUsed(s);
    }

    private static boolean effectivelyFinal(Symbol symbol) {
        return (symbol.flags() & 0x20000000010L) != 0L;
    }

    private static class UnusedScanner
    extends TreePathScanner<Void, Void> {
        private final Symbol symbol;
        private final VisitorState state;
        private final Matcher<IdentifierTree> matcher;
        private boolean isUnused = true;

        private UnusedScanner(Symbol symbol, VisitorState state, Matcher<IdentifierTree> matcher) {
            this.symbol = symbol;
            this.state = state;
            this.matcher = matcher;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void aVoid) {
            if (!Objects.equals(ASTHelpers.getSymbol((Tree)identifierTree), this.symbol)) {
                return null;
            }
            if (this.matcher.matches((Tree)identifierTree, this.state.withPath(this.getCurrentPath()))) {
                this.isUnused = false;
                return null;
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void aVoid) {
            if (Objects.equals(ASTHelpers.getSymbol((VariableTree)variableTree), this.symbol)) {
                return null;
            }
            return (Void)super.visitVariable(variableTree, aVoid);
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, Void aVoid) {
            if (Objects.equals(ASTHelpers.getSymbol((Tree)assignmentTree.getVariable()), this.symbol)) {
                return (Void)this.scan(assignmentTree.getExpression(), aVoid);
            }
            return (Void)super.visitAssignment(assignmentTree, aVoid);
        }
    }
}

