/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.util.ArrayList;

public class AssetUtil {
    public static Rectangle scaleRectangle(Rectangle rect, float scaleFactor) {
        return new Rectangle(Math.round((float)rect.x * scaleFactor), Math.round((float)rect.y * scaleFactor), Math.round((float)rect.width * scaleFactor), Math.round((float)rect.height * scaleFactor));
    }

    public static BufferedImage newArgbBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage scaledImage(BufferedImage source, int width, int height) {
        Image scaledImage = source.getScaledInstance(width, height, 4);
        BufferedImage scaledBufImage = new BufferedImage(width, height, 2);
        Graphics2D g = scaledBufImage.createGraphics();
        g.drawImage(scaledImage, 0, 0, null);
        g.dispose();
        return scaledBufImage;
    }

    public static BufferedImage blurredImage(BufferedImage source, double radius) {
        if (radius == 0.0) {
            return source;
        }
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        float[] kernelData = new float[rows * rows];
        double sigma = radius / 3.0;
        double sigma22 = 2.0 * sigma * sigma;
        double sqrtPiSigma22 = Math.sqrt(Math.PI * sigma22);
        double radius2 = radius * radius;
        double total = 0.0;
        int index = 0;
        for (int y = -r; y <= r; ++y) {
            for (int x = -r; x <= r; ++x) {
                double distance2 = 1.0 * (double)x * (double)x + 1.0 * (double)y * (double)y;
                kernelData[index] = distance2 > radius2 ? 0.0f : (float)(Math.exp(-distance2 / sigma22) / sqrtPiSigma22);
                total += (double)kernelData[index];
                ++index;
            }
        }
        index = 0;
        while (index < kernelData.length) {
            int n = index++;
            kernelData[n] = (float)((double)kernelData[n] / total);
        }
        BufferedImage paddedSource = AssetUtil.paddedImage(source, r);
        BufferedImage blurredPaddedImage = AssetUtil.operatedImage(paddedSource, new ConvolveOp(new Kernel(rows, rows, kernelData), 0, null));
        return blurredPaddedImage.getSubimage(r, r, source.getWidth(), source.getHeight());
    }

    public static BufferedImage invertedAlphaImage(BufferedImage source) {
        float[] scaleFactors = new float[]{1.0f, 1.0f, 1.0f, -1.0f};
        float[] offsets = new float[]{0.0f, 0.0f, 0.0f, 255.0f};
        return AssetUtil.operatedImage(source, new RescaleOp(scaleFactors, offsets, null));
    }

    public static BufferedImage operatedImage(BufferedImage source, BufferedImageOp op) {
        BufferedImage newImage = AssetUtil.newArgbBufferedImage(source.getWidth(), source.getHeight());
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage(source, op, 0, 0);
        return newImage;
    }

    public static BufferedImage filledImage(BufferedImage source, Paint paint) {
        BufferedImage newImage = AssetUtil.newArgbBufferedImage(source.getWidth(), source.getHeight());
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage((Image)source, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setPaint(paint);
        g.fillRect(0, 0, source.getWidth(), source.getHeight());
        return newImage;
    }

    public static BufferedImage paddedImage(BufferedImage source, int padding) {
        if (padding == 0) {
            return source;
        }
        BufferedImage newImage = AssetUtil.newArgbBufferedImage(source.getWidth() + padding * 2, source.getHeight() + padding * 2);
        Graphics2D g = (Graphics2D)newImage.getGraphics();
        g.drawImage((Image)source, padding, padding, null);
        return newImage;
    }

    public static BufferedImage trimmedImage(BufferedImage source) {
        boolean minAlpha = true;
        int srcWidth = source.getWidth();
        int srcHeight = source.getHeight();
        WritableRaster raster = source.getRaster();
        int l = srcWidth;
        int t = srcHeight;
        int r = 0;
        int b = 0;
        int[] pixel = new int[4];
        for (int y = 0; y < srcHeight; ++y) {
            for (int x = 0; x < srcWidth; ++x) {
                raster.getPixel(x, y, pixel);
                int alpha = pixel[3];
                if (alpha < 1) continue;
                l = Math.min(x, l);
                t = Math.min(y, t);
                r = Math.max(x, r);
                b = Math.max(y, b);
            }
        }
        if (l > r || t > b) {
            return source;
        }
        return source.getSubimage(l, t, r - l + 1, b - t + 1);
    }

    public static void drawEffects(Graphics2D g, BufferedImage source, int x, int y, Effect[] effects) {
        ArrayList<ShadowEffect> shadowEffects = new ArrayList<ShadowEffect>();
        ArrayList<FillEffect> fillEffects = new ArrayList<FillEffect>();
        for (Effect effect : effects) {
            if (effect instanceof ShadowEffect) {
                shadowEffects.add((ShadowEffect)effect);
                continue;
            }
            if (!(effect instanceof FillEffect)) continue;
            fillEffects.add((FillEffect)effect);
        }
        Composite oldComposite = g.getComposite();
        for (ShadowEffect effect : shadowEffects) {
            if (effect.inner) continue;
            g.setComposite(AlphaComposite.getInstance(3, (float)effect.opacity));
            g.drawImage((Image)AssetUtil.filledImage(AssetUtil.blurredImage(source, effect.radius), effect.color), (int)effect.xOffset, (int)effect.yOffset, null);
        }
        g.setComposite(oldComposite);
        Rectangle imageRect = new Rectangle(0, 0, source.getWidth(), source.getHeight());
        BufferedImage out = AssetUtil.newArgbBufferedImage(imageRect.width, imageRect.height);
        Graphics2D g2 = (Graphics2D)out.getGraphics();
        double fillOpacity = 1.0;
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.drawImage((Image)source, 0, 0, null);
        g2.setComposite(AlphaComposite.SrcAtop);
        for (FillEffect fillEffect : fillEffects) {
            g2.setPaint(fillEffect.paint);
            g2.fillRect(0, 0, imageRect.width, imageRect.height);
            fillOpacity = Math.max(0.0, Math.min(1.0, fillEffect.opacity));
        }
        for (ShadowEffect shadowEffect : shadowEffects) {
            if (!shadowEffect.inner) continue;
            BufferedImage innerShadowImage = AssetUtil.newArgbBufferedImage(imageRect.width, imageRect.height);
            Graphics2D g3 = (Graphics2D)innerShadowImage.getGraphics();
            g3.drawImage((Image)source, (int)shadowEffect.xOffset, (int)shadowEffect.yOffset, null);
            g2.setComposite(AlphaComposite.getInstance(10, (float)shadowEffect.opacity));
            g2.drawImage((Image)AssetUtil.filledImage(AssetUtil.blurredImage(AssetUtil.invertedAlphaImage(innerShadowImage), shadowEffect.radius), shadowEffect.color), 0, 0, null);
        }
        g.setComposite(AlphaComposite.getInstance(3, (float)fillOpacity));
        g.drawImage((Image)out, x, y, null);
        g.setComposite(oldComposite);
    }

    public static void drawCenterInside(Graphics2D g, BufferedImage source, Rectangle dstRect) {
        int srcHeight;
        int srcWidth = source.getWidth();
        if ((double)srcWidth * 1.0 / (double)(srcHeight = source.getHeight()) > (double)dstRect.width * 1.0 / (double)dstRect.height) {
            int scaledWidth = Math.max(1, dstRect.width);
            int scaledHeight = Math.max(1, dstRect.width * srcHeight / srcWidth);
            BufferedImage scaledImage = AssetUtil.scaledImage(source, scaledWidth, scaledHeight);
            g.drawImage(scaledImage, dstRect.x, dstRect.y + (dstRect.height - scaledHeight) / 2, dstRect.x + dstRect.width, dstRect.y + (dstRect.height - scaledHeight) / 2 + scaledHeight, 0, 0, 0 + scaledWidth, 0 + scaledHeight, null);
        } else {
            int scaledWidth = Math.max(1, dstRect.height * srcWidth / srcHeight);
            int scaledHeight = Math.max(1, dstRect.height);
            BufferedImage scaledImage = AssetUtil.scaledImage(source, scaledWidth, scaledHeight);
            g.drawImage(scaledImage, dstRect.x + (dstRect.width - scaledWidth) / 2, dstRect.y, dstRect.x + (dstRect.width - scaledWidth) / 2 + scaledWidth, dstRect.y + dstRect.height, 0, 0, 0 + scaledWidth, 0 + scaledHeight, null);
        }
    }

    public static void drawCenterCrop(Graphics2D g, BufferedImage source, Rectangle dstRect) {
        int srcHeight;
        int srcWidth = source.getWidth();
        if ((double)srcWidth * 1.0 / (double)(srcHeight = source.getHeight()) > (double)dstRect.width * 1.0 / (double)dstRect.height) {
            int scaledWidth = dstRect.height * srcWidth / srcHeight;
            int scaledHeight = dstRect.height;
            BufferedImage scaledImage = AssetUtil.scaledImage(source, scaledWidth, scaledHeight);
            g.drawImage(scaledImage, dstRect.x, dstRect.y, dstRect.x + dstRect.width, dstRect.y + dstRect.height, 0 + (scaledWidth - dstRect.width) / 2, 0, 0 + (scaledWidth - dstRect.width) / 2 + dstRect.width, 0 + dstRect.height, null);
        } else {
            int scaledWidth = dstRect.width;
            int scaledHeight = dstRect.width * srcHeight / srcWidth;
            BufferedImage scaledImage = AssetUtil.scaledImage(source, scaledWidth, scaledHeight);
            g.drawImage(scaledImage, dstRect.x, dstRect.y, dstRect.x + dstRect.width, dstRect.y + dstRect.height, 0, 0 + (scaledHeight - dstRect.height) / 2, 0 + dstRect.width, 0 + (scaledHeight - dstRect.height) / 2 + dstRect.height, null);
        }
    }

    public static class FillEffect
    extends Effect {
        public Paint paint;
        public double opacity;

        public FillEffect(Paint paint, double opacity) {
            this.paint = paint;
            this.opacity = opacity;
        }

        public FillEffect(Paint paint) {
            this.paint = paint;
            this.opacity = 1.0;
        }
    }

    public static class ShadowEffect
    extends Effect {
        public double xOffset;
        public double yOffset;
        public double radius;
        public Color color;
        public double opacity;
        public boolean inner;

        public ShadowEffect(double xOffset, double yOffset, double radius, Color color, double opacity, boolean inner) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.radius = radius;
            this.color = color;
            this.opacity = opacity;
            this.inner = inner;
        }
    }

    public static abstract class Effect {
    }
}

