/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.server;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.server.CompilationResult;
import com.sun.tools.sjavac.server.Sjavac;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.List;
import java.util.Set;

public class RequestHandler
implements Runnable {
    private final Socket socket;
    private final Sjavac sjavac;

    public RequestHandler(Socket socket, Sjavac sjavac) {
        this.socket = socket;
        this.sjavac = sjavac;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try (ObjectOutputStream oout = new ObjectOutputStream(this.socket.getOutputStream());
             ObjectInputStream oin = new ObjectInputStream(this.socket.getInputStream());){
            String id = (String)oin.readObject();
            String cmd = (String)oin.readObject();
            Log.info("Handling request, id: " + id + " cmd: " + cmd);
            switch (cmd) {
                case "sys-info": {
                    this.handleSysInfoRequest(oin, oout);
                    return;
                }
                case "compile": {
                    this.handleCompileRequest(oin, oout);
                    return;
                }
                default: {
                    Log.error("Unknown command: " + cmd);
                    return;
                }
            }
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            Log.error(sw.toString());
        }
    }

    private void handleSysInfoRequest(ObjectInputStream oin, ObjectOutputStream oout) throws IOException {
        oout.writeObject(this.sjavac.getSysInfo());
        oout.flush();
    }

    private void handleCompileRequest(ObjectInputStream oin, ObjectOutputStream oout) throws IOException {
        try {
            String protocolId = (String)oin.readObject();
            String invocationId = (String)oin.readObject();
            String[] args = (String[])oin.readObject();
            List explicitSources = (List)oin.readObject();
            Set sourcesToCompile = (Set)oin.readObject();
            Set visibleSources = (Set)oin.readObject();
            CompilationResult cr = this.sjavac.compile(protocolId, invocationId, args, explicitSources, sourcesToCompile, visibleSources);
            oout.writeObject(cr);
            oout.flush();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
    }
}

