/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="NullableConstructor", summary="Constructors should not be annotated with @Nullable since they cannot return null", explanation="Constructors never return null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class NullableConstructor
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!sym.isConstructor()) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Nullable");
        if (annotation == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(annotation, (Fix)SuggestedFix.delete((Tree)annotation));
    }
}

