/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.IncompatibleModifiers;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@BugPattern(name="IncompatibleModifiers", summary="This annotation has incompatible modifiers as specified by its @IncompatibleModifiers annotation", explanation="The @IncompatibleModifiers annotation declares that the target annotation is incompatible with a set of provided modifiers. This check ensures that all annotations respect their @IncompatibleModifiers specifications.", linkType=BugPattern.LinkType.NONE, category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class IncompatibleModifiersChecker
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String MESSAGE_TEMPLATE = "%s has specified that it should not be used together with the following modifiers: %s";
    private static final String GUAVA_ANNOTATION = "com.google.common.annotations.IncompatibleModifiers";
    private static final Function<Attribute.Enum, Modifier> TO_MODIFIER = new Function<Attribute.Enum, Modifier>(){

        public Modifier apply(Attribute.Enum input) {
            return Modifier.valueOf(input.getValue().name.toString());
        }
    };

    private static Set<Modifier> getIncompatibleModifiers(AnnotationTree tree, VisitorState state) {
        for (Attribute.Compound c : ASTHelpers.getSymbol((Tree)tree).getAnnotationMirrors()) {
            if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(GUAVA_ANNOTATION)) continue;
            List modifiers = (List)c.member(state.getName("value")).getValue();
            return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)modifiers, TO_MODIFIER));
        }
        IncompatibleModifiers annotation = (IncompatibleModifiers)ASTHelpers.getAnnotation((Tree)tree, IncompatibleModifiers.class);
        if (annotation != null) {
            return ImmutableSet.copyOf((Object[])annotation.value());
        }
        return ImmutableSet.of();
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Set<Modifier> incompatibleModifiers = IncompatibleModifiersChecker.getIncompatibleModifiers(tree, state);
        if (incompatibleModifiers.isEmpty()) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof ModifiersTree)) {
            return Description.NO_MATCH;
        }
        Sets.SetView incompatible = Sets.intersection(incompatibleModifiers, ((ModifiersTree)parent).getFlags());
        if (incompatible.isEmpty()) {
            return Description.NO_MATCH;
        }
        String annotationName = ASTHelpers.getAnnotationName((AnnotationTree)tree);
        String nameString = annotationName != null ? String.format("The annotation '@%s'", annotationName) : "This annotation";
        String customMessage = String.format(MESSAGE_TEMPLATE, nameString, incompatible.toString());
        return this.buildDescription(tree).setMessage(customMessage).build();
    }
}

