#!/bin/bash
#
# Copyright 2016 The Bazel Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Test of Bazel's startup option handling.

# Load the test setup defined in the parent directory
CURRENT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
source "${CURRENT_DIR}/../integration_test_setup.sh" \
  || { echo "integration_test_setup.sh not found!" >&2; exit 1; }

function test_different_startup_options() {
  pid=$(bazel info server_pid 2> $TEST_log)
  [[ -n $pid ]] || fail "Couldn't run ${PRODUCT_NAME}"
  newpid=$(bazel --batch info server_pid 2> $TEST_log)
  expect_log "WARNING: Running B\\(azel\\|laze\\) server needs to be killed, because the startup options are different."
  [[ "$newpid" != "$pid" ]] || fail "pid $pid was the same!"
  kill -0 $pid 2> /dev/null && fail "$pid not dead"
  kill -0 $newpid 2> /dev/null && fail "$newpid not dead"
  true
}

# Regression test for Issue #1659
function test_command_args_are_not_parsed_as_startup_args() {
  bazel info --bazelrc=bar &> $TEST_log && fail "Should fail"
  expect_log "Unrecognized option: --bazelrc=bar"
  expect_not_log "Error: Unable to read .bazelrc file"
}

run_suite "${PRODUCT_NAME} startup options test"
