/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import jdk.Exported;

@Exported
public class DocTreePath
implements Iterable<DocTree> {
    private final TreePath treePath;
    private final DocCommentTree docComment;
    private final DocTree leaf;
    private final DocTreePath parent;

    public static DocTreePath getPath(TreePath treePath, DocCommentTree docCommentTree, DocTree docTree) {
        return DocTreePath.getPath(new DocTreePath(treePath, docCommentTree), docTree);
    }

    public static DocTreePath getPath(DocTreePath docTreePath, DocTree docTree) {
        class Result
        extends Error {
            static final long serialVersionUID = -5942088234594905625L;
            DocTreePath path;

            Result(DocTreePath docTreePath) {
                this.path = docTreePath;
            }
        }
        docTreePath.getClass();
        docTree.getClass();
        if (docTreePath.getLeaf() == docTree) {
            return docTreePath;
        }
        try {
            class PathFinder
            extends DocTreePathScanner<DocTreePath, DocTree> {
                PathFinder() {
                }

                @Override
                public DocTreePath scan(DocTree docTree, DocTree docTree2) {
                    if (docTree == docTree2) {
                        throw new Result(new DocTreePath(this.getCurrentPath(), docTree2));
                    }
                    return (DocTreePath)super.scan(docTree, docTree2);
                }
            }
            new PathFinder().scan(docTreePath, docTree);
        }
        catch (Result result) {
            return result.path;
        }
        return null;
    }

    public DocTreePath(TreePath treePath, DocCommentTree docCommentTree) {
        treePath.getClass();
        docCommentTree.getClass();
        this.treePath = treePath;
        this.docComment = docCommentTree;
        this.parent = null;
        this.leaf = docCommentTree;
    }

    public DocTreePath(DocTreePath docTreePath, DocTree docTree) {
        if (docTree.getKind() == DocTree.Kind.DOC_COMMENT) {
            throw new IllegalArgumentException("Use DocTreePath(TreePath, DocCommentTree) to construct DocTreePath for a DocCommentTree.");
        }
        this.treePath = docTreePath.treePath;
        this.docComment = docTreePath.docComment;
        this.parent = docTreePath;
        this.leaf = docTree;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public DocCommentTree getDocComment() {
        return this.docComment;
    }

    public DocTree getLeaf() {
        return this.leaf;
    }

    public DocTreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<DocTree> iterator() {
        return new Iterator<DocTree>(){
            private DocTreePath next;
            {
                this.next = DocTreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DocTree next() {
                DocTree docTree = this.next.leaf;
                this.next = this.next.parent;
                return docTree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

