/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;

public class InstanceMethod
implements Matcher<ExpressionTree> {
    private final Matcher<? super ExpressionTree> receiverMatcher;
    private final String methodName;
    private final boolean isWildCard;

    public InstanceMethod(Matcher<? super ExpressionTree> receiverMatcher, String methodName) {
        this(receiverMatcher, methodName, false);
    }

    private InstanceMethod(Matcher<? super ExpressionTree> receiverMatcher, String methodName, boolean isWildCard) {
        this.receiverMatcher = receiverMatcher;
        this.methodName = methodName;
        this.isWildCard = isWildCard;
    }

    public static InstanceMethod methodReceiverMatcher(Matcher<? super ExpressionTree> receiverMatcher) {
        return new InstanceMethod(receiverMatcher, "", true);
    }

    @Override
    public boolean matches(ExpressionTree item, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(item);
        if (sym == null || sym.isStatic() || !this.isWildCard && !sym.getQualifiedName().equals(state.getName(this.methodName))) {
            return false;
        }
        if (item instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)item;
            return this.receiverMatcher.matches(fieldAccess.getExpression(), state);
        }
        if (item instanceof JCTree.JCIdent) {
            try {
                return this.receiverMatcher.matches(null, state);
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected type in InstanceMethod matcher: " + item.getClass().getName());
    }
}

