/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Preconditions;
import com.google.errorprone.dataflow.DataFlow;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.TrustingNullnessPropagation;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.Serializable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;

public final class TrustingNullnessAnalysis
implements Serializable {
    private static final Context.Key<TrustingNullnessAnalysis> TRUSTING_NULLNESS_KEY = new Context.Key();
    private final TrustingNullnessPropagation nullnessPropagation = new TrustingNullnessPropagation();

    public static TrustingNullnessAnalysis instance(Context context) {
        TrustingNullnessAnalysis instance = context.get(TRUSTING_NULLNESS_KEY);
        if (instance == null) {
            instance = new TrustingNullnessAnalysis();
            context.put(TRUSTING_NULLNESS_KEY, instance);
        }
        return instance;
    }

    private TrustingNullnessAnalysis() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Nullness getNullness(TreePath exprPath, Context context) {
        try {
            this.nullnessPropagation.setContext(context).setCompilationUnit(exprPath.getCompilationUnit());
            Nullness nullness = (Nullness)((Object)DataFlow.expressionDataflow(exprPath, context, this.nullnessPropagation));
            return nullness;
        }
        finally {
            this.nullnessPropagation.setContext(null).setCompilationUnit(null);
        }
    }

    public Nullness getFieldInitializerNullness(TreePath fieldDeclPath, Context context) {
        Tree decl = fieldDeclPath.getLeaf();
        Preconditions.checkArgument((decl instanceof VariableTree && ((JCTree.JCVariableDecl)decl).sym.getKind() == ElementKind.FIELD ? 1 : 0) != 0, (String)"Leaf of fieldDeclPath must be a field declaration: %s", (Object)decl);
        ExpressionTree initializer = ((VariableTree)decl).getInitializer();
        if (initializer == null) {
            return ((JCTree.JCVariableDecl)decl).type.isPrimitive() ? Nullness.NONNULL : Nullness.NULL;
        }
        TreePath initializerPath = TreePath.getPath(fieldDeclPath, (Tree)initializer);
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(context);
        UnderlyingAST.CFGStatement ast = new UnderlyingAST.CFGStatement(decl);
        ControlFlowGraph cfg = CFGBuilder.build((TreePath)initializerPath, (ProcessingEnvironment)javacEnv, (UnderlyingAST)ast, (boolean)false, (boolean)false);
        Analysis analysis = new Analysis((ProcessingEnvironment)javacEnv, (TransferFunction)this.nullnessPropagation);
        analysis.performAnalysis(cfg);
        return (Nullness)analysis.getValue((Tree)initializer);
    }

    public static boolean hasNullableAnnotation(Element element) {
        return TrustingNullnessPropagation.nullnessFromAnnotations(element) == Nullness.NULLABLE;
    }
}

