/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.errorprone.apply.ImportOrganizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class BasicImportOrganizer
implements ImportOrganizer {
    private final Comparator<String> comparator;

    BasicImportOrganizer(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    private static boolean isStatic(String importString) {
        return importString.startsWith("import static ");
    }

    static Comparator<String> staticFirst() {
        return new Ordering<String>(){

            public int compare(String s1, String s2) {
                return ComparisonChain.start().compareTrueFirst(BasicImportOrganizer.isStatic(s1), BasicImportOrganizer.isStatic(s2)).compare((Comparable)((Object)s1), (Comparable)((Object)s2)).result();
            }
        };
    }

    static Comparator<String> staticLast() {
        return new Ordering<String>(){

            public int compare(String s1, String s2) {
                return ComparisonChain.start().compareFalseFirst(BasicImportOrganizer.isStatic(s1), BasicImportOrganizer.isStatic(s2)).compare((Comparable)((Object)s1), (Comparable)((Object)s2)).result();
            }
        };
    }

    @Override
    public Iterable<String> organizeImports(Iterable<String> importStrings) {
        TreeSet<String> sorted = new TreeSet<String>(this.comparator);
        Iterables.addAll(sorted, importStrings);
        ArrayList<String> organized = new ArrayList<String>();
        boolean first = true;
        boolean prevIsStatic = true;
        for (String importString : sorted) {
            boolean isStatic = BasicImportOrganizer.isStatic(importString);
            if (!first && prevIsStatic != isStatic) {
                organized.add("");
            }
            organized.add(importString);
            prevIsStatic = isStatic;
            first = false;
        }
        return organized;
    }
}

