/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.errorprone.AutoValue_RefactoringCollection_RefactoringResult;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.JavacErrorDescriptionListener;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.DiffApplier;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.FileSource;
import com.google.errorprone.apply.FsFileDestination;
import com.google.errorprone.apply.FsFileSource;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.PatchFileDestination;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

class RefactoringCollection
implements DescriptionListener.Factory {
    private final Multimap<URI, DelegatingDescriptionListener> foundSources = HashMultimap.create();
    private final AtomicBoolean foundMatches = new AtomicBoolean(false);
    private final Path rootPath;
    private final FileDestination fileDestination;
    private final Callable<RefactoringResult> postProcess;
    private final DescriptionListener.Factory descriptionsFactory;
    private final ImportOrganizer importOrganizer;

    static RefactoringCollection refactor(ErrorProneOptions.PatchingOptions patchingOptions) {
        Callable<RefactoringResult> postProcess;
        FileDestination fileDestination;
        Path rootPath = RefactoringCollection.buildRootPath();
        if (patchingOptions.inPlace()) {
            fileDestination = new FsFileDestination(rootPath);
            postProcess = () -> RefactoringResult.create("Refactoring changes were successfully applied, please check the refactored code and recompile.", RefactoringResultType.CHANGED);
        } else {
            Path baseDir = rootPath.resolve(patchingOptions.baseDirectory());
            Path patchFilePath = baseDir.resolve("error-prone.patch");
            PatchFileDestination patchFileDestination = new PatchFileDestination(baseDir, rootPath);
            postProcess = () -> {
                try {
                    RefactoringCollection.writePatchFile(patchFileDestination, patchFilePath);
                    return RefactoringResult.create("Changes were written to " + patchFilePath + ". Please inspect the file and apply with: patch -p0 -u -i error-prone.patch", RefactoringResultType.CHANGED);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to emit patch file!", e);
                }
            };
            fileDestination = patchFileDestination;
        }
        ImportOrganizer importOrganizer = patchingOptions.importOrganizer();
        return new RefactoringCollection(rootPath, fileDestination, postProcess, importOrganizer);
    }

    private RefactoringCollection(Path rootPath, FileDestination fileDestination, Callable<RefactoringResult> postProcess, ImportOrganizer importOrganizer) {
        this.rootPath = rootPath;
        this.fileDestination = fileDestination;
        this.postProcess = postProcess;
        this.descriptionsFactory = JavacErrorDescriptionListener.providerForRefactoring();
        this.importOrganizer = importOrganizer;
    }

    private static Path buildRootPath() {
        Path root = (Path)Iterables.getFirst(FileSystems.getDefault().getRootDirectories(), null);
        if (root == null) {
            throw new RuntimeException("Can't find a root filesystem!");
        }
        return root;
    }

    @Override
    public DescriptionListener getDescriptionListener(Log log, JCTree.JCCompilationUnit compilation) {
        URI sourceFile = compilation.getSourceFile().toUri();
        DelegatingDescriptionListener delegate = new DelegatingDescriptionListener(this.descriptionsFactory.getDescriptionListener(log, compilation), DescriptionBasedDiff.createIgnoringOverlaps(compilation, this.importOrganizer));
        this.foundSources.put((Object)sourceFile, (Object)delegate);
        return delegate;
    }

    RefactoringResult applyChanges() throws Exception {
        if (!this.foundMatches.get()) {
            return RefactoringResult.create("", RefactoringResultType.NO_CHANGES);
        }
        this.doApplyProcess(this.fileDestination, new FsFileSource(this.rootPath));
        return this.postProcess.call();
    }

    private static void writePatchFile(PatchFileDestination fileDestination, Path patchFilePatch) throws IOException {
        String patchFile = fileDestination.patchFile();
        if (!patchFile.isEmpty()) {
            Files.write(patchFilePatch, patchFile.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    private void doApplyProcess(FileDestination fileDestination, FileSource fileSource) {
        DiffApplier diffApplier = new DiffApplier(4, fileSource, fileDestination);
        diffApplier.startAsync().awaitRunning();
        ArrayList futures = new ArrayList();
        for (DelegatingDescriptionListener delegatingDescriptionListener : this.foundSources.values()) {
            futures.add(diffApplier.put(delegatingDescriptionListener.base));
        }
        diffApplier.stopAsync().awaitTerminated();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private final class DelegatingDescriptionListener
    implements DescriptionListener {
        final DescriptionBasedDiff base;
        final DescriptionListener listener;

        DelegatingDescriptionListener(DescriptionListener listener, DescriptionBasedDiff base) {
            this.listener = listener;
            this.base = base;
        }

        @Override
        public void onDescribed(Description description) {
            RefactoringCollection.this.foundMatches.set(true);
            this.listener.onDescribed(description);
            this.base.onDescribed(description);
        }
    }

    static enum RefactoringResultType {
        NO_CHANGES,
        CHANGED;

    }

    static abstract class RefactoringResult {
        RefactoringResult() {
        }

        abstract String message();

        abstract RefactoringResultType type();

        private static RefactoringResult create(String message, RefactoringResultType type) {
            return new AutoValue_RefactoringCollection_RefactoringResult(message, type);
        }
    }
}

